package org.lockss.laaws.poller.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.lockss.laaws.poller.model.PeerData;
import org.lockss.util.rest.poller.PollDesc;
import org.lockss.laaws.poller.model.RepairQueue;
import org.lockss.laaws.poller.model.TallyData;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * The details of a poll being performed or queued by the Poller
 */
@ApiModel(description = "The details of a poll being performed or queued by the Poller")
@Validated




public class PollerDetail   {
  @JsonProperty("pollDesc")
  private PollDesc pollDesc = null;

  @JsonProperty("pollerId")
  private String pollerId = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("pollKey")
  private String pollKey = null;

  @JsonProperty("createTime")
  private Long createTime = null;

  @JsonProperty("duration")
  private Long duration = null;

  @JsonProperty("deadline")
  private Long deadline = null;

  @JsonProperty("outerCircleTarget")
  private Integer outerCircleTarget = null;

  @JsonProperty("hashAlgorithm")
  private String hashAlgorithm = null;

  @JsonProperty("voteMargin")
  private Integer voteMargin = null;

  @JsonProperty("voteDeadline")
  private Long voteDeadline = null;

  @JsonProperty("voteDuration")
  private Long voteDuration = null;

  @JsonProperty("pollEnd")
  private Long pollEnd = null;

  @JsonProperty("quorum")
  private Integer quorum = null;

  @JsonProperty("errorDetails")
  private String errorDetails = null;

  @JsonProperty("votedPeers")
  @Valid
  private List<PeerData> votedPeers = null;

  @JsonProperty("noAuPeers")
  @Valid
  private List<String> noAuPeers = null;

  @JsonProperty("tally")
  private TallyData tally = null;

  @JsonProperty("repairQueue")
  private RepairQueue repairQueue = null;

  public PollerDetail pollDesc(PollDesc pollDesc) {
    this.pollDesc = pollDesc;
    return this;
  }

  /**
   * Get pollDesc
   * @return pollDesc
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public PollDesc getPollDesc() {
    return pollDesc;
  }

  public void setPollDesc(PollDesc pollDesc) {
    this.pollDesc = pollDesc;
  }

  public PollerDetail pollerId(String pollerId) {
    this.pollerId = pollerId;
    return this;
  }

  /**
   * The id of the poller who called the poll
   * @return pollerId
  **/
  @ApiModelProperty(required = true, value = "The id of the poller who called the poll")
  @NotNull


  public String getPollerId() {
    return pollerId;
  }

  public void setPollerId(String pollerId) {
    this.pollerId = pollerId;
  }

  public PollerDetail status(String status) {
    this.status = status;
    return this;
  }

  /**
   * The current status of the poll.
   * @return status
  **/
  @ApiModelProperty(required = true, value = "The current status of the poll.")
  @NotNull


  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public PollerDetail pollKey(String pollKey) {
    this.pollKey = pollKey;
    return this;
  }

  /**
   * Key generated by poll manager when poll is created.
   * @return pollKey
  **/
  @ApiModelProperty(value = "Key generated by poll manager when poll is created.")


  public String getPollKey() {
    return pollKey;
  }

  public void setPollKey(String pollKey) {
    this.pollKey = pollKey;
  }

  public PollerDetail createTime(Long createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * The timestamp  at which the poll was created.
   * @return createTime
  **/
  @ApiModelProperty(value = "The timestamp  at which the poll was created.")


  public Long getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Long createTime) {
    this.createTime = createTime;
  }

  public PollerDetail duration(Long duration) {
    this.duration = duration;
    return this;
  }

  /**
   * The estimated duration for the poll.
   * @return duration
  **/
  @ApiModelProperty(value = "The estimated duration for the poll.")


  public Long getDuration() {
    return duration;
  }

  public void setDuration(Long duration) {
    this.duration = duration;
  }

  public PollerDetail deadline(Long deadline) {
    this.deadline = deadline;
    return this;
  }

  /**
   * The time by which the poll must have completed
   * @return deadline
  **/
  @ApiModelProperty(value = "The time by which the poll must have completed")


  public Long getDeadline() {
    return deadline;
  }

  public void setDeadline(Long deadline) {
    this.deadline = deadline;
  }

  public PollerDetail outerCircleTarget(Integer outerCircleTarget) {
    this.outerCircleTarget = outerCircleTarget;
    return this;
  }

  /**
   * The number of peers from the poller outer circle to taget.
   * @return outerCircleTarget
  **/
  @ApiModelProperty(value = "The number of peers from the poller outer circle to taget.")


  public Integer getOuterCircleTarget() {
    return outerCircleTarget;
  }

  public void setOuterCircleTarget(Integer outerCircleTarget) {
    this.outerCircleTarget = outerCircleTarget;
  }

  public PollerDetail hashAlgorithm(String hashAlgorithm) {
    this.hashAlgorithm = hashAlgorithm;
    return this;
  }

  /**
   * The algorithm used by the hasher for this poll.
   * @return hashAlgorithm
  **/
  @ApiModelProperty(value = "The algorithm used by the hasher for this poll.")


  public String getHashAlgorithm() {
    return hashAlgorithm;
  }

  public void setHashAlgorithm(String hashAlgorithm) {
    this.hashAlgorithm = hashAlgorithm;
  }

  public PollerDetail voteMargin(Integer voteMargin) {
    this.voteMargin = voteMargin;
    return this;
  }

  /**
   * The required agreement need to decide landslide agreement or disagreement.
   * @return voteMargin
  **/
  @ApiModelProperty(value = "The required agreement need to decide landslide agreement or disagreement.")


  public Integer getVoteMargin() {
    return voteMargin;
  }

  public void setVoteMargin(Integer voteMargin) {
    this.voteMargin = voteMargin;
  }

  public PollerDetail voteDeadline(Long voteDeadline) {
    this.voteDeadline = voteDeadline;
    return this;
  }

  /**
   * The  time by which all voters must have voted.
   * @return voteDeadline
  **/
  @ApiModelProperty(value = "The  time by which all voters must have voted.")


  public Long getVoteDeadline() {
    return voteDeadline;
  }

  public void setVoteDeadline(Long voteDeadline) {
    this.voteDeadline = voteDeadline;
  }

  public PollerDetail voteDuration(Long voteDuration) {
    this.voteDuration = voteDuration;
    return this;
  }

  /**
   * The  estimated duration for voters.
   * @return voteDuration
  **/
  @ApiModelProperty(value = "The  estimated duration for voters.")


  public Long getVoteDuration() {
    return voteDuration;
  }

  public void setVoteDuration(Long voteDuration) {
    this.voteDuration = voteDuration;
  }

  public PollerDetail pollEnd(Long pollEnd) {
    this.pollEnd = pollEnd;
    return this;
  }

  /**
   * the time at which the poll ended or -1 if still running.
   * @return pollEnd
  **/
  @ApiModelProperty(value = "the time at which the poll ended or -1 if still running.")


  public Long getPollEnd() {
    return pollEnd;
  }

  public void setPollEnd(Long pollEnd) {
    this.pollEnd = pollEnd;
  }

  public PollerDetail quorum(Integer quorum) {
    this.quorum = quorum;
    return this;
  }

  /**
   * The minimum required for a quroum
   * @return quorum
  **/
  @ApiModelProperty(value = "The minimum required for a quroum")


  public Integer getQuorum() {
    return quorum;
  }

  public void setQuorum(Integer quorum) {
    this.quorum = quorum;
  }

  public PollerDetail errorDetails(String errorDetails) {
    this.errorDetails = errorDetails;
    return this;
  }

  /**
   * The error which caused the poll to fail.
   * @return errorDetails
  **/
  @ApiModelProperty(value = "The error which caused the poll to fail.")


  public String getErrorDetails() {
    return errorDetails;
  }

  public void setErrorDetails(String errorDetails) {
    this.errorDetails = errorDetails;
  }

  public PollerDetail votedPeers(List<PeerData> votedPeers) {
    this.votedPeers = votedPeers;
    return this;
  }

  public PollerDetail addVotedPeersItem(PeerData votedPeersItem) {
    if (this.votedPeers == null) {
      this.votedPeers = new ArrayList<>();
    }
    this.votedPeers.add(votedPeersItem);
    return this;
  }

  /**
   * The data from peers whom voted.
   * @return votedPeers
  **/
  @ApiModelProperty(value = "The data from peers whom voted.")

  @Valid

  public List<PeerData> getVotedPeers() {
    return votedPeers;
  }

  public void setVotedPeers(List<PeerData> votedPeers) {
    this.votedPeers = votedPeers;
  }

  public PollerDetail noAuPeers(List<String> noAuPeers) {
    this.noAuPeers = noAuPeers;
    return this;
  }

  public PollerDetail addNoAuPeersItem(String noAuPeersItem) {
    if (this.noAuPeers == null) {
      this.noAuPeers = new ArrayList<>();
    }
    this.noAuPeers.add(noAuPeersItem);
    return this;
  }

  /**
   * The peers who do not have the au.
   * @return noAuPeers
  **/
  @ApiModelProperty(value = "The peers who do not have the au.")


  public List<String> getNoAuPeers() {
    return noAuPeers;
  }

  public void setNoAuPeers(List<String> noAuPeers) {
    this.noAuPeers = noAuPeers;
  }

  public PollerDetail tally(TallyData tally) {
    this.tally = tally;
    return this;
  }

  /**
   * Get tally
   * @return tally
  **/
  @ApiModelProperty(value = "")

  @Valid

  public TallyData getTally() {
    return tally;
  }

  public void setTally(TallyData tally) {
    this.tally = tally;
  }

  public PollerDetail repairQueue(RepairQueue repairQueue) {
    this.repairQueue = repairQueue;
    return this;
  }

  /**
   * Get repairQueue
   * @return repairQueue
  **/
  @ApiModelProperty(value = "")

  @Valid

  public RepairQueue getRepairQueue() {
    return repairQueue;
  }

  public void setRepairQueue(RepairQueue repairQueue) {
    this.repairQueue = repairQueue;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PollerDetail pollerDetail = (PollerDetail) o;
    return Objects.equals(this.pollDesc, pollerDetail.pollDesc) &&
        Objects.equals(this.pollerId, pollerDetail.pollerId) &&
        Objects.equals(this.status, pollerDetail.status) &&
        Objects.equals(this.pollKey, pollerDetail.pollKey) &&
        Objects.equals(this.createTime, pollerDetail.createTime) &&
        Objects.equals(this.duration, pollerDetail.duration) &&
        Objects.equals(this.deadline, pollerDetail.deadline) &&
        Objects.equals(this.outerCircleTarget, pollerDetail.outerCircleTarget) &&
        Objects.equals(this.hashAlgorithm, pollerDetail.hashAlgorithm) &&
        Objects.equals(this.voteMargin, pollerDetail.voteMargin) &&
        Objects.equals(this.voteDeadline, pollerDetail.voteDeadline) &&
        Objects.equals(this.voteDuration, pollerDetail.voteDuration) &&
        Objects.equals(this.pollEnd, pollerDetail.pollEnd) &&
        Objects.equals(this.quorum, pollerDetail.quorum) &&
        Objects.equals(this.errorDetails, pollerDetail.errorDetails) &&
        Objects.equals(this.votedPeers, pollerDetail.votedPeers) &&
        Objects.equals(this.noAuPeers, pollerDetail.noAuPeers) &&
        Objects.equals(this.tally, pollerDetail.tally) &&
        Objects.equals(this.repairQueue, pollerDetail.repairQueue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pollDesc, pollerId, status, pollKey, createTime, duration, deadline, outerCircleTarget, hashAlgorithm, voteMargin, voteDeadline, voteDuration, pollEnd, quorum, errorDetails, votedPeers, noAuPeers, tally, repairQueue);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PollerDetail {\n");
    
    sb.append("    pollDesc: ").append(toIndentedString(pollDesc)).append("\n");
    sb.append("    pollerId: ").append(toIndentedString(pollerId)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    pollKey: ").append(toIndentedString(pollKey)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    deadline: ").append(toIndentedString(deadline)).append("\n");
    sb.append("    outerCircleTarget: ").append(toIndentedString(outerCircleTarget)).append("\n");
    sb.append("    hashAlgorithm: ").append(toIndentedString(hashAlgorithm)).append("\n");
    sb.append("    voteMargin: ").append(toIndentedString(voteMargin)).append("\n");
    sb.append("    voteDeadline: ").append(toIndentedString(voteDeadline)).append("\n");
    sb.append("    voteDuration: ").append(toIndentedString(voteDuration)).append("\n");
    sb.append("    pollEnd: ").append(toIndentedString(pollEnd)).append("\n");
    sb.append("    quorum: ").append(toIndentedString(quorum)).append("\n");
    sb.append("    errorDetails: ").append(toIndentedString(errorDetails)).append("\n");
    sb.append("    votedPeers: ").append(toIndentedString(votedPeers)).append("\n");
    sb.append("    noAuPeers: ").append(toIndentedString(noAuPeers)).append("\n");
    sb.append("    tally: ").append(toIndentedString(tally)).append("\n");
    sb.append("    repairQueue: ").append(toIndentedString(repairQueue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

