/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.lockss.laaws.poller.api.VotesApiDelegate;
import org.lockss.ws.entities.VoteWsResult;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="votes", description="the votes API")
@RequestMapping(value={""})
public interface VotesApi {
    public VotesApiDelegate getDelegate();

    @ApiOperation(value="Query for vote properties", nickname="getVotes", notes="Query for votes that meet a set of specified conditions", response=VoteWsResult.class, responseContainer="List", authorizations={@Authorization(value="basicAuth")}, tags={"service"})
    @ApiResponses(value={@ApiResponse(code=200, message="Information about the requested votes", response=VoteWsResult.class, responseContainer="List"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/votes"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<List<VoteWsResult>> getVotes(@NotNull @ApiParam(value="The query that specifies the votes to be returned", required=true) @Valid @RequestParam(value="voteQuery", required=true) String voteQuery) {
        return this.getDelegate().getVotes(voteQuery);
    }
}

