/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Optional;
import javax.activation.FileDataSource;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.util.Supplier;
import org.lockss.app.LockssDaemon;
import org.lockss.config.RestConfigClient;
import org.lockss.exporter.Exporter;
import org.lockss.importer.Importer;
import org.lockss.laaws.poller.api.AusApiDelegate;
import org.lockss.laaws.rs.util.NamedInputStreamResource;
import org.lockss.log.L4JLogger;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.spring.error.LockssRestServiceException;
import org.lockss.util.io.FileUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AusApiServiceImpl
extends BaseSpringApiServiceImpl
implements AusApiDelegate {
    private static L4JLogger log = L4JLogger.getLogger();
    private static final String EXPORT_DIR_KEY = "repo.export.directory";
    private static final String EXPORT_DIR_UNSET_VALUE = "export";
    private final ObjectMapper objectMapper;
    private final HttpServletRequest request;
    @Value(value="${repo.export.directory:export}")
    private String configExportDir;

    @Autowired
    public AusApiServiceImpl(ObjectMapper objectMapper, HttpServletRequest request) {
        this.objectMapper = objectMapper;
        this.request = request;
    }

    public ResponseEntity getExportFiles(String auid, String fileType, Boolean isCompress, Boolean isExcludeDirNodes, String xlateFilenames, String filePrefix, Long maxSize, Integer maxVersions) {
        String parsedRequest = String.format("auid: %s, fileType: %s, isCompress: %s, isExcludeDirNodes: %s, xlateFilenames: %s, filePrefix: %s, maxSize: %s, maxVersions: %s, requestUrl: %s", auid, fileType, isCompress, isExcludeDirNodes, xlateFilenames, filePrefix, maxSize, maxVersions, this.getFullRequestUrl(this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        try {
            LockssDaemon daemon = LockssDaemon.getLockssDaemon();
            ArchivalUnit au = daemon.getPluginManager().getAuFromId(auid);
            log.trace("au = {}", (Object)au);
            if (au == null) {
                String errorMessage = "The archival unit does not exist";
                log.warn(errorMessage);
                log.warn("Parsed request: {}", (Object)parsedRequest);
                throw new LockssRestServiceException(HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
            }
            Exporter exp = null;
            switch (fileType) {
                case "WARC_RESPONSE": {
                    exp = Exporter.Type.WARC_RESPONSE.makeExporter(daemon, au);
                    break;
                }
                case "ARC_RESPONSE": {
                    exp = Exporter.Type.ARC_RESPONSE.makeExporter(daemon, au);
                    break;
                }
                case "WARC_RESOURCE": {
                    exp = Exporter.Type.WARC_RESOURCE.makeExporter(daemon, au);
                    break;
                }
                case "ARC_RESOURCE": {
                    exp = Exporter.Type.ARC_RESOURCE.makeExporter(daemon, au);
                    break;
                }
                case "ZIP": {
                    exp = Exporter.Type.ZIP.makeExporter(daemon, au);
                    break;
                }
                default: {
                    String errorMessage = "Invalid fileType '" + fileType + "': It must be one of 'WARC_RESPONSE', 'ARC_RESPONSE', 'WARC_RESOURCE', 'ARC_RESOURCE' or 'ZIP'";
                    log.warn(errorMessage);
                    log.warn("Parsed request: {}", (Object)parsedRequest);
                    throw new LockssRestServiceException(HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
                }
            }
            File exportdir = new File(this.configExportDir);
            log.trace("exportdir = {}", (Object)exportdir);
            if (!exportdir.exists() && !FileUtil.ensureDirExists((File)exportdir)) {
                throw new IOException("Could not create export directory " + exportdir);
            }
            exp.setDir(exportdir);
            exp.setCompress(isCompress.booleanValue());
            exp.setExcludeDirNodes(isExcludeDirNodes.booleanValue());
            switch (xlateFilenames) {
                case "XLATE_MAC": {
                    exp.setFilenameTranslation(Exporter.FilenameTranslation.XLATE_MAC);
                    break;
                }
                case "XLATE_WINDOWS": {
                    exp.setFilenameTranslation(Exporter.FilenameTranslation.XLATE_WINDOWS);
                    break;
                }
                case "XLATE_NONE": {
                    exp.setFilenameTranslation(Exporter.FilenameTranslation.XLATE_NONE);
                    break;
                }
                default: {
                    String errorMessage = "Invalid xlateFilenames '" + xlateFilenames + "': It must be one of 'XLATE_MAC', 'XLATE_WINDOWS' or 'XLATE_NONE'";
                    log.warn(errorMessage);
                    log.warn("Parsed request: {}", (Object)parsedRequest);
                    throw new LockssRestServiceException(HttpStatus.BAD_REQUEST, errorMessage, parsedRequest);
                }
            }
            exp.setPrefix(filePrefix);
            if (maxSize > 0L) {
                exp.setMaxSize(maxSize * 1024L * 1024L);
            }
            if (maxVersions > 0) {
                exp.setMaxVersions(maxVersions.intValue());
            }
            exp.export();
            List exportFiles = exp.getExportFiles();
            log.trace("exportFiles = {}", (Object)exportFiles);
            int exportFilesCount = exportFiles.size();
            log.trace("exportFilesCount = {}", (Object)exportFilesCount);
            LinkedMultiValueMap parts = new LinkedMultiValueMap();
            for (int i = 0; i < exportFilesCount; ++i) {
                log.trace("Processing export file {} of {}...", (Object)(i + 1), (Object)exportFilesCount);
                FileDataSource fileDS = new FileDataSource((File)exportFiles.get(i));
                String name = fileDS.getName();
                log.trace("name = {}", (Object)name);
                long size = fileDS.getFile().length();
                log.trace("size = {}", (Object)size);
                HttpHeaders partHeaders = new HttpHeaders();
                partHeaders.setContentLength(size);
                log.trace("partHeaders = {}", new Supplier[]{() -> partHeaders});
                NamedInputStreamResource resource = new NamedInputStreamResource(name, fileDS.getInputStream());
                parts.add((Object)RestConfigClient.CONFIG_PART_NAME, (Object)new HttpEntity((Object)resource, (MultiValueMap)partHeaders));
                log.trace("parts.size() = {}", (Object)parts.size());
            }
            log.debug2("Done exporting {} files", (Object)exportFilesCount);
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.setContentType(MediaType.MULTIPART_FORM_DATA);
            log.trace("responseHeaders = {}", new Supplier[]{() -> responseHeaders});
            HttpStatus status = HttpStatus.OK;
            log.trace("status = {}", new Supplier[]{() -> status});
            return new ResponseEntity((Object)parts, (MultiValueMap)responseHeaders, status);
        }
        catch (LockssRestServiceException lre) {
            throw lre;
        }
        catch (Exception e) {
            String errorMessage = "Unexpected exception caught while attempting to export files";
            log.warn(errorMessage, (Throwable)e);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e, parsedRequest);
        }
    }

    public ResponseEntity<Void> putImportFile(String targetBaseUrlPath, String targetUrl, MultipartFile file, List<String> userProperties) {
        String parsedRequest = String.format("targetBaseUrlPath: %s, targetUrl: %s, content.getName(): %s, content.getSize(): %s, userProperties: %s, requestUrl: %s", targetBaseUrlPath, targetUrl, file.getName(), file.getSize(), userProperties, this.getFullRequestUrl(this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        try {
            new Importer().importFile(file.getInputStream(), targetBaseUrlPath, targetUrl, userProperties);
            return new ResponseEntity(null, null, HttpStatus.OK);
        }
        catch (IllegalArgumentException | IllegalStateException | NoSuchAlgorithmException e) {
            String errorMessage = "Exception caught trying to import file";
            log.warn(errorMessage, (Throwable)e);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(HttpStatus.BAD_REQUEST, errorMessage, (Throwable)e, parsedRequest);
        }
        catch (Exception e) {
            String errorMessage = "Unexpected exception caught trying to import file";
            log.warn(errorMessage, (Throwable)e);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e, parsedRequest);
        }
    }

    public Optional<ObjectMapper> getObjectMapper() {
        return Optional.ofNullable(this.objectMapper);
    }

    public Optional<HttpServletRequest> getRequest() {
        return Optional.ofNullable(this.request);
    }

    private String getFullRequestUrl(HttpServletRequest request) {
        if (request.getQueryString() == null || request.getQueryString().trim().isEmpty()) {
            return "'" + request.getMethod() + " " + request.getRequestURL() + "'";
        }
        return "'" + request.getMethod() + " " + request.getRequestURL() + "?" + request.getQueryString() + "'";
    }
}

