/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.impl;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryResults;
import org.lockss.laaws.poller.api.VotesApiDelegate;
import org.lockss.laaws.poller.impl.VoteHelper;
import org.lockss.log.L4JLogger;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.util.josql.JosqlUtil;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class VotesApiServiceImpl
extends BaseSpringApiServiceImpl
implements VotesApiDelegate {
    private static L4JLogger log = L4JLogger.getLogger();

    public ResponseEntity getVotes(String voteQuery) {
        log.debug2("voteQuery = {}", (Object)voteQuery);
        VoteHelper voteHelper = new VoteHelper();
        List results = null;
        try {
            String fullQuery = JosqlUtil.createFullQuery((String)voteQuery, (String)VoteHelper.SOURCE_FQCN, (Set)VoteHelper.PROPERTY_NAMES, (String)VoteHelper.RESULT_FQCN);
            log.trace("fullQuery = {}", (Object)fullQuery);
            Query q = new Query();
            try {
                q.parse(fullQuery);
                QueryResults qr = q.execute(voteHelper.createUniverse());
                results = qr.getResults();
                log.trace("results.size() = {}" + results.size());
                log.trace("results = {}", (Object)voteHelper.nonDefaultToString((Collection)results));
                return new ResponseEntity((Object)results, HttpStatus.OK);
            }
            catch (QueryExecutionException qee) {
                String message = "Cannot getVotes() for voteQuery = '" + voteQuery + "'";
                log.error(message, (Throwable)qee);
                return new ResponseEntity((Object)message, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        catch (Exception e) {
            String message = "Cannot getVotes() for voteQuery = '" + voteQuery + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

