/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.lockss.laaws.poller.model.PeerData;
import org.lockss.laaws.poller.model.RepairQueue;
import org.lockss.laaws.poller.model.TallyData;
import org.lockss.util.rest.poller.PollDesc;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="The details of a poll being performed or queued by the Poller")
@Validated
public class PollerDetail {
    @JsonProperty(value="pollDesc")
    private PollDesc pollDesc = null;
    @JsonProperty(value="pollerId")
    private String pollerId = null;
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="pollKey")
    private String pollKey = null;
    @JsonProperty(value="createTime")
    private Long createTime = null;
    @JsonProperty(value="duration")
    private Long duration = null;
    @JsonProperty(value="deadline")
    private Long deadline = null;
    @JsonProperty(value="outerCircleTarget")
    private Integer outerCircleTarget = null;
    @JsonProperty(value="hashAlgorithm")
    private String hashAlgorithm = null;
    @JsonProperty(value="voteMargin")
    private Integer voteMargin = null;
    @JsonProperty(value="voteDeadline")
    private Long voteDeadline = null;
    @JsonProperty(value="voteDuration")
    private Long voteDuration = null;
    @JsonProperty(value="pollEnd")
    private Long pollEnd = null;
    @JsonProperty(value="quorum")
    private Integer quorum = null;
    @JsonProperty(value="errorDetails")
    private String errorDetails = null;
    @JsonProperty(value="votedPeers")
    @Valid
    private List<PeerData> votedPeers = null;
    @JsonProperty(value="noAuPeers")
    @Valid
    private List<String> noAuPeers = null;
    @JsonProperty(value="tally")
    private TallyData tally = null;
    @JsonProperty(value="repairQueue")
    private RepairQueue repairQueue = null;

    public PollerDetail pollDesc(PollDesc pollDesc) {
        this.pollDesc = pollDesc;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public PollDesc getPollDesc() {
        return this.pollDesc;
    }

    public void setPollDesc(PollDesc pollDesc) {
        this.pollDesc = pollDesc;
    }

    public PollerDetail pollerId(String pollerId) {
        this.pollerId = pollerId;
        return this;
    }

    @ApiModelProperty(required=true, value="The id of the poller who called the poll")
    @NotNull
    public String getPollerId() {
        return this.pollerId;
    }

    public void setPollerId(String pollerId) {
        this.pollerId = pollerId;
    }

    public PollerDetail status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The current status of the poll.")
    @NotNull
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public PollerDetail pollKey(String pollKey) {
        this.pollKey = pollKey;
        return this;
    }

    @ApiModelProperty(value="Key generated by poll manager when poll is created.")
    public String getPollKey() {
        return this.pollKey;
    }

    public void setPollKey(String pollKey) {
        this.pollKey = pollKey;
    }

    public PollerDetail createTime(Long createTime) {
        this.createTime = createTime;
        return this;
    }

    @ApiModelProperty(value="The timestamp  at which the poll was created.")
    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public PollerDetail duration(Long duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(value="The estimated duration for the poll.")
    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public PollerDetail deadline(Long deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(value="The time by which the poll must have completed")
    public Long getDeadline() {
        return this.deadline;
    }

    public void setDeadline(Long deadline) {
        this.deadline = deadline;
    }

    public PollerDetail outerCircleTarget(Integer outerCircleTarget) {
        this.outerCircleTarget = outerCircleTarget;
        return this;
    }

    @ApiModelProperty(value="The number of peers from the poller outer circle to taget.")
    public Integer getOuterCircleTarget() {
        return this.outerCircleTarget;
    }

    public void setOuterCircleTarget(Integer outerCircleTarget) {
        this.outerCircleTarget = outerCircleTarget;
    }

    public PollerDetail hashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
        return this;
    }

    @ApiModelProperty(value="The algorithm used by the hasher for this poll.")
    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public PollerDetail voteMargin(Integer voteMargin) {
        this.voteMargin = voteMargin;
        return this;
    }

    @ApiModelProperty(value="The required agreement need to decide landslide agreement or disagreement.")
    public Integer getVoteMargin() {
        return this.voteMargin;
    }

    public void setVoteMargin(Integer voteMargin) {
        this.voteMargin = voteMargin;
    }

    public PollerDetail voteDeadline(Long voteDeadline) {
        this.voteDeadline = voteDeadline;
        return this;
    }

    @ApiModelProperty(value="The  time by which all voters must have voted.")
    public Long getVoteDeadline() {
        return this.voteDeadline;
    }

    public void setVoteDeadline(Long voteDeadline) {
        this.voteDeadline = voteDeadline;
    }

    public PollerDetail voteDuration(Long voteDuration) {
        this.voteDuration = voteDuration;
        return this;
    }

    @ApiModelProperty(value="The  estimated duration for voters.")
    public Long getVoteDuration() {
        return this.voteDuration;
    }

    public void setVoteDuration(Long voteDuration) {
        this.voteDuration = voteDuration;
    }

    public PollerDetail pollEnd(Long pollEnd) {
        this.pollEnd = pollEnd;
        return this;
    }

    @ApiModelProperty(value="the time at which the poll ended or -1 if still running.")
    public Long getPollEnd() {
        return this.pollEnd;
    }

    public void setPollEnd(Long pollEnd) {
        this.pollEnd = pollEnd;
    }

    public PollerDetail quorum(Integer quorum) {
        this.quorum = quorum;
        return this;
    }

    @ApiModelProperty(value="The minimum required for a quroum")
    public Integer getQuorum() {
        return this.quorum;
    }

    public void setQuorum(Integer quorum) {
        this.quorum = quorum;
    }

    public PollerDetail errorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @ApiModelProperty(value="The error which caused the poll to fail.")
    public String getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
    }

    public PollerDetail votedPeers(List<PeerData> votedPeers) {
        this.votedPeers = votedPeers;
        return this;
    }

    public PollerDetail addVotedPeersItem(PeerData votedPeersItem) {
        if (this.votedPeers == null) {
            this.votedPeers = new ArrayList();
        }
        this.votedPeers.add(votedPeersItem);
        return this;
    }

    @ApiModelProperty(value="The data from peers whom voted.")
    @Valid
    public List<PeerData> getVotedPeers() {
        return this.votedPeers;
    }

    public void setVotedPeers(List<PeerData> votedPeers) {
        this.votedPeers = votedPeers;
    }

    public PollerDetail noAuPeers(List<String> noAuPeers) {
        this.noAuPeers = noAuPeers;
        return this;
    }

    public PollerDetail addNoAuPeersItem(String noAuPeersItem) {
        if (this.noAuPeers == null) {
            this.noAuPeers = new ArrayList();
        }
        this.noAuPeers.add(noAuPeersItem);
        return this;
    }

    @ApiModelProperty(value="The peers who do not have the au.")
    public List<String> getNoAuPeers() {
        return this.noAuPeers;
    }

    public void setNoAuPeers(List<String> noAuPeers) {
        this.noAuPeers = noAuPeers;
    }

    public PollerDetail tally(TallyData tally) {
        this.tally = tally;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public TallyData getTally() {
        return this.tally;
    }

    public void setTally(TallyData tally) {
        this.tally = tally;
    }

    public PollerDetail repairQueue(RepairQueue repairQueue) {
        this.repairQueue = repairQueue;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public RepairQueue getRepairQueue() {
        return this.repairQueue;
    }

    public void setRepairQueue(RepairQueue repairQueue) {
        this.repairQueue = repairQueue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PollerDetail pollerDetail = (PollerDetail)o;
        return Objects.equals(this.pollDesc, pollerDetail.pollDesc) && Objects.equals(this.pollerId, pollerDetail.pollerId) && Objects.equals(this.status, pollerDetail.status) && Objects.equals(this.pollKey, pollerDetail.pollKey) && Objects.equals(this.createTime, pollerDetail.createTime) && Objects.equals(this.duration, pollerDetail.duration) && Objects.equals(this.deadline, pollerDetail.deadline) && Objects.equals(this.outerCircleTarget, pollerDetail.outerCircleTarget) && Objects.equals(this.hashAlgorithm, pollerDetail.hashAlgorithm) && Objects.equals(this.voteMargin, pollerDetail.voteMargin) && Objects.equals(this.voteDeadline, pollerDetail.voteDeadline) && Objects.equals(this.voteDuration, pollerDetail.voteDuration) && Objects.equals(this.pollEnd, pollerDetail.pollEnd) && Objects.equals(this.quorum, pollerDetail.quorum) && Objects.equals(this.errorDetails, pollerDetail.errorDetails) && Objects.equals(this.votedPeers, pollerDetail.votedPeers) && Objects.equals(this.noAuPeers, pollerDetail.noAuPeers) && Objects.equals(this.tally, pollerDetail.tally) && Objects.equals(this.repairQueue, pollerDetail.repairQueue);
    }

    public int hashCode() {
        return Objects.hash(this.pollDesc, this.pollerId, this.status, this.pollKey, this.createTime, this.duration, this.deadline, this.outerCircleTarget, this.hashAlgorithm, this.voteMargin, this.voteDeadline, this.voteDuration, this.pollEnd, this.quorum, this.errorDetails, this.votedPeers, this.noAuPeers, this.tally, this.repairQueue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PollerDetail {\n");
        sb.append("    pollDesc: ").append(this.toIndentedString((Object)this.pollDesc)).append("\n");
        sb.append("    pollerId: ").append(this.toIndentedString((Object)this.pollerId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    pollKey: ").append(this.toIndentedString((Object)this.pollKey)).append("\n");
        sb.append("    createTime: ").append(this.toIndentedString((Object)this.createTime)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString((Object)this.duration)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString((Object)this.deadline)).append("\n");
        sb.append("    outerCircleTarget: ").append(this.toIndentedString((Object)this.outerCircleTarget)).append("\n");
        sb.append("    hashAlgorithm: ").append(this.toIndentedString((Object)this.hashAlgorithm)).append("\n");
        sb.append("    voteMargin: ").append(this.toIndentedString((Object)this.voteMargin)).append("\n");
        sb.append("    voteDeadline: ").append(this.toIndentedString((Object)this.voteDeadline)).append("\n");
        sb.append("    voteDuration: ").append(this.toIndentedString((Object)this.voteDuration)).append("\n");
        sb.append("    pollEnd: ").append(this.toIndentedString((Object)this.pollEnd)).append("\n");
        sb.append("    quorum: ").append(this.toIndentedString((Object)this.quorum)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString((Object)this.errorDetails)).append("\n");
        sb.append("    votedPeers: ").append(this.toIndentedString((Object)this.votedPeers)).append("\n");
        sb.append("    noAuPeers: ").append(this.toIndentedString((Object)this.noAuPeers)).append("\n");
        sb.append("    tally: ").append(this.toIndentedString((Object)this.tally)).append("\n");
        sb.append("    repairQueue: ").append(this.toIndentedString((Object)this.repairQueue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

