/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.lockss.laaws.poller.api.PollsApiDelegate;
import org.lockss.laaws.poller.model.PollerDetail;
import org.lockss.laaws.poller.model.PollerPager;
import org.lockss.laaws.poller.model.PollerSummary;
import org.lockss.laaws.poller.model.RepairPager;
import org.lockss.laaws.poller.model.UrlPager;
import org.lockss.laaws.poller.model.VoterDetail;
import org.lockss.laaws.poller.model.VoterPager;
import org.lockss.util.rest.poller.PollDesc;
import org.lockss.ws.entities.PollWsResult;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Api(value="polls", description="the polls API")
@RequestMapping(value={""})
public interface PollsApi {
    public PollsApiDelegate getDelegate();

    @ApiOperation(value="Send a request to call a poll to the poller", nickname="callPoll", notes="Use the information found in the descriptor object to initiate a  poll.", response=String.class, authorizations={@Authorization(value="basicAuth")}, tags={"service"})
    @ApiResponses(value={@ApiResponse(code=202, message="The Poll request has been accepted and added to the queue.", response=String.class), @ApiResponse(code=401, message="The Request is unauthorized"), @ApiResponse(code=403, message="The Au is not eligible for polling"), @ApiResponse(code=404, message="The descriptor (au) can not be found."), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/polls"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    default public ResponseEntity<String> callPoll(@ApiParam(value="", required=true) @Valid @RequestBody PollDesc body) {
        return this.getDelegate().callPoll(body);
    }

    @ApiOperation(value="Stop a poll and remove from queue.", nickname="cancelPoll", notes="Stop a running poll and delete any schecduled polls for poll with the poll service id.", authorizations={@Authorization(value="basicAuth")}, tags={"service"})
    @ApiResponses(value={@ApiResponse(code=200, message="Poll successfully stopped"), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=404, message="No poll found with that id"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/polls/{psId}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    default public ResponseEntity<Void> cancelPoll(@ApiParam(value="", required=true) @PathVariable(value="psId") String psId) {
        return this.getDelegate().cancelPoll(psId);
    }

    @ApiOperation(value="Poll Peer Data", nickname="getPollPeerVoteUrls", notes="", response=UrlPager.class, authorizations={@Authorization(value="basicAuth")}, tags={"poll-detail"})
    @ApiResponses(value={@ApiResponse(code=200, message="A pagable list of voter urls with a given status.", response=UrlPager.class), @ApiResponse(code=404, message="Poll or Voter ID not found."), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/polls/{pollKey}/peer/{peerId}"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<UrlPager> getPollPeerVoteUrls(@ApiParam(value="The pollKey from the PollDetail.", required=true) @PathVariable(value="pollKey") String pollKey, @ApiParam(value="The peerId from the Poll Detail.PeerData.", required=true) @PathVariable(value="peerId") String peerId, @NotNull @ApiParam(value="The voter urls to return.", required=true, allowableValues="agreed, disagreed, pollerOnly, voterOnly") @Valid @RequestParam(value="urls", required=true) String urls, @ApiParam(value="The page number") @Valid @RequestParam(value="page", required=false) Integer page, @ApiParam(value="The page size") @Valid @RequestParam(value="size", required=false) Integer size) {
        return this.getDelegate().getPollPeerVoteUrls(pollKey, peerId, urls, page, size);
    }

    @ApiOperation(value="Get queued poll status", nickname="getPollStatus", notes="Get the status of a previously queued poll.", response=PollerSummary.class, authorizations={@Authorization(value="basicAuth")}, tags={"service"})
    @ApiResponses(value={@ApiResponse(code=200, message="Poll info returned.", response=PollerSummary.class), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=404, message="No such poll service id."), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/polls/{psId}"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<PollerSummary> getPollStatus(@ApiParam(value="", required=true) @PathVariable(value="psId") String psId) {
        return this.getDelegate().getPollStatus(psId);
    }

    @ApiOperation(value="PollerDetails", nickname="getPollerPollDetails", notes="Return the detailed information about a poll.", response=PollerDetail.class, authorizations={@Authorization(value="basicAuth")}, tags={"poller-polls"})
    @ApiResponses(value={@ApiResponse(code=200, message="Detailed poll info returned.", response=PollerDetail.class), @ApiResponse(code=401, message="Unauthorized request."), @ApiResponse(code=404, message="Poll Key not found."), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/polls/poller/{pollKey}"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<PollerDetail> getPollerPollDetails(@ApiParam(value="The key assigned by the PollManager.", required=true) @PathVariable(value="pollKey") String pollKey) {
        return this.getDelegate().getPollerPollDetails(pollKey);
    }

    @ApiOperation(value="Query for poll properties", nickname="getPolls", notes="Query for polls that meet a set of specified conditions", response=PollWsResult.class, responseContainer="List", authorizations={@Authorization(value="basicAuth")}, tags={"service"})
    @ApiResponses(value={@ApiResponse(code=200, message="Information about the requested polls", response=PollWsResult.class, responseContainer="List"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/polls"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<List<PollWsResult>> getPolls(@NotNull @ApiParam(value="The query that specifies the polls to be returned", required=true) @Valid @RequestParam(value="pollQuery", required=true) String pollQuery) {
        return this.getDelegate().getPolls(pollQuery);
    }

    @ApiOperation(value="Get the list of recent polls as poller.", nickname="getPollsAsPoller", notes="Get the list of recent polls as poller from the poll queue. if size and page are passed in use those arguments to limit return data.", response=PollerPager.class, authorizations={@Authorization(value="basicAuth")}, tags={"poller-polls"})
    @ApiResponses(value={@ApiResponse(code=200, message="A pagable list has been returned.", response=PollerPager.class), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/polls/poller"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<PollerPager> getPollsAsPoller(@ApiParam(value="Size of the page to retrieve.") @Valid @RequestParam(value="size", required=false) Integer size, @ApiParam(value="Number of the page to retrieve.") @Valid @RequestParam(value="page", required=false) Integer page) {
        return this.getDelegate().getPollsAsPoller(size, page);
    }

    @ApiOperation(value="Get the list of recent voter only polls.", nickname="getPollsAsVoter", notes="Get the list of recent polls as voter from the poll queue. if size and page are passed in use those arguments to limit return data.", response=VoterPager.class, authorizations={@Authorization(value="basicAuth")}, tags={"voter-polls"})
    @ApiResponses(value={@ApiResponse(code=200, message="A pagable list has been returned.", response=VoterPager.class), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/polls/voter"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<VoterPager> getPollsAsVoter(@ApiParam(value="Size of the page to retrieve.") @Valid @RequestParam(value="size", required=false) Integer size, @ApiParam(value="Number of the page to retrieve.") @Valid @RequestParam(value="page", required=false) Integer page) {
        return this.getDelegate().getPollsAsVoter(size, page);
    }

    @ApiOperation(value="Poll Repairs", nickname="getRepairQueueData", notes="", response=RepairPager.class, authorizations={@Authorization(value="basicAuth")}, tags={"poll-detail"})
    @ApiResponses(value={@ApiResponse(code=200, message="A pagable list of repair queue elements.", response=RepairPager.class), @ApiResponse(code=404, message="Poll ID not found."), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/polls/{pollKey}/repairs"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<RepairPager> getRepairQueueData(@ApiParam(value="The pollKey as listed in the PollDetail object.", required=true) @PathVariable(value="pollKey") String pollKey, @NotNull @ApiParam(value="The repair queue elements to return.", required=true, allowableValues="pending, active, completed") @Valid @RequestParam(value="repair", required=true) String repair, @ApiParam(value="The page number.") @Valid @RequestParam(value="page", required=false) Integer page, @ApiParam(value="The size of the page.") @Valid @RequestParam(value="size", required=false) Integer size) {
        return this.getDelegate().getRepairQueueData(pollKey, repair, page, size);
    }

    @ApiOperation(value="Page Tally", nickname="getTallyUrls", notes="", response=UrlPager.class, authorizations={@Authorization(value="basicAuth")}, tags={"poll-detail"})
    @ApiResponses(value={@ApiResponse(code=200, message="A pagable list of urls for given tally type.", response=UrlPager.class), @ApiResponse(code=404, message="Poll Key not found."), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/polls/{pollKey}/tallies"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<UrlPager> getTallyUrls(@ApiParam(value="The pollKey as listed in the PollDetail object.", required=true) @PathVariable(value="pollKey") String pollKey, @NotNull @ApiParam(value="The kind of tally element to return.", required=true, allowableValues="agree, disagree, error, noQuorum, tooClose") @Valid @RequestParam(value="tally", required=true) String tally, @ApiParam(value="The page number.") @Valid @RequestParam(value="page", required=false) Integer page, @ApiParam(value="The size of the page.") @Valid @RequestParam(value="size", required=false) Integer size) {
        return this.getDelegate().getTallyUrls(pollKey, tally, page, size);
    }

    @ApiOperation(value="VoterDetails", nickname="getVoterPollDetails", notes="Return the detailed information about a poll.", response=VoterDetail.class, authorizations={@Authorization(value="basicAuth")}, tags={"voter-polls"})
    @ApiResponses(value={@ApiResponse(code=200, message="Detailed poll info returned.", response=VoterDetail.class), @ApiResponse(code=401, message="Unauthorized request"), @ApiResponse(code=404, message="No such poll key."), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/polls/voter/{pollKey}"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<VoterDetail> getVoterPollDetails(@ApiParam(value="The key assigned by the PollManager.", required=true) @PathVariable(value="pollKey") String pollKey) {
        return this.getDelegate().getVoterPollDetails(pollKey);
    }
}

