/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lockss.app.LockssDaemon;
import org.lockss.laaws.poller.impl.VoteWsSource;
import org.lockss.poller.PollManager;
import org.lockss.poller.v3.V3Voter;
import org.lockss.util.Logger;
import org.lockss.ws.entities.VoteWsResult;

public class VoteHelper {
    static String SOURCE_FQCN = VoteWsSource.class.getCanonicalName();
    static String RESULT_FQCN = VoteWsResult.class.getCanonicalName();
    static String AU_ID = "auId";
    static String AU_NAME = "auName";
    static String CALLER_ID = "callerId";
    static String VOTE_STATUS = "voteStatus";
    static String START_TIME = "startTime";
    static String DEADLINE = "deadline";
    static String VOTE_KEY = "voteKey";
    static String IS_POLL_ACTIVE = "isPollActive";
    static String CURRENT_STATE = "currentState";
    static String ERROR_DETAIL = "errorDetail";
    static String VOTE_DEADLINE = "voteDeadline";
    static String DURATION = "duration";
    static String REMAINING_TIME = "remainingTime";
    static String AGREEMENT_HINT = "agreementHint";
    static String POLLER_NONCE = "pollerNonce";
    static String VOTER_NONCE = "voterNonce";
    static String VOTER_NONCE_2 = "voterNonce2";
    static String IS_SYMMETRIC_POLL = "isSymmetricPoll";
    static String AGREED_URL_COUNT = "agreedUrlCount";
    static String DISAGREED_URL_COUNT = "disagreedUrlCount";
    static String POLLER_ONLY_URL_COUNT = "pollerOnlyUrlCount";
    static String VOTER_ONLY_URL_COUNT = "voterOnlyUrlCount";
    static final Set<String> PROPERTY_NAMES = new HashSet<String>(){
        {
            this.add(AU_ID);
            this.add(AU_NAME);
            this.add(CALLER_ID);
            this.add(VOTE_STATUS);
            this.add(START_TIME);
            this.add(DEADLINE);
            this.add(VOTE_KEY);
            this.add(IS_POLL_ACTIVE);
            this.add(CURRENT_STATE);
            this.add(ERROR_DETAIL);
            this.add(VOTE_DEADLINE);
            this.add(DURATION);
            this.add(REMAINING_TIME);
            this.add(AGREEMENT_HINT);
            this.add(POLLER_NONCE);
            this.add(VOTER_NONCE);
            this.add(VOTER_NONCE_2);
            this.add(IS_SYMMETRIC_POLL);
            this.add(AGREED_URL_COUNT);
            this.add(DISAGREED_URL_COUNT);
            this.add(POLLER_ONLY_URL_COUNT);
            this.add(VOTER_ONLY_URL_COUNT);
        }
    };
    private static Logger log = Logger.getLogger();

    List<VoteWsSource> createUniverse() {
        String DEBUG_HEADER = "createUniverse(): ";
        PollManager pollManager = (PollManager)LockssDaemon.getManagerByKeyStatic((String)LockssDaemon.POLL_MANAGER);
        Collection allVotes = pollManager.getV3Voters();
        if (log.isDebug3()) {
            log.debug3("createUniverse(): allVotes.size() = " + allVotes.size());
        }
        ArrayList<VoteWsSource> universe = new ArrayList<VoteWsSource>(allVotes.size());
        for (V3Voter vote : allVotes) {
            universe.add(new VoteWsSource(vote));
        }
        if (log.isDebug2()) {
            log.debug2("createUniverse(): universe.size() = " + universe.size());
        }
        return universe;
    }

    String nonDefaultToString(Collection<VoteWsResult> results) {
        StringBuilder builder = new StringBuilder("[");
        boolean isFirst = true;
        for (VoteWsResult result : results) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append(this.nonDefaultToString(result));
        }
        return builder.append("]").toString();
    }

    private String nonDefaultToString(VoteWsResult result) {
        StringBuilder builder = new StringBuilder("VoteWsResult [");
        boolean isFirst = true;
        if (result.getAuId() != null) {
            builder.append("auId=").append(result.getAuId());
            isFirst = false;
        }
        if (result.getAuName() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("auName=").append(result.getAuName());
        }
        if (result.getCallerId() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("callerId=").append(result.getCallerId());
        }
        if (result.getVoteStatus() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("voteStatus=").append(result.getVoteStatus());
        }
        if (result.getStartTime() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("startTime=").append(result.getStartTime());
        }
        if (result.getDeadline() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("deadline=").append(result.getDeadline());
        }
        if (result.getVoteKey() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("voteKey=").append(result.getVoteKey());
        }
        if (result.getIsPollActive() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("isPollActive=").append(result.getIsPollActive());
        }
        if (result.getCurrentState() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("currentState=").append(result.getCurrentState());
        }
        if (result.getErrorDetail() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("errorDetail=").append(result.getErrorDetail());
        }
        if (result.getVoteDeadline() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("voteDeadline=").append(result.getVoteDeadline());
        }
        if (result.getDuration() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("duration=").append(result.getDuration());
        }
        if (result.getRemainingTime() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("remainingTime=").append(result.getRemainingTime());
        }
        if (result.getAgreementHint() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("agreementHint=").append(result.getAgreementHint());
        }
        if (result.getPollerNonce() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("pollerNonce=").append(result.getPollerNonce());
        }
        if (result.getVoterNonce() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("voterNonce=").append(result.getVoterNonce());
        }
        if (result.getVoterNonce2() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("voterNonce2=").append(result.getVoterNonce2());
        }
        if (result.getIsSymmetricPoll() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("isSymmetricPoll=").append(result.getIsSymmetricPoll());
        }
        if (result.getAgreedUrlCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("agreedUrlCount=").append(result.getAgreedUrlCount());
        }
        if (result.getDisagreedUrlCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("disagreedUrlCount=").append(result.getDisagreedUrlCount());
        }
        if (result.getPollerOnlyUrlCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("pollerOnlyUrlCount=").append(result.getPollerOnlyUrlCount());
        }
        if (result.getVoterOnlyUrlCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("voterOnlyUrlCount=").append(result.getVoterOnlyUrlCount());
        }
        return builder.append("]").toString();
    }
}

