/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.lockss.laaws.poller.api.PeersApiDelegate;
import org.lockss.ws.entities.PeerWsResult;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Api(value="peers", description="the peers API")
@RequestMapping(value={""})
public interface PeersApi {
    public PeersApiDelegate getDelegate();

    @ApiOperation(value="Query for peer properties", nickname="getPeers", notes="Query for peers that meet a set of specified conditions", response=PeerWsResult.class, responseContainer="List", authorizations={@Authorization(value="basicAuth")}, tags={"service"})
    @ApiResponses(value={@ApiResponse(code=200, message="Information about the requested peers", response=PeerWsResult.class, responseContainer="List"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/peers"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<List<PeerWsResult>> getPeers(@NotNull @ApiParam(value="The query that specifies the peers to be returned", required=true) @Valid @RequestParam(value="peerQuery", required=true) String peerQuery) {
        return this.getDelegate().getPeers(peerQuery);
    }
}

