/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.lockss.laaws.poller.api.RepositoriesApiDelegate;
import org.lockss.ws.entities.RepositoryWsResult;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Api(value="repositories", description="the repositories API")
@RequestMapping(value={""})
public interface RepositoriesApi {
    public RepositoriesApiDelegate getDelegate();

    @ApiOperation(value="Query the properties of repositories", nickname="getRepositories", notes="Query the system for selected repository properties", response=RepositoryWsResult.class, responseContainer="List", authorizations={@Authorization(value="basicAuth")}, tags={"repo"})
    @ApiResponses(value={@ApiResponse(code=200, message="Information about the requested TDB AUs", response=RepositoryWsResult.class, responseContainer="List"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/repositories"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<List<RepositoryWsResult>> getRepositories(@NotNull @ApiParam(value="The query that specifies the repository properties to be returned", required=true) @Valid @RequestParam(value="repositoryQuery", required=true) String repositoryQuery) {
        return this.getDelegate().getRepositories(repositoryQuery);
    }
}

