/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.http.HttpHeaders;

public class Page<T> {
    private Integer mPageNum;
    private Integer mLastPage;
    private Integer mPageSize;
    private int mFirstItem;
    private int mLastItem;
    private int mTotal;
    private String mLinkBase;
    private static final String LINK_TEMPLATE = "%s?page=%d&size=%d";
    private List<T> mContent = new ArrayList<T>();

    public Page(Collection<T> content, Integer page, Integer size, String linkBase) {
        if (null == content) {
            this.mTotal = 0;
        } else {
            this.mContent.addAll(content);
        }
        this.mLinkBase = linkBase;
        this.mPageSize = size;
        this.mTotal = this.mContent.size();
        if (this.mTotal == 0 || size <= 0 || size >= this.mTotal) {
            this.mPageNum = 1;
            this.mLastPage = 1;
            this.mFirstItem = 0;
            this.mLastItem = this.mTotal;
            this.mPageSize = this.mTotal;
        } else {
            this.mPageNum = page > 0 ? page : 1;
            this.mLastPage = this.mTotal / size + (this.mTotal % size > 0 ? 1 : 0);
            this.mPageNum = this.mPageNum > this.mLastPage ? this.mLastPage : this.mPageNum;
            this.mFirstItem = (this.mPageNum - 1) * size;
            this.mLastItem = this.mFirstItem + size;
            if (this.mLastItem > this.mTotal) {
                this.mLastItem = this.mTotal;
            }
        }
    }

    public int getPageNum() {
        return this.mPageNum;
    }

    public int getPageSize() {
        return this.mPageSize;
    }

    public int getLastPage() {
        return this.mLastPage;
    }

    public int getFirstItem() {
        return this.mFirstItem;
    }

    public int getLastItem() {
        return this.mLastItem;
    }

    public int getTotal() {
        return this.mTotal;
    }

    public List<T> getPageContent() {
        if (this.mFirstItem != 0 && this.mLastItem != this.mTotal) {
            return this.mContent.subList(this.mFirstItem, this.mLastItem);
        }
        return this.mContent;
    }

    public boolean hasContent() {
        return !this.mContent.isEmpty();
    }

    public String getNextLink() {
        String nextPage = null;
        if (this.mPageNum < this.mLastPage) {
            nextPage = String.format(LINK_TEMPLATE, this.mLinkBase, this.mPageNum + 1, this.mPageSize);
        }
        return nextPage;
    }

    public String getPrevLink() {
        String prevPage = null;
        if (this.mPageNum > 1) {
            prevPage = String.format(LINK_TEMPLATE, this.mLinkBase, this.mPageNum - 1, this.mPageSize);
        }
        return prevPage;
    }

    public String getFirstLink() {
        return String.format(LINK_TEMPLATE, this.mLinkBase, 1, this.mPageSize);
    }

    public String getLastLink() {
        return String.format(LINK_TEMPLATE, this.mLinkBase, this.mLastPage, this.mPageSize);
    }

    public HttpHeaders getPageHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json; charset=UTF-8");
        headers.add("X-Page-Count", "" + this.mLastPage);
        headers.add("X-Page-Number", "" + this.mPageNum);
        headers.add("X-Page-Size", "" + this.mPageSize);
        headers.add("X-Total-Count", "" + this.mTotal);
        return headers;
    }
}

