/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lockss.app.LockssDaemon;
import org.lockss.laaws.poller.impl.PeerWsSource;
import org.lockss.protocol.IdentityManager;
import org.lockss.protocol.PeerIdentity;
import org.lockss.protocol.PeerIdentityStatus;
import org.lockss.util.Logger;
import org.lockss.ws.entities.PeerWsResult;

public class PeerHelper {
    static String SOURCE_FQCN = PeerWsSource.class.getCanonicalName();
    static String RESULT_FQCN = PeerWsResult.class.getCanonicalName();
    static String PEER_ID = "peerId";
    static String LAST_MESSAGE = "lastMessage";
    static String MESSAGE_TYPE = "messageType";
    static String MESSAGE_COUNT = "messageCount";
    static String LAST_POLL = "lastPoll";
    static String LAST_VOTE = "lastVote";
    static String LAST_INVITATION = "lastInvitation";
    static String INVITATION_COUNT = "invitationCount";
    static String POLLS_CALLED = "pollsCalled";
    static String VOTES_CAST = "votesCast";
    static String POLLS_REJECTED = "pollsRejected";
    static String NAK_REASON = "nakReason";
    static String GROUPS = "groups";
    static String PLATFORM_GROUP_MATCH = "platformGroupMatch";
    static final Set<String> PROPERTY_NAMES = new HashSet<String>(){
        {
            this.add(PEER_ID);
            this.add(LAST_MESSAGE);
            this.add(MESSAGE_TYPE);
            this.add(MESSAGE_COUNT);
            this.add(LAST_POLL);
            this.add(LAST_VOTE);
            this.add(LAST_INVITATION);
            this.add(INVITATION_COUNT);
            this.add(POLLS_CALLED);
            this.add(VOTES_CAST);
            this.add(POLLS_REJECTED);
            this.add(NAK_REASON);
            this.add(GROUPS);
            this.add(PLATFORM_GROUP_MATCH);
        }
    };
    private static Logger log = Logger.getLogger();

    List<PeerWsSource> createUniverse() {
        String DEBUG_HEADER = "createUniverse(): ";
        IdentityManager idMgr = (IdentityManager)LockssDaemon.getManagerByKeyStatic((String)LockssDaemon.IDENTITY_MANAGER);
        boolean includeV1 = false;
        try {
            includeV1 = idMgr.getLocalPeerIdentity(1) != null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        List allPeers = ((IdentityManager)LockssDaemon.getManagerByKeyStatic((String)LockssDaemon.IDENTITY_MANAGER)).getPeerIdentityStatusList();
        if (log.isDebug3()) {
            log.debug3("createUniverse(): allPeers.size() = " + allPeers.size());
        }
        ArrayList<PeerWsSource> universe = new ArrayList<PeerWsSource>(allPeers.size());
        for (PeerIdentityStatus status : allPeers) {
            PeerIdentity pid = status.getPeerIdentity();
            if (pid.isLocalIdentity() || !includeV1 && !pid.isV3()) continue;
            universe.add(new PeerWsSource(status));
        }
        if (log.isDebug2()) {
            log.debug2("createUniverse(): universe.size() = " + universe.size());
        }
        return universe;
    }

    String nonDefaultToString(Collection<PeerWsResult> results) {
        StringBuilder builder = new StringBuilder("[");
        boolean isFirst = true;
        for (PeerWsResult result : results) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append(this.nonDefaultToString(result));
        }
        return builder.append("]").toString();
    }

    private String nonDefaultToString(PeerWsResult result) {
        StringBuilder builder = new StringBuilder("PeerWsResult [");
        boolean isFirst = true;
        if (result.getPeerId() != null) {
            builder.append("peerId=").append(result.getPeerId());
            isFirst = false;
        }
        if (result.getLastMessage() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("lastMessage=").append(result.getLastMessage());
        }
        if (result.getMessageType() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("messageType=").append(result.getMessageType());
        }
        if (result.getMessageCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("messageCount=").append(result.getMessageCount());
        }
        if (result.getLastPoll() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("lastPoll=").append(result.getLastPoll());
        }
        if (result.getLastVote() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("lastVote=").append(result.getLastVote());
        }
        if (result.getLastInvitation() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("lastInvitation=").append(result.getLastInvitation());
        }
        if (result.getInvitationCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("invitationCount=").append(result.getInvitationCount());
        }
        if (result.getPollsCalled() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("pollsCalled=").append(result.getPollsCalled());
        }
        if (result.getVotesCast() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("votesCast=").append(result.getVotesCast());
        }
        if (result.getPollsRejected() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("pollsRejected=").append(result.getPollsRejected());
        }
        if (result.getNakReason() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("nakReason=").append(result.getNakReason());
        }
        if (result.getGroups() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("groups=").append(result.getGroups());
        }
        if (result.getPlatformGroupMatch() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("platformGroupMatch=").append(result.getPlatformGroupMatch());
        }
        return builder.append("]").toString();
    }
}

