/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.impl;

import java.util.List;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryResults;
import org.lockss.laaws.poller.api.RepositoryspacesApiDelegate;
import org.lockss.laaws.poller.impl.RepositorySpaceHelper;
import org.lockss.log.L4JLogger;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.util.josql.JosqlUtil;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class RepositoryspacesApiServiceImpl
extends BaseSpringApiServiceImpl
implements RepositoryspacesApiDelegate {
    private static L4JLogger log = L4JLogger.getLogger();

    public ResponseEntity getRepositorySpaces(String repositorySpaceQuery) {
        log.debug2("repositorySpaceQuery = {}", (Object)repositorySpaceQuery);
        RepositorySpaceHelper repositorySpaceHelper = new RepositorySpaceHelper();
        List results = null;
        try {
            String fullQuery = JosqlUtil.createFullQuery((String)repositorySpaceQuery, (String)RepositorySpaceHelper.SOURCE_FQCN, RepositorySpaceHelper.PROPERTY_NAMES, (String)RepositorySpaceHelper.RESULT_FQCN);
            log.trace("fullQuery = {}", (Object)fullQuery);
            Query q = new Query();
            try {
                q.parse(fullQuery);
                QueryResults qr = q.execute(repositorySpaceHelper.createUniverse());
                results = qr.getResults();
                log.trace("results.size() = {}", (Object)results.size());
                log.trace("results = {}", (Object)repositorySpaceHelper.nonDefaultToString(results));
                return new ResponseEntity((Object)results, HttpStatus.OK);
            }
            catch (QueryExecutionException qee) {
                String message = "Cannot getRepositorySpaces() for repositorySpaceQuery = '" + repositorySpaceQuery + "'";
                log.error(message, (Throwable)qee);
                return new ResponseEntity((Object)message, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        catch (Exception e) {
            String message = "Cannot getRepositorySpaces() for repositorySpaceQuery = '" + repositorySpaceQuery + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

