/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.impl;

import org.lockss.poller.v3.V3Voter;
import org.lockss.poller.v3.VoterUserData;
import org.lockss.protocol.psm.PsmInterp;
import org.lockss.protocol.psm.PsmState;
import org.lockss.util.ByteArray;
import org.lockss.util.time.TimeBase;
import org.lockss.ws.entities.VoteWsResult;

public class VoteWsSource
extends VoteWsResult {
    private V3Voter vote;
    private boolean auIdPopulated = false;
    private boolean auNamePopulated = false;
    private boolean callerIdPopulated = false;
    private boolean voteStatusPopulated = false;
    private boolean startTimePopulated = false;
    private boolean deadlinePopulated = false;
    private boolean voteKeyPopulated = false;
    private boolean isPollActivePopulated = false;
    private boolean currentStatePopulated = false;
    private boolean errorDetailPopulated = false;
    private boolean voteDeadlinePopulated = false;
    private boolean durationPopulated = false;
    private boolean remainingTimePopulated = false;
    private boolean agreementHintPopulated = false;
    private boolean pollerNoncePopulated = false;
    private boolean voterNoncePopulated = false;
    private boolean voterNonce2Populated = false;
    private boolean isSymmetricPollPopulated = false;
    private boolean agreedUrlCountPopulated = false;
    private boolean disagreedUrlCountPopulated = false;
    private boolean pollerOnlyUrlCountPopulated = false;
    private boolean voterOnlyUrlCountPopulated = false;
    private VoterUserData voterUserData;
    private boolean voterUserDataPopulated = false;

    public VoteWsSource(V3Voter vote) {
        this.vote = vote;
    }

    public String getAuId() {
        if (!this.auIdPopulated) {
            this.setAuId(this.vote.getAu().getAuId());
            this.auIdPopulated = true;
        }
        return super.getAuId();
    }

    public String getAuName() {
        if (!this.auNamePopulated) {
            this.setAuName(this.vote.getAu().getName());
            this.auNamePopulated = true;
        }
        return super.getAuName();
    }

    public String getCallerId() {
        if (!this.callerIdPopulated) {
            this.setCallerId(this.vote.getPollerId().getIdString());
            this.callerIdPopulated = true;
        }
        return super.getCallerId();
    }

    public String getVoteStatus() {
        if (!this.voteStatusPopulated) {
            this.setVoteStatus(this.vote.getStatusString());
            this.voteStatusPopulated = true;
        }
        return super.getVoteStatus();
    }

    public Long getStartTime() {
        if (!this.startTimePopulated) {
            this.setStartTime(this.vote.getCreateTime());
            this.startTimePopulated = true;
        }
        return super.getStartTime();
    }

    public Long getDeadline() {
        if (!this.deadlinePopulated) {
            this.setDeadline(this.vote.getDeadline().getExpirationTime());
            this.deadlinePopulated = true;
        }
        return super.getDeadline();
    }

    public String getVoteKey() {
        if (!this.voteKeyPopulated) {
            this.setVoteKey(this.vote.getKey());
            this.voteKeyPopulated = true;
        }
        return super.getVoteKey();
    }

    public Boolean getIsPollActive() {
        if (!this.isPollActivePopulated) {
            this.setIsPollActive(this.vote.isPollActive());
            this.isPollActivePopulated = true;
        }
        return super.getIsPollActive();
    }

    public String getCurrentState() {
        if (!this.currentStatePopulated) {
            PsmState state;
            PsmInterp interp = this.vote.getPsmInterp();
            if (interp != null && (state = interp.getCurrentState()) != null) {
                this.setCurrentState(state.getName());
            }
            this.currentStatePopulated = true;
        }
        return super.getCurrentState();
    }

    public String getErrorDetail() {
        if (!this.errorDetailPopulated) {
            this.setErrorDetail(this.getVoterUserData().getErrorDetail());
            this.errorDetailPopulated = true;
        }
        return super.getErrorDetail();
    }

    public Long getVoteDeadline() {
        if (!this.voteDeadlinePopulated) {
            this.setVoteDeadline(this.vote.getVoteDeadline().getExpirationTime());
            this.voteDeadlinePopulated = true;
        }
        return super.getVoteDeadline();
    }

    public Long getDuration() {
        if (!this.durationPopulated) {
            this.setDuration(this.vote.getDuration());
            this.durationPopulated = true;
        }
        return super.getDuration();
    }

    public Long getRemainingTime() {
        if (!this.remainingTimePopulated) {
            long remain = TimeBase.msUntil((long)this.vote.getDeadline().getExpirationTime());
            if (remain >= 0L) {
                this.setRemainingTime(remain);
            }
            this.remainingTimePopulated = true;
        }
        return super.getRemainingTime();
    }

    public Double getAgreementHint() {
        if (!this.agreementHintPopulated) {
            if (this.vote.getStatus() == 5 && this.getVoterUserData().hasReceivedHint()) {
                this.setAgreementHint(this.voterUserData.getAgreementHint());
            }
            this.agreementHintPopulated = true;
        }
        return super.getAgreementHint();
    }

    public String getPollerNonce() {
        if (!this.pollerNoncePopulated) {
            this.setPollerNonce(ByteArray.toBase64((byte[])this.vote.getPollerNonce()));
            this.pollerNoncePopulated = true;
        }
        return super.getPollerNonce();
    }

    public String getVoterNonce() {
        if (!this.voterNoncePopulated) {
            this.setVoterNonce(ByteArray.toBase64((byte[])this.vote.getVoterNonce()));
            this.voterNoncePopulated = true;
        }
        return super.getVoterNonce();
    }

    public String getVoterNonce2() {
        if (!this.voterNonce2Populated) {
            if (this.getIsSymmetricPoll().booleanValue()) {
                this.setVoterNonce2(ByteArray.toBase64((byte[])this.vote.getVoterNonce()));
            }
            this.voterNonce2Populated = true;
        }
        return super.getVoterNonce2();
    }

    public Boolean getIsSymmetricPoll() {
        if (!this.isSymmetricPollPopulated) {
            this.setIsSymmetricPoll(this.getVoterUserData().isSymmetricPoll());
            this.isSymmetricPollPopulated = true;
        }
        return super.getIsSymmetricPoll();
    }

    public Integer getAgreedUrlCount() {
        if (!this.agreedUrlCountPopulated) {
            if (this.getIsSymmetricPoll().booleanValue() && this.vote.getStatus() == 5) {
                this.setAgreedUrlCount(this.getVoterUserData().getNumAgreeUrl());
            }
            this.agreedUrlCountPopulated = true;
        }
        return super.getAgreedUrlCount();
    }

    public Integer getDisagreedUrlCount() {
        if (!this.disagreedUrlCountPopulated) {
            if (this.getIsSymmetricPoll().booleanValue() && this.vote.getStatus() == 5) {
                this.setDisagreedUrlCount(this.getVoterUserData().getNumDisagreeUrl());
            }
            this.disagreedUrlCountPopulated = true;
        }
        return super.getDisagreedUrlCount();
    }

    public Integer getPollerOnlyUrlCount() {
        if (!this.pollerOnlyUrlCountPopulated) {
            if (this.getIsSymmetricPoll().booleanValue() && this.vote.getStatus() == 5) {
                this.setPollerOnlyUrlCount(this.getVoterUserData().getNumPollerOnlyUrl());
            }
            this.pollerOnlyUrlCountPopulated = true;
        }
        return super.getPollerOnlyUrlCount();
    }

    public Integer getVoterOnlyUrlCount() {
        if (!this.voterOnlyUrlCountPopulated) {
            if (this.getIsSymmetricPoll().booleanValue() && this.vote.getStatus() == 5) {
                this.setVoterOnlyUrlCount(this.getVoterUserData().getNumVoterOnlyUrl());
            }
            this.voterOnlyUrlCountPopulated = true;
        }
        return super.getVoterOnlyUrlCount();
    }

    private VoterUserData getVoterUserData() {
        if (!this.voterUserDataPopulated) {
            this.voterUserData = this.vote.getVoterUserData();
            this.voterUserDataPopulated = true;
        }
        return this.voterUserData;
    }
}

