/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.lockss.laaws.poller.model.PageDesc;
import org.lockss.laaws.poller.model.RepairData;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A Pager for a list of urls found in poll details.")
@Validated
public class RepairPager {
    @JsonProperty(value="pageDesc")
    private PageDesc pageDesc = null;
    @JsonProperty(value="repairs")
    @Valid
    private List<RepairData> repairs = null;

    public RepairPager pageDesc(PageDesc pageDesc) {
        this.pageDesc = pageDesc;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public PageDesc getPageDesc() {
        return this.pageDesc;
    }

    public void setPageDesc(PageDesc pageDesc) {
        this.pageDesc = pageDesc;
    }

    public RepairPager repairs(List<RepairData> repairs) {
        this.repairs = repairs;
        return this;
    }

    public RepairPager addRepairsItem(RepairData repairsItem) {
        if (this.repairs == null) {
            this.repairs = new ArrayList<RepairData>();
        }
        this.repairs.add(repairsItem);
        return this;
    }

    @ApiModelProperty(value="The list of repair data on this page or null.")
    @Valid
    public List<RepairData> getRepairs() {
        return this.repairs;
    }

    public void setRepairs(List<RepairData> repairs) {
        this.repairs = repairs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepairPager repairPager = (RepairPager)o;
        return Objects.equals(this.pageDesc, repairPager.pageDesc) && Objects.equals(this.repairs, repairPager.repairs);
    }

    public int hashCode() {
        return Objects.hash(this.pageDesc, this.repairs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RepairPager {\n");
        sb.append("    pageDesc: ").append(this.toIndentedString(this.pageDesc)).append("\n");
        sb.append("    repairs: ").append(this.toIndentedString(this.repairs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

