/**
 * NOTE: This class is auto generated by the swagger code generator program (2.4.21).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.lockss.laaws.poller.api;

import org.springframework.core.io.Resource;
import io.swagger.annotations.*;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;

@Validated
@Api(value = "aus", description = "the aus API")
@RequestMapping(value = "")
public interface AusApi {

    AusApiDelegate getDelegate();

    @ApiOperation(value = "Export artifacts in an Archival Unit", nickname = "getExportFiles", notes = "Export artifacts in an Archival Unit as a group of archives", response = Resource.class, authorizations = {
        @Authorization(value = "basicAuth")
    }, tags={ "export", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The archives with the requested artifacts", response = Resource.class),
        @ApiResponse(code = 400, message = "Bad Request"),
        @ApiResponse(code = 401, message = "Unauthorized"),
        @ApiResponse(code = 403, message = "Forbidden"),
        @ApiResponse(code = 404, message = "Not found"),
        @ApiResponse(code = 406, message = "Not Acceptable"),
        @ApiResponse(code = 500, message = "Internal Server Error") })
    @RequestMapping(value = "/aus/{auid}/export",
        produces = { "multipart/form-data" }, 
        consumes = { "application/json" },
        method = RequestMethod.GET)
    default ResponseEntity<Resource> getExportFiles(@ApiParam(value = "Identifier of the Archival Unit containing the artifacts",required=true) @PathVariable("auid") String auid,@ApiParam(value = "The type of archive to create", allowableValues = "WARC_RESPONSE, WARC_RESOURCE, ARC_RESPONSE, ARC_RESOURCE, ZIP", defaultValue = "WARC_RESPONSE") @Valid @RequestParam(value = "fileType", required = false, defaultValue="WARC_RESPONSE") String fileType,@ApiParam(value = "Indication of whether contents should be compressed", defaultValue = "true") @Valid @RequestParam(value = "isCompress", required = false, defaultValue="true") Boolean isCompress,@ApiParam(value = "Indication of whether directories should be excluded", defaultValue = "true") @Valid @RequestParam(value = "isExcludeDirNodes", required = false, defaultValue="true") Boolean isExcludeDirNodes,@ApiParam(value = "Type of filename translation to be done", allowableValues = "XLATE_NONE, XLATE_WINDOWS, XLATE_MAC", defaultValue = "XLATE_NONE") @Valid @RequestParam(value = "xlateFilenames", required = false, defaultValue="XLATE_NONE") String xlateFilenames,@ApiParam(value = "The prefix to be used to name the exported file", defaultValue = "lockss_export") @Valid @RequestParam(value = "filePrefix", required = false, defaultValue="lockss_export") String filePrefix,@ApiParam(value = "The maximum size of the exported file", defaultValue = "-1") @Valid @RequestParam(value = "maxSize", required = false, defaultValue="-1") Long maxSize,@ApiParam(value = "The maximum number of versions of an artifact to be exported", defaultValue = "-1") @Valid @RequestParam(value = "maxVersions", required = false, defaultValue="-1") Integer maxVersions) {
        return getDelegate().getExportFiles(auid, fileType, isCompress, isExcludeDirNodes, xlateFilenames, filePrefix, maxSize, maxVersions);
    }

}
