/**
 * NOTE: This class is auto generated by the swagger code generator program (2.4.21).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.lockss.laaws.poller.api;

import org.lockss.ws.entities.HasherWsParams;
import org.lockss.ws.entities.PeerWsResult;
import org.lockss.ws.entities.PollWsResult;
import org.lockss.ws.entities.RepositorySpaceWsResult;
import org.lockss.ws.entities.RepositoryWsResult;
import org.springframework.core.io.Resource;
import org.lockss.ws.entities.VoteWsResult;
import io.swagger.annotations.*;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;

@Validated
@Api(value = "ws", description = "the ws API")
@RequestMapping(value = "")
public interface WsApi {

    WsApiDelegate getDelegate();

    @ApiOperation(value = "Remove an asynchronous hashing operation", nickname = "deleteHash", notes = "Remove from the system an asynchronous hashing operation,\\ \\ terminating it if it's still running", response = String.class, authorizations = {
        @Authorization(value = "basicAuth")
    }, tags={ "hash", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Asynchronous hashing operation successfully removed", response = String.class),
        @ApiResponse(code = 400, message = "Bad Request"),
        @ApiResponse(code = 401, message = "Unauthorized"),
        @ApiResponse(code = 404, message = "No asynchronous hashing operation found with that id"),
        @ApiResponse(code = 500, message = "Internal Server Error") })
    @RequestMapping(value = "/ws/hashes/requests/{requestId}",
        produces = { "application/json" }, 
        method = RequestMethod.DELETE)
    default ResponseEntity<String> deleteHash(@ApiParam(value = "Identifier of the asynchronous hashing operation",required=true) @PathVariable("requestId") String requestId) {
        return getDelegate().deleteHash(requestId);
    }


    @ApiOperation(value = "Get the results of all the asynchronous hashing operations", nickname = "getAllHashes", notes = "Get the results of all the asynchronous hashing operations", response = Resource.class, authorizations = {
        @Authorization(value = "basicAuth")
    }, tags={ "hash", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Information about all the asynchronous hashing operations", response = Resource.class),
        @ApiResponse(code = 401, message = "Unauthorized"),
        @ApiResponse(code = 500, message = "Internal Server Error") })
    @RequestMapping(value = "/ws/hashes",
        produces = { "multipart/form-data" }, 
        method = RequestMethod.GET)
    default ResponseEntity<Resource> getAllHashes() {
        return getDelegate().getAllHashes();
    }


    @ApiOperation(value = "Get the result of an asynchronous hashing operation", nickname = "getHash", notes = "Get the result of an asynchronous hashing operation", response = Resource.class, authorizations = {
        @Authorization(value = "basicAuth")
    }, tags={ "hash", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Information about the asynchronous hashing operation", response = Resource.class),
        @ApiResponse(code = 400, message = "Bad Request"),
        @ApiResponse(code = 401, message = "Unauthorized"),
        @ApiResponse(code = 404, message = "No asynchronous hashing operation found with that id"),
        @ApiResponse(code = 500, message = "Internal Server Error") })
    @RequestMapping(value = "/ws/hashes/requests/{requestId}",
        produces = { "multipart/form-data" }, 
        method = RequestMethod.GET)
    default ResponseEntity<Resource> getHash(@ApiParam(value = "Identifier of the asynchronous hashing operation",required=true) @PathVariable("requestId") String requestId) {
        return getDelegate().getHash(requestId);
    }


    @ApiOperation(value = "Query for peer properties", nickname = "getPeers", notes = "Query for peers that meet a set of specified conditions", response = PeerWsResult.class, responseContainer = "List", authorizations = {
        @Authorization(value = "basicAuth")
    }, tags={ "service", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Information about the requested peers", response = PeerWsResult.class, responseContainer = "List"),
        @ApiResponse(code = 400, message = "Bad Request"),
        @ApiResponse(code = 401, message = "Unauthorized"),
        @ApiResponse(code = 500, message = "Internal Server Error") })
    @RequestMapping(value = "/ws/peers",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<List<PeerWsResult>> getPeers(@NotNull @ApiParam(value = "The query that specifies the peers to be returned", required = true) @Valid @RequestParam(value = "peerQuery", required = true) String peerQuery) {
        return getDelegate().getPeers(peerQuery);
    }


    @ApiOperation(value = "Query for poll properties", nickname = "getPolls", notes = "Query for polls that meet a set of specified conditions", response = PollWsResult.class, responseContainer = "List", authorizations = {
        @Authorization(value = "basicAuth")
    }, tags={ "service", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Information about the requested polls", response = PollWsResult.class, responseContainer = "List"),
        @ApiResponse(code = 400, message = "Bad Request"),
        @ApiResponse(code = 401, message = "Unauthorized"),
        @ApiResponse(code = 500, message = "Internal Server Error") })
    @RequestMapping(value = "/ws/polls",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<List<PollWsResult>> getPolls(@NotNull @ApiParam(value = "The query that specifies the polls to be returned", required = true) @Valid @RequestParam(value = "pollQuery", required = true) String pollQuery) {
        return getDelegate().getPolls(pollQuery);
    }


    @ApiOperation(value = "Query the properties of repositories", nickname = "getRepositories", notes = "Query the system for selected repository properties", response = RepositoryWsResult.class, responseContainer = "List", authorizations = {
        @Authorization(value = "basicAuth")
    }, tags={ "repo", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Information about the requested TDB AUs", response = RepositoryWsResult.class, responseContainer = "List"),
        @ApiResponse(code = 400, message = "Bad Request"),
        @ApiResponse(code = 401, message = "Unauthorized"),
        @ApiResponse(code = 500, message = "Internal Server Error") })
    @RequestMapping(value = "/ws/aurepositories",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<List<RepositoryWsResult>> getRepositories(@NotNull @ApiParam(value = "The query that specifies the repository properties to be returned", required = true) @Valid @RequestParam(value = "repositoryQuery", required = true) String repositoryQuery) {
        return getDelegate().getRepositories(repositoryQuery);
    }


    @ApiOperation(value = "Query the properties of repository spaces", nickname = "getRepositorySpaces", notes = "Query the system for selected repository space properties", response = RepositorySpaceWsResult.class, responseContainer = "List", authorizations = {
        @Authorization(value = "basicAuth")
    }, tags={ "repo", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Information about the requested TDB AUs", response = RepositorySpaceWsResult.class, responseContainer = "List"),
        @ApiResponse(code = 400, message = "Bad Request"),
        @ApiResponse(code = 401, message = "Unauthorized"),
        @ApiResponse(code = 500, message = "Internal Server Error") })
    @RequestMapping(value = "/ws/repositoryspaces",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<List<RepositorySpaceWsResult>> getRepositorySpaces(@NotNull @ApiParam(value = "The query that specifies the repository space properties to be returned", required = true) @Valid @RequestParam(value = "repositorySpaceQuery", required = true) String repositorySpaceQuery) {
        return getDelegate().getRepositorySpaces(repositorySpaceQuery);
    }


    @ApiOperation(value = "Query for vote properties", nickname = "getVotes", notes = "Query for votes that meet a set of specified conditions", response = VoteWsResult.class, responseContainer = "List", authorizations = {
        @Authorization(value = "basicAuth")
    }, tags={ "service", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Information about the requested votes", response = VoteWsResult.class, responseContainer = "List"),
        @ApiResponse(code = 400, message = "Bad Request"),
        @ApiResponse(code = 401, message = "Unauthorized"),
        @ApiResponse(code = 500, message = "Internal Server Error") })
    @RequestMapping(value = "/ws/votes",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<List<VoteWsResult>> getVotes(@NotNull @ApiParam(value = "The query that specifies the votes to be returned", required = true) @Valid @RequestParam(value = "voteQuery", required = true) String voteQuery) {
        return getDelegate().getVotes(voteQuery);
    }


    @ApiOperation(value = "Perform a hashing operation", nickname = "putHash", notes = "Perform the hashing of an AU or a URL", response = Resource.class, authorizations = {
        @Authorization(value = "basicAuth")
    }, tags={ "hash", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Information about the performed hashing operation", response = Resource.class),
        @ApiResponse(code = 400, message = "Bad Request"),
        @ApiResponse(code = 401, message = "Unauthorized"),
        @ApiResponse(code = 500, message = "Internal Server Error") })
    @RequestMapping(value = "/ws/hashes",
        produces = { "multipart/form-data" }, 
        method = RequestMethod.PUT)
    default ResponseEntity<Resource> putHash(@ApiParam(value = "The parameters needed to define a hash." ,required=true )  @Valid @RequestBody HasherWsParams hasherWsParams,@ApiParam(value = "Indication of whether the operation should be done synchronously", defaultValue = "true") @Valid @RequestParam(value = "isAsynchronous", required = false, defaultValue="true") Boolean isAsynchronous) {
        return getDelegate().putHash(hasherWsParams, isAsynchronous);
    }


    @ApiOperation(value = "Import a file into an Archival Unit", nickname = "putImportFile", notes = "Import a file as an artifact in an Archival Unit", authorizations = {
        @Authorization(value = "basicAuth")
    }, tags={ "import", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK"),
        @ApiResponse(code = 400, message = "Bad Request"),
        @ApiResponse(code = 401, message = "Unauthorized"),
        @ApiResponse(code = 403, message = "Forbidden"),
        @ApiResponse(code = 415, message = "Unsupported Media Type"),
        @ApiResponse(code = 500, message = "Internal Server Error") })
    @RequestMapping(value = "/ws/aus/import",
        produces = { "application/json" }, 
        consumes = { "multipart/form-data" },
        method = RequestMethod.PUT)
    default ResponseEntity<Void> putImportFile(@ApiParam(value = "The base URL path of the target AU", required=true) @RequestParam(value="targetBaseUrlPath", required=true)  String targetBaseUrlPath,@ApiParam(value = "The target AU URL", required=true) @RequestParam(value="targetUrl", required=true)  String targetUrl,@ApiParam(value = "The content of the file to be imported") @Valid @RequestPart(value="file", required=true) MultipartFile file,@ApiParam(value = "The user-specified properties") @RequestParam(value="userProperties", required=false)  List<String> userProperties) {
        return getDelegate().putImportFile(targetBaseUrlPath, targetUrl, file, userProperties);
    }

}
