/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller;

import org.lockss.app.LockssApp;
import org.lockss.app.LockssDaemon;
import org.lockss.app.ManagerDescs;
import org.lockss.app.ServiceDescr;
import org.lockss.spring.base.BaseSpringBootApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.solr.SolrAutoConfiguration;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication(exclude={SolrAutoConfiguration.class})
@EnableSwagger2
public class PollerApplication
extends BaseSpringBootApplication
implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(PollerApplication.class);
    LockssApp lockssApp;
    private static final LockssApp.ManagerDesc[] myManagerDescs = new LockssApp.ManagerDesc[]{ManagerDescs.PLUGIN_MANAGER_DESC, ManagerDescs.STATE_MANAGER_DESC, ManagerDescs.SCHED_SERVICE_DESC, ManagerDescs.HASH_SERVICE_DESC, ManagerDescs.SYSTEM_METRICS_DESC, ManagerDescs.ACCOUNT_MANAGER_DESC, ManagerDescs.IDENTITY_MANAGER_DESC, ManagerDescs.CRAWL_MANAGER_DESC, ManagerDescs.PSM_MANAGER_DESC, ManagerDescs.POLL_MANAGER_DESC, ManagerDescs.REPOSITORY_MANAGER_DESC, ManagerDescs.STREAM_COMM_MANAGER_DESC, ManagerDescs.ROUTER_MANAGER_DESC, ManagerDescs.SERVLET_MANAGER_DESC, ManagerDescs.REMOTE_API_DESC, ManagerDescs.PLATFORM_CONFIG_STATUS_DESC, ManagerDescs.CONFIG_STATUS_DESC, ManagerDescs.ARCHIVAL_UNIT_STATUS_DESC, ManagerDescs.OVERVIEW_STATUS_DESC, ManagerDescs.CONTENT_SERVLET_MANAGER_DESC, ManagerDescs.PROXY_MANAGER_DESC, ManagerDescs.AUDIT_PROXY_MANAGER_DESC, ManagerDescs.ICP_MANAGER_DESC};

    public static void main(String[] args) {
        logger.info("Starting the Poller REST service...");
        PollerApplication.configure();
        SpringApplication.run(PollerApplication.class, (String[])args);
    }

    public void run(String ... args) {
        if (args != null && args.length > 0) {
            logger.info("Starting the LOCKSS daemon");
            try {
                LockssApp.AppSpec spec = new LockssApp.AppSpec().setService(ServiceDescr.SVC_POLLER).setName("Poller Service").setArgs(args).setSpringApplicatonContext(this.getApplicationContext()).setAppManagers(myManagerDescs).addAppConfig("org.lockss.crawler.jms.enableReceive", "true").addAppConfig("org.lockss.startPlugins", "true").addAppConfig("org.lockss.plugin.startAllAus", "true");
                logger.info("Calling LockssApp.startStatic...");
                this.lockssApp = LockssApp.startStatic(LockssDaemon.class, (LockssApp.AppSpec)spec);
            }
            catch (Exception ex) {
                logger.error("LockssApp.startStatic failed: ", (Throwable)ex);
            }
        } else {
            logger.info("No args provided, daemon not started.");
        }
    }
}

