/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.lockss.laaws.poller.api.AusApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public interface AusApiDelegate {
    public static final Logger log = LoggerFactory.getLogger(AusApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    default public ResponseEntity<Resource> getExportFiles(String auid, String fileType, Boolean isCompress, Boolean isExcludeDirNodes, String xlateFilenames, String filePrefix, Long maxSize, Integer maxVersions) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (((String)this.getAcceptHeader().get()).contains("")) {
                try {
                    return new ResponseEntity(((ObjectMapper)this.getObjectMapper().get()).readValue("", Resource.class), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type ", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AusApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

