/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.lockss.laaws.poller.api.PollsApi;
import org.lockss.laaws.poller.model.PollerDetail;
import org.lockss.laaws.poller.model.PollerPager;
import org.lockss.laaws.poller.model.PollerSummary;
import org.lockss.laaws.poller.model.RepairPager;
import org.lockss.laaws.poller.model.UrlPager;
import org.lockss.laaws.poller.model.VoterDetail;
import org.lockss.laaws.poller.model.VoterPager;
import org.lockss.util.rest.poller.PollDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public interface PollsApiDelegate {
    public static final Logger log = LoggerFactory.getLogger(PollsApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    default public ResponseEntity<String> callPoll(PollDesc body) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (((String)this.getAcceptHeader().get()).contains("application/json")) {
                try {
                    return new ResponseEntity(((ObjectMapper)this.getObjectMapper().get()).readValue("{  \"bytes\": [],  \"empty\": true}", String.class), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PollsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<Void> cancelPoll(String psId) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PollsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<UrlPager> getPollPeerVoteUrls(String pollKey, String peerId, String urls, Integer page, Integer size) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (((String)this.getAcceptHeader().get()).contains("application/json")) {
                try {
                    return new ResponseEntity(((ObjectMapper)this.getObjectMapper().get()).readValue("{\"empty\": false}", UrlPager.class), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PollsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<PollerSummary> getPollStatus(String psId) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (((String)this.getAcceptHeader().get()).contains("application/json")) {
                try {
                    return new ResponseEntity(((ObjectMapper)this.getObjectMapper().get()).readValue("{\"empty\": false}", PollerSummary.class), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PollsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<PollerDetail> getPollerPollDetails(String pollKey) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (((String)this.getAcceptHeader().get()).contains("application/json")) {
                try {
                    return new ResponseEntity(((ObjectMapper)this.getObjectMapper().get()).readValue("{\"empty\": false}", PollerDetail.class), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PollsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<PollerPager> getPollsAsPoller(Integer size, Integer page) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (((String)this.getAcceptHeader().get()).contains("application/json")) {
                try {
                    return new ResponseEntity(((ObjectMapper)this.getObjectMapper().get()).readValue("{\"empty\": false}", PollerPager.class), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PollsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<VoterPager> getPollsAsVoter(Integer size, Integer page) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (((String)this.getAcceptHeader().get()).contains("application/json")) {
                try {
                    return new ResponseEntity(((ObjectMapper)this.getObjectMapper().get()).readValue("{\"empty\": false}", VoterPager.class), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PollsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<RepairPager> getRepairQueueData(String pollKey, String repair, Integer page, Integer size) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (((String)this.getAcceptHeader().get()).contains("application/json")) {
                try {
                    return new ResponseEntity(((ObjectMapper)this.getObjectMapper().get()).readValue("{\"empty\": false}", RepairPager.class), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PollsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<UrlPager> getTallyUrls(String pollKey, String tally, Integer page, Integer size) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (((String)this.getAcceptHeader().get()).contains("application/json")) {
                try {
                    return new ResponseEntity(((ObjectMapper)this.getObjectMapper().get()).readValue("{\"empty\": false}", UrlPager.class), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PollsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<VoterDetail> getVoterPollDetails(String pollKey) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (((String)this.getAcceptHeader().get()).contains("application/json")) {
                try {
                    return new ResponseEntity(((ObjectMapper)this.getObjectMapper().get()).readValue("{\"empty\": false}", VoterDetail.class), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PollsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

