/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.impl;

import java.io.IOException;
import java.util.Properties;
import org.lockss.app.LockssDaemon;
import org.lockss.config.ConfigManager;
import org.lockss.config.Configuration;
import org.lockss.db.DbException;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.plugin.AuUtil;
import org.lockss.plugin.Plugin;
import org.lockss.plugin.PluginManager;
import org.lockss.util.Logger;
import org.lockss.util.PropUtil;
import org.lockss.util.os.PlatformUtil;
import org.lockss.util.rest.repo.LockssRepository;
import org.lockss.ws.entities.RepositorySpaceWsResult;

public class RepositorySpaceWsSource
extends RepositorySpaceWsResult {
    private static Logger log = Logger.getLogger();
    private PlatformUtil.DF puDf;
    private boolean sizePopulated;
    private boolean usedPopulated;
    private boolean freePopulated;
    private boolean percentageFullPopulated;
    private boolean activeCountPopulated;
    private boolean inactiveCountPopulated;
    private boolean deletedCountPopulated;
    private boolean orphanedCountPopulated;
    private int allActiveCount = -1;
    private int allInactiveCount = -1;
    private int allDeletedCount = -1;
    private int allOrphanedCount = -1;

    public RepositorySpaceWsSource(String repositorySpaceId, PlatformUtil.DF puDf) {
        this.setRepositorySpaceId(repositorySpaceId);
        this.puDf = puDf;
    }

    public String getRepositorySpaceId() {
        return super.getRepositorySpaceId();
    }

    public Long getSize() {
        if (!this.sizePopulated) {
            this.setSize(Long.valueOf(this.puDf.getSize()));
            this.sizePopulated = true;
        }
        return super.getSize();
    }

    public Long getUsed() {
        if (!this.usedPopulated) {
            this.setUsed(Long.valueOf(this.puDf.getUsed()));
            this.usedPopulated = true;
        }
        return super.getUsed();
    }

    public Long getFree() {
        if (!this.freePopulated) {
            this.setFree(Long.valueOf(this.puDf.getAvail()));
            this.freePopulated = true;
        }
        return super.getFree();
    }

    public Double getPercentageFull() {
        if (!this.percentageFullPopulated) {
            this.setPercentageFull(Double.valueOf(this.puDf.getPercent()));
            this.percentageFullPopulated = true;
        }
        return super.getPercentageFull();
    }

    public Integer getActiveCount() {
        if (!this.activeCountPopulated) {
            if (this.allActiveCount < 0) {
                this.populateCounts();
            }
            this.setActiveCount(Integer.valueOf(this.allActiveCount));
            this.activeCountPopulated = true;
        }
        return super.getActiveCount();
    }

    public Integer getInactiveCount() {
        if (!this.inactiveCountPopulated) {
            if (this.allInactiveCount < 0) {
                this.populateCounts();
            }
            this.setInactiveCount(Integer.valueOf(this.allInactiveCount));
            this.inactiveCountPopulated = true;
        }
        return super.getInactiveCount();
    }

    public Integer getDeletedCount() {
        if (!this.deletedCountPopulated) {
            if (this.allDeletedCount < 0) {
                this.populateCounts();
            }
            this.setDeletedCount(Integer.valueOf(this.allDeletedCount));
            this.deletedCountPopulated = true;
        }
        return super.getDeletedCount();
    }

    public Integer getOrphanedCount() {
        if (!this.orphanedCountPopulated) {
            if (this.allOrphanedCount < 0) {
                this.populateCounts();
            }
            this.setOrphanedCount(Integer.valueOf(this.allOrphanedCount));
            this.orphanedCountPopulated = true;
        }
        return super.getOrphanedCount();
    }

    private void populateCounts() {
        String DEBUG_HEADER = "populateCounts(): ";
        this.allActiveCount = 0;
        this.allInactiveCount = 0;
        this.allDeletedCount = 0;
        this.allOrphanedCount = 0;
        LockssRepository repo = LockssDaemon.getLockssDaemon().getRepositoryManager().getV2Repository().getRepository();
        PluginManager pluginMgr = (PluginManager)LockssDaemon.getManagerByKeyStatic((String)LockssDaemon.PLUGIN_MANAGER);
        try {
            for (String namespace : repo.getNamespaces()) {
                if (log.isDebug3()) {
                    log.debug3("populateCounts(): namespace = " + namespace);
                }
                try {
                    for (String auid : repo.getAuIds(namespace)) {
                        ArchivalUnit au;
                        if (log.isDebug3()) {
                            log.debug3("populateCounts(): auid = " + auid);
                        }
                        if ((au = pluginMgr.getAuFromId(auid)) != null) {
                            ++this.allActiveCount;
                            continue;
                        }
                        String auKey = PluginManager.auKeyFromAuId((String)auid);
                        Properties auidProps = null;
                        try {
                            auidProps = PropUtil.canonicalEncodedStringToProps((String)auKey);
                        }
                        catch (Exception e) {
                            log.warning("Couldn't decode AUKey : " + auKey, (Throwable)e);
                        }
                        String pluginKey = PluginManager.pluginKeyFromAuId((String)auid);
                        Plugin plugin = pluginMgr.getPlugin(pluginKey);
                        boolean isOrphaned = true;
                        if (plugin != null && auidProps != null) {
                            Configuration defConfig = ConfigManager.fromProperties((Properties)auidProps);
                            boolean bl = isOrphaned = !AuUtil.isConfigCompatibleWithPlugin((Configuration)defConfig, (Plugin)plugin);
                        }
                        if (isOrphaned) {
                            ++this.allOrphanedCount;
                            continue;
                        }
                        Configuration config = null;
                        try {
                            config = pluginMgr.getStoredAuConfigurationAsConfiguration(auid);
                        }
                        catch (DbException dbe) {
                            log.warning("Exception caught getting stored configuration for auid '" + auid + "'", (Throwable)dbe);
                        }
                        if (config == null || config.isEmpty()) {
                            ++this.allDeletedCount;
                            continue;
                        }
                        boolean isInactive = config.getBoolean("reserved.disabled", false);
                        if (isInactive) {
                            ++this.allInactiveCount;
                            continue;
                        }
                        ++this.allDeletedCount;
                    }
                }
                catch (IOException ioe) {
                    log.error("Exception caught for namespace '" + namespace + "': Ignoring namespace", (Throwable)ioe);
                }
            }
        }
        catch (IOException ioe) {
            log.error("Exception caught getting namespaces", (Throwable)ioe);
        }
    }
}

