/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.lockss.laaws.poller.model.LinkDesc;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Description of the RepairQueue.")
@Validated
public class RepairQueue {
    @JsonProperty(value="numPending")
    private Integer numPending = null;
    @JsonProperty(value="pendingLink")
    private LinkDesc pendingLink = null;
    @JsonProperty(value="numActive")
    private Integer numActive = null;
    @JsonProperty(value="activeLink")
    private LinkDesc activeLink = null;
    @JsonProperty(value="numCompleted")
    private Integer numCompleted = null;
    @JsonProperty(value="completedLink")
    private LinkDesc completedLink = null;

    public RepairQueue numPending(Integer numPending) {
        this.numPending = numPending;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of pending repairs")
    @NotNull
    public Integer getNumPending() {
        return this.numPending;
    }

    public void setNumPending(Integer numPending) {
        this.numPending = numPending;
    }

    public RepairQueue pendingLink(LinkDesc pendingLink) {
        this.pendingLink = pendingLink;
        return this;
    }

    @ApiModelProperty(value="A link to the urls with pending repairs.")
    @Valid
    public LinkDesc getPendingLink() {
        return this.pendingLink;
    }

    public void setPendingLink(LinkDesc pendingLink) {
        this.pendingLink = pendingLink;
    }

    public RepairQueue numActive(Integer numActive) {
        this.numActive = numActive;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of active repairs")
    @NotNull
    public Integer getNumActive() {
        return this.numActive;
    }

    public void setNumActive(Integer numActive) {
        this.numActive = numActive;
    }

    public RepairQueue activeLink(LinkDesc activeLink) {
        this.activeLink = activeLink;
        return this;
    }

    @ApiModelProperty(value="A link to the urls with active repairs.")
    @Valid
    public LinkDesc getActiveLink() {
        return this.activeLink;
    }

    public void setActiveLink(LinkDesc activeLink) {
        this.activeLink = activeLink;
    }

    public RepairQueue numCompleted(Integer numCompleted) {
        this.numCompleted = numCompleted;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of completed repairs")
    @NotNull
    public Integer getNumCompleted() {
        return this.numCompleted;
    }

    public void setNumCompleted(Integer numCompleted) {
        this.numCompleted = numCompleted;
    }

    public RepairQueue completedLink(LinkDesc completedLink) {
        this.completedLink = completedLink;
        return this;
    }

    @ApiModelProperty(value="A link to the urls with completed repairs.")
    @Valid
    public LinkDesc getCompletedLink() {
        return this.completedLink;
    }

    public void setCompletedLink(LinkDesc completedLink) {
        this.completedLink = completedLink;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepairQueue repairQueue = (RepairQueue)o;
        return Objects.equals(this.numPending, repairQueue.numPending) && Objects.equals(this.pendingLink, repairQueue.pendingLink) && Objects.equals(this.numActive, repairQueue.numActive) && Objects.equals(this.activeLink, repairQueue.activeLink) && Objects.equals(this.numCompleted, repairQueue.numCompleted) && Objects.equals(this.completedLink, repairQueue.completedLink);
    }

    public int hashCode() {
        return Objects.hash(this.numPending, this.pendingLink, this.numActive, this.activeLink, this.numCompleted, this.completedLink);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RepairQueue {\n");
        sb.append("    numPending: ").append(this.toIndentedString((Object)this.numPending)).append("\n");
        sb.append("    pendingLink: ").append(this.toIndentedString((Object)this.pendingLink)).append("\n");
        sb.append("    numActive: ").append(this.toIndentedString((Object)this.numActive)).append("\n");
        sb.append("    activeLink: ").append(this.toIndentedString((Object)this.activeLink)).append("\n");
        sb.append("    numCompleted: ").append(this.toIndentedString((Object)this.numCompleted)).append("\n");
        sb.append("    completedLink: ").append(this.toIndentedString((Object)this.completedLink)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

