/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.lockss.laaws.poller.model.PageDesc;
import org.lockss.laaws.poller.model.VoterSummary;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A page of voter poll summary.")
@Validated
public class VoterPager {
    @JsonProperty(value="pageDesc")
    private PageDesc pageDesc = null;
    @JsonProperty(value="polls")
    @Valid
    private List<VoterSummary> polls = null;

    public VoterPager pageDesc(PageDesc pageDesc) {
        this.pageDesc = pageDesc;
        return this;
    }

    @ApiModelProperty(required=true, value="The descriptor for this pager.")
    @NotNull
    @Valid
    public PageDesc getPageDesc() {
        return this.pageDesc;
    }

    public void setPageDesc(PageDesc pageDesc) {
        this.pageDesc = pageDesc;
    }

    public VoterPager polls(List<VoterSummary> polls) {
        this.polls = polls;
        return this;
    }

    public VoterPager addPollsItem(VoterSummary pollsItem) {
        if (this.polls == null) {
            this.polls = new ArrayList();
        }
        this.polls.add(pollsItem);
        return this;
    }

    @ApiModelProperty(value="The list of polls for the current page or null")
    @Valid
    public List<VoterSummary> getPolls() {
        return this.polls;
    }

    public void setPolls(List<VoterSummary> polls) {
        this.polls = polls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoterPager voterPager = (VoterPager)o;
        return Objects.equals(this.pageDesc, voterPager.pageDesc) && Objects.equals(this.polls, voterPager.polls);
    }

    public int hashCode() {
        return Objects.hash(this.pageDesc, this.polls);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VoterPager {\n");
        sb.append("    pageDesc: ").append(this.toIndentedString((Object)this.pageDesc)).append("\n");
        sb.append("    polls: ").append(this.toIndentedString((Object)this.polls)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

