/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.lockss.laaws.poller.model.LinkDesc;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A summary of a poll in which we are acting just as a voter.")
@Validated
public class VoterSummary {
    @JsonProperty(value="auId")
    private String auId = null;
    @JsonProperty(value="caller")
    private String caller = null;
    @JsonProperty(value="start")
    private Long start = null;
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="deadline")
    private Long deadline = null;
    @JsonProperty(value="pollKey")
    private String pollKey = null;
    @JsonProperty(value="detailLink")
    private LinkDesc detailLink = null;

    public VoterSummary auId(String auId) {
        this.auId = auId;
        return this;
    }

    @ApiModelProperty(required=true, value="The id for the au being polled.")
    @NotNull
    public String getAuId() {
        return this.auId;
    }

    public void setAuId(String auId) {
        this.auId = auId;
    }

    public VoterSummary caller(String caller) {
        this.caller = caller;
        return this;
    }

    @ApiModelProperty(required=true, value="The id of who called the poll.")
    @NotNull
    public String getCaller() {
        return this.caller;
    }

    public void setCaller(String caller) {
        this.caller = caller;
    }

    public VoterSummary start(Long start) {
        this.start = start;
        return this;
    }

    @ApiModelProperty(required=true, value="The timestamp for when the poll started.")
    @NotNull
    public Long getStart() {
        return this.start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public VoterSummary status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The current status of the poll.")
    @NotNull
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public VoterSummary deadline(Long deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(required=true, value="The deadline for voting in this poll.")
    @NotNull
    public Long getDeadline() {
        return this.deadline;
    }

    public void setDeadline(Long deadline) {
        this.deadline = deadline;
    }

    public VoterSummary pollKey(String pollKey) {
        this.pollKey = pollKey;
        return this;
    }

    @ApiModelProperty(required=true, value="Key generated by poll manager when poll was created.")
    @NotNull
    public String getPollKey() {
        return this.pollKey;
    }

    public void setPollKey(String pollKey) {
        this.pollKey = pollKey;
    }

    public VoterSummary detailLink(LinkDesc detailLink) {
        this.detailLink = detailLink;
        return this;
    }

    @ApiModelProperty(value="A link to the voter detals")
    @Valid
    public LinkDesc getDetailLink() {
        return this.detailLink;
    }

    public void setDetailLink(LinkDesc detailLink) {
        this.detailLink = detailLink;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoterSummary voterSummary = (VoterSummary)o;
        return Objects.equals(this.auId, voterSummary.auId) && Objects.equals(this.caller, voterSummary.caller) && Objects.equals(this.start, voterSummary.start) && Objects.equals(this.status, voterSummary.status) && Objects.equals(this.deadline, voterSummary.deadline) && Objects.equals(this.pollKey, voterSummary.pollKey) && Objects.equals(this.detailLink, voterSummary.detailLink);
    }

    public int hashCode() {
        return Objects.hash(this.auId, this.caller, this.start, this.status, this.deadline, this.pollKey, this.detailLink);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VoterSummary {\n");
        sb.append("    auId: ").append(this.toIndentedString((Object)this.auId)).append("\n");
        sb.append("    caller: ").append(this.toIndentedString((Object)this.caller)).append("\n");
        sb.append("    start: ").append(this.toIndentedString((Object)this.start)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString((Object)this.deadline)).append("\n");
        sb.append("    pollKey: ").append(this.toIndentedString((Object)this.pollKey)).append("\n");
        sb.append("    detailLink: ").append(this.toIndentedString((Object)this.detailLink)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

