/**
 * NOTE: This class is auto generated by the swagger code generator program (3.0.52).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.lockss.laaws.poller.api;

import org.lockss.laaws.poller.model.ErrorResult;
import org.springframework.core.io.Resource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.bind.annotation.CookieValue;

import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import java.util.List;
import java.util.Map;


@Validated
public interface AusApi {

    AusApiDelegate getDelegate();

    @Operation(summary = "Export artifacts in an Archival Unit", description = "Export artifacts in an Archival Unit as a group of archives", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "export" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "The archives with the requested artifacts", content = @Content(mediaType = "multipart/form-data", schema = @Schema(implementation = Resource.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.", content = @Content(mediaType = "application/json", schema = @Schema(implementation = ErrorResult.class))) })
    @RequestMapping(value = "/aus/{auid}/export",
        produces = { "multipart/form-data", "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<Resource> getExportFiles(@Parameter(in = ParameterIn.PATH, description = "Identifier of the Archival Unit containing the artifacts", required=true, schema=@Schema()) @PathVariable("auid") String auid
, @Parameter(in = ParameterIn.QUERY, description = "The type of archive to create" ,schema=@Schema(allowableValues={ "WARC_RESPONSE", "WARC_RESOURCE", "ARC_RESPONSE", "ARC_RESOURCE", "ZIP" }
, defaultValue="WARC_RESPONSE")) @Valid @RequestParam(value = "fileType", required = false, defaultValue="WARC_RESPONSE") String fileType
, @Parameter(in = ParameterIn.QUERY, description = "Indication of whether contents should be compressed" ,schema=@Schema( defaultValue="true")) @Valid @RequestParam(value = "isCompress", required = false, defaultValue="true") Boolean isCompress
, @Parameter(in = ParameterIn.QUERY, description = "Indication of whether directories should be excluded" ,schema=@Schema( defaultValue="true")) @Valid @RequestParam(value = "isExcludeDirNodes", required = false, defaultValue="true") Boolean isExcludeDirNodes
, @Parameter(in = ParameterIn.QUERY, description = "Type of filename translation to be done" ,schema=@Schema(allowableValues={ "XLATE_NONE", "XLATE_WINDOWS", "XLATE_MAC" }
, defaultValue="XLATE_NONE")) @Valid @RequestParam(value = "xlateFilenames", required = false, defaultValue="XLATE_NONE") String xlateFilenames
, @Parameter(in = ParameterIn.QUERY, description = "The prefix to be used to name the exported file" ,schema=@Schema( defaultValue="lockss_export")) @Valid @RequestParam(value = "filePrefix", required = false, defaultValue="lockss_export") String filePrefix
, @Parameter(in = ParameterIn.QUERY, description = "The maximum size of the exported file" ,schema=@Schema( defaultValue="-1")) @Valid @RequestParam(value = "maxSize", required = false, defaultValue="-1") Long maxSize
, @Parameter(in = ParameterIn.QUERY, description = "The maximum number of versions of an artifact to be exported" ,schema=@Schema( defaultValue="-1")) @Valid @RequestParam(value = "maxVersions", required = false, defaultValue="-1") Integer maxVersions
) {
        return getDelegate().getExportFiles(auid, fileType, isCompress, isExcludeDirNodes, xlateFilenames, filePrefix, maxSize, maxVersions);
    }

}

