package org.lockss.laaws.poller.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.validation.annotation.Validated;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;

/**
 * AusImportBody
 */
@Validated



public class AusImportBody   {
  @JsonProperty("targetBaseUrlPath")
  private String targetBaseUrlPath = null;

  @JsonProperty("targetUrl")
  private String targetUrl = null;

  @JsonProperty("file")
  private Resource file = null;

  @JsonProperty("userProperties")
  @Valid
  private List<String> userProperties = null;

  public AusImportBody targetBaseUrlPath(String targetBaseUrlPath) {
    this.targetBaseUrlPath = targetBaseUrlPath;
    return this;
  }

  /**
   * The base URL path of the target AU
   * @return targetBaseUrlPath
   **/
  @Schema(required = true, description = "The base URL path of the target AU")
      @NotNull

    public String getTargetBaseUrlPath() {
    return targetBaseUrlPath;
  }

  public void setTargetBaseUrlPath(String targetBaseUrlPath) {
    this.targetBaseUrlPath = targetBaseUrlPath;
  }

  public AusImportBody targetUrl(String targetUrl) {
    this.targetUrl = targetUrl;
    return this;
  }

  /**
   * The target AU URL
   * @return targetUrl
   **/
  @Schema(required = true, description = "The target AU URL")
      @NotNull

    public String getTargetUrl() {
    return targetUrl;
  }

  public void setTargetUrl(String targetUrl) {
    this.targetUrl = targetUrl;
  }

  public AusImportBody file(Resource file) {
    this.file = file;
    return this;
  }

  /**
   * The content of the file to be imported
   * @return file
   **/
  @Schema(required = true, description = "The content of the file to be imported")
      @NotNull

    @Valid
    public Resource getFile() {
    return file;
  }

  public void setFile(Resource file) {
    this.file = file;
  }

  public AusImportBody userProperties(List<String> userProperties) {
    this.userProperties = userProperties;
    return this;
  }

  public AusImportBody addUserPropertiesItem(String userPropertiesItem) {
    if (this.userProperties == null) {
      this.userProperties = new ArrayList<>();
    }
    this.userProperties.add(userPropertiesItem);
    return this;
  }

  /**
   * The user-specified properties
   * @return userProperties
   **/
  @Schema(description = "The user-specified properties")
  
    public List<String> getUserProperties() {
    return userProperties;
  }

  public void setUserProperties(List<String> userProperties) {
    this.userProperties = userProperties;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AusImportBody ausImportBody = (AusImportBody) o;
    return Objects.equals(this.targetBaseUrlPath, ausImportBody.targetBaseUrlPath) &&
        Objects.equals(this.targetUrl, ausImportBody.targetUrl) &&
        Objects.equals(this.file, ausImportBody.file) &&
        Objects.equals(this.userProperties, ausImportBody.userProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(targetBaseUrlPath, targetUrl, file, userProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AusImportBody {\n");
    
    sb.append("    targetBaseUrlPath: ").append(toIndentedString(targetBaseUrlPath)).append("\n");
    sb.append("    targetUrl: ").append(toIndentedString(targetUrl)).append("\n");
    sb.append("    file: ").append(toIndentedString(file)).append("\n");
    sb.append("    userProperties: ").append(toIndentedString(userProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
