package org.lockss.laaws.poller.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.validation.annotation.Validated;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;

/**
 * The information needed to page in a long list of data
 */
@Schema(description = "The information needed to page in a long list of data")
@Validated



public class PageDesc   {
  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("size")
  private Integer size = null;

  @JsonProperty("total")
  private Integer total = null;

  @JsonProperty("prevPage")
  private String prevPage = null;

  @JsonProperty("nextPage")
  private String nextPage = null;

  public PageDesc page(Integer page) {
    this.page = page;
    return this;
  }

  /**
   * The page number
   * @return page
   **/
  @Schema(example = "10", required = true, description = "The page number")
      @NotNull

    public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  public PageDesc size(Integer size) {
    this.size = size;
    return this;
  }

  /**
   * The size or number of elements on a page
   * @return size
   **/
  @Schema(example = "5", required = true, description = "The size or number of elements on a page")
      @NotNull

    public Integer getSize() {
    return size;
  }

  public void setSize(Integer size) {
    this.size = size;
  }

  public PageDesc total(Integer total) {
    this.total = total;
    return this;
  }

  /**
   * The mTotal number of elements.
   * @return total
   **/
  @Schema(example = "150", required = true, description = "The mTotal number of elements.")
      @NotNull

    public Integer getTotal() {
    return total;
  }

  public void setTotal(Integer total) {
    this.total = total;
  }

  public PageDesc prevPage(String prevPage) {
    this.prevPage = prevPage;
    return this;
  }

  /**
   * The url of the prev page of results or null
   * @return prevPage
   **/
  @Schema(description = "The url of the prev page of results or null")
  
    public String getPrevPage() {
    return prevPage;
  }

  public void setPrevPage(String prevPage) {
    this.prevPage = prevPage;
  }

  public PageDesc nextPage(String nextPage) {
    this.nextPage = nextPage;
    return this;
  }

  /**
   * The url to the next page of results or null.
   * @return nextPage
   **/
  @Schema(description = "The url to the next page of results or null.")
  
    public String getNextPage() {
    return nextPage;
  }

  public void setNextPage(String nextPage) {
    this.nextPage = nextPage;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PageDesc pageDesc = (PageDesc) o;
    return Objects.equals(this.page, pageDesc.page) &&
        Objects.equals(this.size, pageDesc.size) &&
        Objects.equals(this.total, pageDesc.total) &&
        Objects.equals(this.prevPage, pageDesc.prevPage) &&
        Objects.equals(this.nextPage, pageDesc.nextPage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(page, size, total, prevPage, nextPage);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PageDesc {\n");
    
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    prevPage: ").append(toIndentedString(prevPage)).append("\n");
    sb.append("    nextPage: ").append(toIndentedString(nextPage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
