/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import org.lockss.laaws.poller.api.PollsApiDelegate;
import org.lockss.laaws.poller.model.ErrorResult;
import org.lockss.laaws.poller.model.PollerDetail;
import org.lockss.laaws.poller.model.PollerPager;
import org.lockss.laaws.poller.model.PollerSummary;
import org.lockss.laaws.poller.model.RepairPager;
import org.lockss.laaws.poller.model.UrlPager;
import org.lockss.laaws.poller.model.VoterDetail;
import org.lockss.laaws.poller.model.VoterPager;
import org.lockss.util.rest.poller.PollDesc;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
public interface PollsApi {
    public PollsApiDelegate getDelegate();

    @Operation(summary="Send a request to call a poll to the poller", description="Use the information found in the descriptor object to initiate a  poll.", security={@SecurityRequirement(name="basicAuth")}, tags={"service"})
    @ApiResponses(value={@ApiResponse(responseCode="202", description="The Poll request has been accepted and added to the queue.", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/polls"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    default public ResponseEntity<String> callPoll(@Parameter(in=ParameterIn.DEFAULT, description="A poll descriptor object used to define the poll being requested.", required=true, schema=@Schema) @Valid @RequestBody PollDesc body) {
        return this.getDelegate().callPoll(body);
    }

    @Operation(summary="Stop a poll and remove from queue.", description="Stop a running poll and delete any schecduled polls for poll with the poll service id.", security={@SecurityRequirement(name="basicAuth")}, tags={"service"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Poll successfully stopped"), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/polls/{psId}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    default public ResponseEntity<Void> cancelPoll(@Parameter(in=ParameterIn.PATH, description="The poll id.", required=true, schema=@Schema) @PathVariable(value="psId") String psId) {
        return this.getDelegate().cancelPoll(psId);
    }

    @Operation(summary="Poll Peer Data", description="Return the list of urls of vote type for a given peer in a specific poll.", security={@SecurityRequirement(name="basicAuth")}, tags={"poll-detail"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="A pagable list of voter urls with a given status.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UrlPager.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/polls/{pollKey}/peer/{peerId}"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<UrlPager> getPollPeerVoteUrls(@Parameter(in=ParameterIn.PATH, description="The pollKey from the PollDetail.", required=true, schema=@Schema) @PathVariable(value="pollKey") String pollKey, @Parameter(in=ParameterIn.PATH, description="The peerId from the Poll Detail.PeerData.", required=true, schema=@Schema) @PathVariable(value="peerId") String peerId, @NotNull @Parameter(in=ParameterIn.QUERY, description="The voter urls to return.", required=true, schema=@Schema(allowableValues={"agreed", "disagreed", "pollerOnly", "voterOnly"})) @Valid @RequestParam(value="urls", required=true) String urls, @Parameter(in=ParameterIn.QUERY, description="The page number", schema=@Schema) @Valid @RequestParam(value="page", required=false) Integer page, @Parameter(in=ParameterIn.QUERY, description="The page size", schema=@Schema) @Valid @RequestParam(value="size", required=false) Integer size) {
        return this.getDelegate().getPollPeerVoteUrls(pollKey, peerId, urls, page, size);
    }

    @Operation(summary="Get queued poll status", description="Get the status of a previously queued poll.", security={@SecurityRequirement(name="basicAuth")}, tags={"service"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Poll info returned.", content={@Content(mediaType="application/json", schema=@Schema(implementation=PollerSummary.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/polls/{psId}"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<PollerSummary> getPollStatus(@Parameter(in=ParameterIn.PATH, description="The poll id.", required=true, schema=@Schema) @PathVariable(value="psId") String psId) {
        return this.getDelegate().getPollStatus(psId);
    }

    @Operation(summary="PollerDetails", description="Return the detailed information about a poll.", security={@SecurityRequirement(name="basicAuth")}, tags={"poller-polls"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Detailed poll info returned.", content={@Content(mediaType="application/json", schema=@Schema(implementation=PollerDetail.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/polls/poller/{pollKey}"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<PollerDetail> getPollerPollDetails(@Parameter(in=ParameterIn.PATH, description="The key assigned by the PollManager.", required=true, schema=@Schema) @PathVariable(value="pollKey") String pollKey) {
        return this.getDelegate().getPollerPollDetails(pollKey);
    }

    @Operation(summary="Get the list of recent polls as poller.", description="Get the list of recent polls as poller from the poll queue. if size and page are passed in use those arguments to limit return data.", security={@SecurityRequirement(name="basicAuth")}, tags={"poller-polls"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="A pagable list has been returned.", content={@Content(mediaType="application/json", schema=@Schema(implementation=PollerPager.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/polls/poller"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<PollerPager> getPollsAsPoller(@Parameter(in=ParameterIn.QUERY, description="Size of the page to retrieve.", schema=@Schema) @Valid @RequestParam(value="size", required=false) Integer size, @Parameter(in=ParameterIn.QUERY, description="Number of the page to retrieve.", schema=@Schema) @Valid @RequestParam(value="page", required=false) Integer page) {
        return this.getDelegate().getPollsAsPoller(size, page);
    }

    @Operation(summary="Get the list of recent voter only polls.", description="Get the list of recent polls as voter from the poll queue. if size and page are passed in use those arguments to limit return data.", security={@SecurityRequirement(name="basicAuth")}, tags={"voter-polls"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="A pagable list has been returned.", content={@Content(mediaType="application/json", schema=@Schema(implementation=VoterPager.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/polls/voter"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<VoterPager> getPollsAsVoter(@Parameter(in=ParameterIn.QUERY, description="Size of the page to retrieve.", schema=@Schema) @Valid @RequestParam(value="size", required=false) Integer size, @Parameter(in=ParameterIn.QUERY, description="Number of the page to retrieve.", schema=@Schema) @Valid @RequestParam(value="page", required=false) Integer page) {
        return this.getDelegate().getPollsAsVoter(size, page);
    }

    @Operation(summary="Poll Repairs", description="Return the repair status for a specific poll.", security={@SecurityRequirement(name="basicAuth")}, tags={"poll-detail"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="A pagable list of repair queue elements.", content={@Content(mediaType="application/json", schema=@Schema(implementation=RepairPager.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/polls/{pollKey}/repairs"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<RepairPager> getRepairQueueData(@Parameter(in=ParameterIn.PATH, description="The pollKey as listed in the PollDetail object.", required=true, schema=@Schema) @PathVariable(value="pollKey") String pollKey, @NotNull @Parameter(in=ParameterIn.QUERY, description="The repair queue elements to return.", required=true, schema=@Schema(allowableValues={"pending", "active", "completed"})) @Valid @RequestParam(value="repair", required=true) String repair, @Parameter(in=ParameterIn.QUERY, description="The page number.", schema=@Schema) @Valid @RequestParam(value="page", required=false) Integer page, @Parameter(in=ParameterIn.QUERY, description="The size of the page.", schema=@Schema) @Valid @RequestParam(value="size", required=false) Integer size) {
        return this.getDelegate().getRepairQueueData(pollKey, repair, page, size);
    }

    @Operation(summary="Page Tally", description="Return the vote tallies for a specific poll.", security={@SecurityRequirement(name="basicAuth")}, tags={"poll-detail"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="A pagable list of urls for given tally type.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UrlPager.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/polls/{pollKey}/tallies"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<UrlPager> getTallyUrls(@Parameter(in=ParameterIn.PATH, description="The pollKey as listed in the PollDetail object.", required=true, schema=@Schema) @PathVariable(value="pollKey") String pollKey, @NotNull @Parameter(in=ParameterIn.QUERY, description="The kind of tally element to return.", required=true, schema=@Schema(allowableValues={"agree", "disagree", "error", "noQuorum", "tooClose"})) @Valid @RequestParam(value="tally", required=true) String tally, @Parameter(in=ParameterIn.QUERY, description="The page number.", schema=@Schema) @Valid @RequestParam(value="page", required=false) Integer page, @Parameter(in=ParameterIn.QUERY, description="The size of the page.", schema=@Schema) @Valid @RequestParam(value="size", required=false) Integer size) {
        return this.getDelegate().getTallyUrls(pollKey, tally, page, size);
    }

    @Operation(summary="VoterDetails", description="Return the detailed information about a poll.", security={@SecurityRequirement(name="basicAuth")}, tags={"voter-polls"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Detailed poll info returned.", content={@Content(mediaType="application/json", schema=@Schema(implementation=VoterDetail.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/polls/voter/{pollKey}"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<VoterDetail> getVoterPollDetails(@Parameter(in=ParameterIn.PATH, description="The key assigned by the PollManager.", required=true, schema=@Schema) @PathVariable(value="pollKey") String pollKey) {
        return this.getDelegate().getVoterPollDetails(pollKey);
    }
}

