/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.lockss.laaws.poller.api.WsApi;
import org.lockss.ws.entities.HasherWsParams;
import org.lockss.ws.entities.PeerWsResult;
import org.lockss.ws.entities.PollWsResult;
import org.lockss.ws.entities.RepositorySpaceWsResult;
import org.lockss.ws.entities.RepositoryWsResult;
import org.lockss.ws.entities.VoteWsResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.multipart.MultipartFile;

public interface WsApiDelegate {
    public static final Logger log = LoggerFactory.getLogger(WsApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    default public ResponseEntity<String> deleteHash(String requestId) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((String)this.getObjectMapper().get().readValue("\"\"", String.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<Resource> getAllHashes() {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((Resource)this.getObjectMapper().get().readValue("\"\"", Resource.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<Resource> getHash(String requestId) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((Resource)this.getObjectMapper().get().readValue("\"\"", Resource.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<List<PeerWsResult>> getPeers(String peerQuery) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((List)this.getObjectMapper().get().readValue("[ {\n  \"peerId\" : \"peerId\"\n}, {\n  \"peerId\" : \"peerId\"\n} ]", List.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<List<PollWsResult>> getPolls(String pollQuery) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((List)this.getObjectMapper().get().readValue("[ {\n  \"auId\" : \"auId\",\n  \"auName\" : \"auName\"\n}, {\n  \"auId\" : \"auId\",\n  \"auName\" : \"auName\"\n} ]", List.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<List<RepositoryWsResult>> getRepositories(String repositoryQuery) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((List)this.getObjectMapper().get().readValue("[ {\n  \"repositorySpaceId\" : \"repositorySpaceId\"\n}, {\n  \"repositorySpaceId\" : \"repositorySpaceId\"\n} ]", List.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<List<RepositorySpaceWsResult>> getRepositorySpaces(String repositorySpaceQuery) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((List)this.getObjectMapper().get().readValue("[ {\n  \"repositorySpaceId\" : \"repositorySpaceId\"\n}, {\n  \"repositorySpaceId\" : \"repositorySpaceId\"\n} ]", List.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<List<VoteWsResult>> getVotes(String voteQuery) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((List)this.getObjectMapper().get().readValue("[ {\n  \"auId\" : \"auId\",\n  \"auName\" : \"auName\"\n}, {\n  \"auId\" : \"auId\",\n  \"auName\" : \"auName\"\n} ]", List.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<Resource> putHash(HasherWsParams body, Boolean isAsynchronous) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((Resource)this.getObjectMapper().get().readValue("\"\"", Resource.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<Void> putImportFile(String targetBaseUrlPath, String targetUrl, MultipartFile file, List<String> userProperties) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }
}

