/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lockss.app.LockssDaemon;
import org.lockss.laaws.poller.api.PollsApiDelegate;
import org.lockss.laaws.poller.impl.Page;
import org.lockss.laaws.poller.model.LinkDesc;
import org.lockss.laaws.poller.model.PageDesc;
import org.lockss.laaws.poller.model.PeerData;
import org.lockss.laaws.poller.model.PollerDetail;
import org.lockss.laaws.poller.model.PollerPager;
import org.lockss.laaws.poller.model.PollerSummary;
import org.lockss.laaws.poller.model.RepairData;
import org.lockss.laaws.poller.model.RepairPager;
import org.lockss.laaws.poller.model.RepairQueue;
import org.lockss.laaws.poller.model.TallyData;
import org.lockss.laaws.poller.model.UrlPager;
import org.lockss.laaws.poller.model.VoterDetail;
import org.lockss.laaws.poller.model.VoterPager;
import org.lockss.laaws.poller.model.VoterSummary;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.plugin.CachedUrlSet;
import org.lockss.plugin.PluginManager;
import org.lockss.poller.Poll;
import org.lockss.poller.PollManager;
import org.lockss.poller.PollSpec;
import org.lockss.poller.v3.ParticipantUserData;
import org.lockss.poller.v3.PollerStateBean;
import org.lockss.poller.v3.V3Poller;
import org.lockss.poller.v3.V3Voter;
import org.lockss.poller.v3.VoterUserData;
import org.lockss.protocol.PeerIdentity;
import org.lockss.protocol.psm.PsmInterp;
import org.lockss.protocol.psm.PsmState;
import org.lockss.util.ByteArray;
import org.lockss.util.StringUtil;
import org.lockss.util.UrlUtil;
import org.lockss.util.rest.poller.CachedUriSetSpec;
import org.lockss.util.rest.poller.PollDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class PollsApiServiceImpl
implements PollsApiDelegate {
    private static Logger logger = LoggerFactory.getLogger(PollsApiServiceImpl.class);
    private PollManager pollManager;
    private PluginManager pluginManager;
    private LockssDaemon theDaemon;
    @Autowired
    private HttpServletRequest request;
    private static final String DETAIL_UNAVAILABLE = "Unable to add details link.";

    @Override
    public ResponseEntity<String> callPoll(PollDesc body) {
        CachedUriSetSpec cuSetSpec;
        String auId;
        ArchivalUnit au;
        block7: {
            au = null;
            auId = body.getAuId();
            cuSetSpec = body.getCuSetSpec();
            if (logger.isDebugEnabled()) {
                logger.debug("request to start a poll for au: " + auId);
            }
            try {
                if (!StringUtil.isNullString((String)auId)) {
                    au = this.getPluginManager().getAuFromId(auId);
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block7;
                logger.error("No valid au: " + auId);
            }
        }
        if (au != null) {
            PollSpec ps = this.pollSpecFromDesc(au, cuSetSpec);
            PollManager pm = this.getPollManager();
            try {
                pm.requestPoll(ps);
            }
            catch (PollManager.NotEligibleException e) {
                logger.error(e.getMessage());
                return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.FORBIDDEN);
            }
            return new ResponseEntity((Object)auId, (HttpStatusCode)HttpStatus.ACCEPTED);
        }
        return new ResponseEntity((Object)("No valid au: " + auId), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @Override
    public ResponseEntity<Void> cancelPoll(String psId) {
        block4: {
            if (logger.isDebugEnabled()) {
                logger.debug("request to cancel poll for " + psId);
            }
            PollManager pm = this.getPollManager();
            try {
                ArchivalUnit au = this.getPluginManager().getAuFromId(psId);
                Poll poll = pm.stopPoll(au);
                if (poll != null) {
                    return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug("unable to locate poll with id " + psId);
            }
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @Override
    public ResponseEntity<PollerSummary> getPollStatus(String psId) {
        block4: {
            if (logger.isDebugEnabled()) {
                logger.debug("request poll info for " + psId);
            }
            try {
                PollManager pm;
                Poll poll;
                ArchivalUnit au = this.getPluginManager().getAuFromId(psId);
                if (au != null && (poll = (pm = this.getPollManager()).getPoll(au.getAuId())) != null) {
                    PollerSummary summary = this.summarizePollerPoll(poll);
                    return new ResponseEntity((Object)summary, (HttpStatusCode)HttpStatus.OK);
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug("unable to locate poll with id " + psId);
            }
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @Override
    public ResponseEntity<PollerDetail> getPollerPollDetails(String pollKey) {
        PollManager pm;
        Poll poll;
        if (logger.isDebugEnabled()) {
            logger.debug("request poller details for poll with " + pollKey);
        }
        if ((poll = (pm = this.getPollManager()).getPoll(pollKey)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Details for poll " + pollKey + " not found.");
            }
            return new ResponseEntity((Object)new PollerDetail(), (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        PollerDetail detail = this.detailPoll(poll);
        return new ResponseEntity((Object)detail, (HttpStatusCode)HttpStatus.OK);
    }

    @Override
    public ResponseEntity<VoterDetail> getVoterPollDetails(String pollKey) {
        PollManager pm;
        Poll poll;
        if (logger.isDebugEnabled()) {
            logger.debug("request voter details for poll with " + pollKey);
        }
        if ((poll = (pm = this.getPollManager()).getPoll(pollKey)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Details for poll " + pollKey + " not found.");
            }
            return new ResponseEntity((Object)new VoterDetail(), (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        VoterDetail detail = this.detailVoterPoll(poll);
        return new ResponseEntity((Object)detail, (HttpStatusCode)HttpStatus.OK);
    }

    @Override
    public ResponseEntity<UrlPager> getPollPeerVoteUrls(String pollKey, String peerId, String urls, Integer page, Integer size) {
        ParticipantUserData.VoteCounts voteCounts;
        List participants;
        ParticipantUserData userData;
        PollManager pm = this.getPollManager();
        Poll poll = pm.getPoll(pollKey);
        String baseLink = this.request.getRequestURI();
        if (poll instanceof V3Poller && (userData = this.userDataForPeer(peerId, participants = ((V3Poller)poll).getParticipants())) != null && (voteCounts = userData.getVoteCounts()).hasPeerUrlLists() && userData.hasVoted()) {
            Collection<Object> counts = switch (urls) {
                case "agreed" -> voteCounts.getAgreedUrls();
                case "disagreed" -> voteCounts.getDisagreedUrls();
                case "pollerOnly" -> voteCounts.getPollerOnlyUrls();
                case "voterOnly" -> voteCounts.getVoterOnlyUrls();
                default -> Collections.emptyList();
            };
            if (counts != null) {
                Page<String> strPage = new Page<String>(counts, page, size, baseLink);
                UrlPager pager = this.getUrlPager(strPage);
                return new ResponseEntity((Object)pager, (MultiValueMap)strPage.getPageHeaders(), (HttpStatusCode)HttpStatus.OK);
            }
        }
        return new ResponseEntity((Object)new UrlPager(), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    private UrlPager getUrlPager(Page<String> urlPage) {
        PageDesc desc = this.getPageDesc(urlPage);
        UrlPager pager = new UrlPager();
        pager.setPageDesc(desc);
        pager.setUrls(urlPage.getPageContent());
        return pager;
    }

    @Override
    public ResponseEntity<RepairPager> getRepairQueueData(String pollKey, String repair, Integer page, Integer size) {
        PollManager pm = this.getPollManager();
        Poll poll = pm.getPoll(pollKey);
        String baseLink = this.request.getRequestURI();
        if (poll instanceof V3Poller) {
            PollerStateBean.RepairQueue repairQueue = ((V3Poller)poll).getPollerStateBean().getRepairQueue();
            ArrayList repairList = switch (repair) {
                case "active" -> repairQueue.getActiveRepairs();
                case "pending" -> repairQueue.getPendingRepairs();
                case "completed" -> repairQueue.getCompletedRepairs();
                default -> new ArrayList();
            };
            if (repairList != null) {
                Page rpage = new Page(repairList, page, size, baseLink);
                PageDesc desc = this.getPageDesc(rpage);
                RepairPager pager = new RepairPager();
                pager.setPageDesc(desc);
                if (rpage.hasContent()) {
                    List rlist = rpage.getPageContent();
                    for (PollerStateBean.Repair rep : rlist) {
                        RepairData rdata = new RepairData();
                        rdata.setRepairUrl(rep.getUrl());
                        rdata.setRepairFrom(rep.getRepairFrom().getIdString());
                        if ("completed".equals(repair)) {
                            rdata.setResult(RepairData.ResultEnum.fromValue(rep.getTallyResult().toString()));
                        }
                        pager.addRepairsItem(rdata);
                    }
                }
                return new ResponseEntity((Object)pager, (MultiValueMap)rpage.getPageHeaders(), (HttpStatusCode)HttpStatus.OK);
            }
        }
        return new ResponseEntity((Object)new RepairPager(), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @Override
    public ResponseEntity<UrlPager> getTallyUrls(String pollKey, String tally, Integer page, Integer size) {
        PollManager pm = this.getPollManager();
        Poll poll = pm.getPoll(pollKey);
        String baseLink = this.request.getRequestURI();
        if (poll instanceof V3Poller) {
            PollerStateBean.TallyStatus tallyStatus = ((V3Poller)poll).getPollerStateBean().getTallyStatus();
            Set tallySet = switch (tally) {
                case "agree" -> tallyStatus.getAgreedUrls();
                case "disagree" -> tallyStatus.getDisagreedUrls();
                case "error" -> tallyStatus.getErrorUrls().keySet();
                case "noQuorum" -> tallyStatus.getNoQuorumUrls();
                case "tooClose" -> tallyStatus.getTooCloseUrls();
                default -> new HashSet();
            };
            if (tallySet != null) {
                Page<String> strPage = new Page<String>(tallySet, page, size, baseLink);
                UrlPager pager = this.getUrlPager(strPage);
                return new ResponseEntity((Object)pager, (MultiValueMap)strPage.getPageHeaders(), (HttpStatusCode)HttpStatus.OK);
            }
        }
        return new ResponseEntity((Object)new UrlPager(), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @Override
    public ResponseEntity<PollerPager> getPollsAsPoller(Integer size, Integer page) {
        if (logger.isDebugEnabled()) {
            logger.debug("request for  a page " + page + " of voter polls with page size " + size);
        }
        PollManager pm = this.getPollManager();
        Collection pollers = pm.getV3Pollers();
        String baseLink = this.request.getRequestURI();
        Page pollerPage = new Page(pollers, size, page, baseLink);
        PollerPager pager = new PollerPager();
        PageDesc desc = this.getPageDesc(pollerPage);
        pager.setPageDesc(desc);
        if (pollerPage.hasContent()) {
            List pollerList = pollerPage.getPageContent();
            for (V3Poller poll : pollerList) {
                pager.addPollsItem(this.summarizePollerPoll((Poll)poll));
            }
        }
        return new ResponseEntity((Object)pager, (MultiValueMap)pollerPage.getPageHeaders(), (HttpStatusCode)HttpStatus.OK);
    }

    @Override
    public ResponseEntity<VoterPager> getPollsAsVoter(Integer size, Integer page) {
        if (logger.isDebugEnabled()) {
            logger.debug("request for  a page " + page + " of voter polls with page size " + size);
        }
        PollManager pm = this.getPollManager();
        Collection voters = pm.getV3Voters();
        String baseLink = this.request.getRequestURI();
        Page voterPage = new Page(voters, size, page, baseLink);
        VoterPager pager = new VoterPager();
        PageDesc desc = new PageDesc();
        desc.setTotal(voterPage.getTotal());
        desc.setSize(voterPage.getPageSize());
        desc.setPage(voterPage.getPageNum());
        desc.setNextPage(voterPage.getNextLink());
        desc.setPrevPage(voterPage.getPrevLink());
        pager.setPageDesc(desc);
        if (voterPage.hasContent()) {
            List pollerList = voterPage.getPageContent();
            for (V3Voter poll : pollerList) {
                pager.addPollsItem(this.summarizeVoterPoll((Poll)poll));
            }
        }
        return new ResponseEntity((Object)pager, (HttpStatusCode)HttpStatus.OK);
    }

    private PollSpec pollSpecFromDesc(ArchivalUnit au, CachedUriSetSpec spec) {
        if (spec == null) {
            CachedUrlSet cus = au.getAuCachedUrlSet();
            return new PollSpec(cus, 3);
        }
        return new PollSpec(au.getAuId(), spec.getUrlPrefix(), spec.getLowerBound(), spec.getUpperBound(), 3);
    }

    private PollDesc pollDescFromSpec(PollSpec pollSpec) {
        PollDesc pollDesc = new PollDesc();
        pollDesc.setAuId(pollSpec.getAuId());
        CachedUriSetSpec cuss = new CachedUriSetSpec();
        cuss.setUrlPrefix(pollSpec.getUrl());
        cuss.setUpperBound(pollSpec.getUprBound());
        cuss.setLowerBound(pollSpec.getLwrBound());
        pollDesc.setCuSetSpec(cuss);
        pollDesc.setPollType(Integer.valueOf(pollSpec.getPollType()));
        pollDesc.setProtocol(Integer.valueOf(pollSpec.getProtocolVersion()));
        pollDesc.setVariant(PollDesc.VariantEnum.fromValue((String)pollSpec.getPollVariant().shortName()));
        return pollDesc;
    }

    private PollerSummary summarizePollerPoll(Poll inPoll) {
        PollerSummary summary = new PollerSummary();
        if (inPoll instanceof V3Poller) {
            V3Poller v3poller = (V3Poller)inPoll;
            PollerStateBean psb = v3poller.getPollerStateBean();
            summary.setPollKey(v3poller.getKey());
            summary.setAuId(v3poller.getAu().getAuId());
            summary.setStatus(V3Poller.POLLER_STATUS_STRINGS[v3poller.getStatus()]);
            summary.setStart(v3poller.getCreateTime());
            summary.setVariant(v3poller.getPollVariant().shortName());
            summary.setDeadline(v3poller.getDuration());
            summary.setPollEnd(psb.getPollEnd());
            summary.setParticipants(v3poller.getParticipants().size());
            PollerStateBean.TallyStatus ts = psb.getTallyStatus();
            if (ts != null) {
                summary.setNumTalliedUrls(ts.getTalliedUrlCount());
                summary.setNumAgreeUrls(ts.getAgreedUrlCount());
                summary.setNumHashErrors(ts.getErrorUrlCount());
            }
            summary.setNumCompletedRepairs(v3poller.getCompletedRepairs().size());
            summary.setDetailLink(this.makeDetailLink("poller/" + psb.getPollKey()));
        }
        return summary;
    }

    private VoterSummary summarizeVoterPoll(Poll inPoll) {
        VoterSummary summary = new VoterSummary();
        if (inPoll instanceof V3Voter) {
            V3Voter v3Voter = (V3Voter)inPoll;
            VoterUserData userData = v3Voter.getVoterUserData();
            summary.setAuId(v3Voter.getAu().getAuId());
            summary.setCaller(v3Voter.getPollerId().getIdString());
            summary.setDeadline(v3Voter.getDeadline().getExpirationTime());
            summary.setPollKey(v3Voter.getKey());
            summary.setStart(v3Voter.getCreateTime());
            summary.setStatus(v3Voter.getStatusString());
            summary.setDetailLink(this.makeDetailLink("voter/" + userData.getPollKey()));
        }
        return summary;
    }

    private PollerDetail detailPoll(Poll poll) {
        PollerDetail detail = new PollerDetail();
        if (poll instanceof V3Poller) {
            V3Poller v3poller = (V3Poller)poll;
            PollerStateBean psb = v3poller.getPollerStateBean();
            PollDesc desc = this.pollDescFromSpec(poll.getPollSpec());
            desc.setModulus(Integer.valueOf(psb.getModulus()));
            detail.setPollDesc(desc);
            detail.setPollerId(psb.getPollerId().getIdString());
            detail.setStatus(V3Poller.POLLER_STATUS_STRINGS[psb.getStatus()]);
            detail.setPollKey(psb.getPollKey());
            detail.setCreateTime(psb.getCreateTime());
            detail.setDuration(psb.getDuration());
            detail.setDeadline(psb.getPollDeadline());
            detail.setOuterCircleTarget(psb.getOuterCircleTarget());
            detail.setHashAlgorithm(psb.getHashAlgorithm());
            detail.setVoteMargin(psb.getVoteMargin());
            detail.setVoteDeadline(psb.getVoteDeadline());
            detail.setPollEnd(psb.getPollEnd());
            detail.setQuorum(psb.getQuorum());
            detail.setErrorDetails(psb.getErrorDetail());
            detail.setVoteDuration(psb.getVoteDuration());
            for (PeerIdentity peerId : psb.getNoAuPeers()) {
                detail.addNoAuPeersItem(peerId.getIdString());
            }
            for (ParticipantUserData participantData : v3poller.getParticipants()) {
                detail.addVotedPeersItem(this.peerDataFromParticipantData(participantData, psb.getPollKey()));
            }
            TallyData tallyData = this.tallyDataFromTallyStatus(psb.getTallyStatus(), psb.getPollKey());
            detail.setTally(tallyData);
            RepairQueue repairQueue = this.repairQueueFromDataRepairQueue(psb.getRepairQueue(), psb.getPollKey());
            detail.setRepairQueue(repairQueue);
        }
        return detail;
    }

    private PageDesc getPageDesc(Page page) {
        PageDesc desc = new PageDesc();
        desc.setTotal(page.getTotal());
        desc.setSize(page.getPageSize());
        desc.setPage(page.getPageNum());
        desc.setNextPage(page.getNextLink());
        desc.setPrevPage(page.getPrevLink());
        return desc;
    }

    private VoterDetail detailVoterPoll(Poll poll) {
        VoterDetail detail = new VoterDetail();
        if (poll instanceof V3Voter) {
            V3Voter v3voter = (V3Voter)poll;
            PollDesc desc = this.pollDescFromSpec(v3voter.getPollSpec());
            VoterUserData vud = v3voter.getVoterUserData();
            desc.setModulus(Integer.valueOf(vud.getModulus()));
            detail.setPollDesc(desc);
            detail.setPollerId(v3voter.getPollerId().getIdString());
            detail.setCallerId(v3voter.getCallerID().getIdString());
            detail.setStatus(vud.getStatusString());
            detail.setPollKey(vud.getPollKey());
            detail.setCreateTime(vud.getCreateTime());
            detail.setDuration(vud.getDuration());
            detail.setDeadline(vud.getDeadline());
            detail.setHashAlgorithm(vud.getHashAlgorithm());
            detail.setVoteDeadline(vud.getVoteDeadline());
            detail.setErrorDetails(vud.getErrorDetail());
            if (v3voter.getStatus() == 5) {
                if (vud.hasReceivedHint()) {
                    detail.setAgreement(vud.getAgreementHint());
                }
                if (vud.hasReceivedWeightedHint()) {
                    detail.setWtAgreement(vud.getWeightedAgreementHint());
                }
                if (vud.hasReceivedSymmetricAgreement()) {
                    detail.setSymmetricAgreement(vud.getSymmetricAgreement());
                }
                if (vud.hasReceivedSymmetricWeightedAgreement()) {
                    detail.setWtSymmetricAgreement(vud.getSymmetricAgreement());
                }
            }
            detail.setPollerNonce(ByteArray.toBase64((byte[])vud.getPollerNonce()));
            detail.setVoterNonce(ByteArray.toBase64((byte[])vud.getVoterNonce()));
            if (vud.isSymmetricPoll()) {
                detail.setVoter2Nonce(ByteArray.toBase64((byte[])vud.getVoterNonce2()));
                if (v3voter.getStatus() == 5) {
                    detail.setNumAgree(vud.getNumAgreeUrl());
                    detail.setNumDisagree(vud.getNumDisagreeUrl());
                    detail.setNumPollerOnly(vud.getNumPollerOnlyUrl());
                    detail.setNumVoterOnly(vud.getNumVoterOnlyUrl());
                }
            }
        }
        return detail;
    }

    private PeerData peerDataFromParticipantData(ParticipantUserData voter, String pollKey) {
        PsmState state;
        PeerData peerData = new PeerData();
        peerData.setPeerId(voter.getVoterId().getIdString());
        peerData.setStatus(voter.getStatusString());
        peerData.setAgreement(Float.valueOf(voter.getPercentAgreement()));
        ParticipantUserData.VoteCounts voteCounts = voter.getVoteCounts();
        peerData.setNumAgree(voteCounts.getAgreedVotes());
        peerData.setNumDisagree(voteCounts.getDisagreedVotes());
        peerData.setNumPollerOnly(voteCounts.getPollerOnlyVotes());
        peerData.setNumVoterOnly(voteCounts.getVoterOnlyVotes());
        peerData.setBytesHashed(voter.getBytesHashed());
        peerData.setBytesRead(voter.getBytesRead());
        peerData.setWtAgreement(Float.valueOf(voteCounts.getWeightedPercentAgreement()));
        peerData.setWtNumDisagree(Float.valueOf(voteCounts.getWeightedDisagreedVotes()));
        peerData.setWtNumPollerOnly(Float.valueOf(voteCounts.getWeightedPollerOnlyVotes()));
        peerData.setWtNumVoterOnly(Float.valueOf(voteCounts.getWeightedVoterOnlyVotes()));
        PsmInterp interp = voter.getPsmInterp();
        if (interp != null && (state = interp.getCurrentState()) != null) {
            peerData.setState(state.getName());
            long when = interp.getLastStateChange();
            if (when > 0L) {
                peerData.setLastStateChange(when);
            }
        }
        String peerId = peerData.getPeerId();
        peerData.setAgreeLink(this.makePeerLink(pollKey, peerId, "agree"));
        peerData.setDisagreeLink(this.makePeerLink(pollKey, peerId, "disagree"));
        peerData.setPollerOnlyLink(this.makePeerLink(pollKey, peerId, "pollerOnly"));
        peerData.setVoterOnlyLink(this.makePeerLink(pollKey, peerId, "voterOnly"));
        return peerData;
    }

    private RepairQueue repairQueueFromDataRepairQueue(PollerStateBean.RepairQueue inQueue, String pollKey) {
        RepairQueue outQueue = new RepairQueue();
        outQueue.setNumActive(inQueue.getActiveRepairs().size());
        outQueue.setNumPending(inQueue.getPendingRepairs().size());
        outQueue.setNumCompleted(inQueue.getCompletedRepairs().size());
        outQueue.setActiveLink(this.makeRepairQLink(pollKey, "active"));
        outQueue.setCompletedLink(this.makeRepairQLink(pollKey, "completed"));
        outQueue.setPendingLink(this.makeRepairQLink(pollKey, "pending"));
        return outQueue;
    }

    private TallyData tallyDataFromTallyStatus(PollerStateBean.TallyStatus tallyStatus, String pollKey) {
        TallyData tallyData = new TallyData();
        tallyData.setNumAgree(tallyStatus.getAgreedUrlCount());
        tallyData.setNumDisagree(tallyStatus.getDisgreedUrlCount());
        tallyData.setNumNoQuorum(tallyStatus.getNoQuorumUrlCount());
        tallyData.setNumTooClose(tallyStatus.getTooCloseUrlCount());
        tallyData.setNumError(tallyStatus.getErrorUrlCount());
        tallyData.setWtAgreed(Float.valueOf(tallyStatus.getWeightedAgreedCount()));
        tallyData.setWtDisagreed(Float.valueOf(tallyStatus.getWeightedDisagreedCount()));
        tallyData.setWtNoQuorum(Float.valueOf(tallyStatus.getWeightedNoQuorumCount()));
        tallyData.setWtTooClose(Float.valueOf(tallyStatus.getWeightedTooCloseCount()));
        tallyData.setAgreeLink(this.makeTallyLink(pollKey, "agree"));
        tallyData.setDisagreeLink(this.makeTallyLink(pollKey, "disagree"));
        tallyData.setNoQuorumLink(this.makeTallyLink(pollKey, "noQuorum"));
        tallyData.setTooCloseLink(this.makeTallyLink(pollKey, "tooClose"));
        tallyData.setErrorLink(this.makeTallyLink(pollKey, "error"));
        return tallyData;
    }

    private LinkDesc makeDetailLink(String pollKey) {
        try {
            String prefix = UrlUtil.getUrlPrefix((String)this.request.getRequestURI());
            LinkDesc ldesc = new LinkDesc();
            ldesc.setLink(prefix + "/polls/" + pollKey + "/details");
            return ldesc;
        }
        catch (MalformedURLException e) {
            logger.error(DETAIL_UNAVAILABLE);
            return null;
        }
    }

    private LinkDesc makeTallyLink(String pollKey, String tallyType) {
        try {
            String prefix = UrlUtil.getUrlPrefix((String)this.request.getRequestURI());
            LinkDesc ldesc = new LinkDesc();
            ldesc.setLink(prefix + "/polls/" + pollKey + "/tally?tally=" + tallyType);
            return ldesc;
        }
        catch (MalformedURLException e) {
            logger.error(DETAIL_UNAVAILABLE);
            return null;
        }
    }

    private LinkDesc makeRepairQLink(String pollKey, String repairType) {
        try {
            String prefix = UrlUtil.getUrlPrefix((String)this.request.getRequestURI());
            LinkDesc ldesc = new LinkDesc();
            ldesc.setLink(prefix + "/polls/" + pollKey + "/repairs?repair=" + repairType);
            return ldesc;
        }
        catch (MalformedURLException e) {
            logger.error(DETAIL_UNAVAILABLE);
            return null;
        }
    }

    private LinkDesc makePeerLink(String pollKey, String peerId, String tallyType) {
        try {
            String prefix = UrlUtil.getUrlPrefix((String)this.request.getRequestURI());
            LinkDesc ldesc = new LinkDesc();
            ldesc.setLink(prefix + "/polls/" + pollKey + "/peer/" + peerId + "?tally=" + tallyType);
            return ldesc;
        }
        catch (MalformedURLException e) {
            logger.error(DETAIL_UNAVAILABLE);
            return null;
        }
    }

    private ParticipantUserData userDataForPeer(String peerId, List<ParticipantUserData> participants) {
        if (peerId == null || participants == null || participants.isEmpty()) {
            return null;
        }
        for (ParticipantUserData userData : participants) {
            if (!userData.getVoterId().getIdString().equals(peerId)) continue;
            return userData;
        }
        return null;
    }

    LockssDaemon getLockssDaemon() {
        if (this.theDaemon == null) {
            this.theDaemon = LockssDaemon.getLockssDaemon();
        }
        return this.theDaemon;
    }

    PollManager getPollManager() {
        if (this.pollManager == null) {
            this.pollManager = this.getLockssDaemon().getPollManager();
        }
        return this.pollManager;
    }

    PluginManager getPluginManager() {
        if (this.pluginManager == null) {
            this.pluginManager = this.getLockssDaemon().getPluginManager();
        }
        return this.pluginManager;
    }
}

