/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.lockss.laaws.poller.model.LinkDesc;
import org.springframework.validation.annotation.Validated;

@Schema(description="Detail for a single voter in a poll.")
@Validated
public class PeerData {
    @JsonProperty(value="peerId")
    private String peerId = null;
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="agreement")
    private Float agreement = null;
    @JsonProperty(value="numAgree")
    private Long numAgree = null;
    @JsonProperty(value="agreeLink")
    private LinkDesc agreeLink = null;
    @JsonProperty(value="numDisagree")
    private Long numDisagree = null;
    @JsonProperty(value="disagreeLink")
    private LinkDesc disagreeLink = null;
    @JsonProperty(value="numPollerOnly")
    private Long numPollerOnly = null;
    @JsonProperty(value="pollerOnlyLink")
    private LinkDesc pollerOnlyLink = null;
    @JsonProperty(value="numVoterOnly")
    private Long numVoterOnly = null;
    @JsonProperty(value="voterOnlyLink")
    private LinkDesc voterOnlyLink = null;
    @JsonProperty(value="bytesHashed")
    private Long bytesHashed = null;
    @JsonProperty(value="bytesRead")
    private Long bytesRead = null;
    @JsonProperty(value="wtAgreement")
    private Float wtAgreement = null;
    @JsonProperty(value="wtNumAgree")
    private Float wtNumAgree = null;
    @JsonProperty(value="wtNumDisagree")
    private Float wtNumDisagree = null;
    @JsonProperty(value="wtNumPollerOnly")
    private Float wtNumPollerOnly = null;
    @JsonProperty(value="wtNumVoterOnly")
    private Float wtNumVoterOnly = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="lastStateChange")
    private Long lastStateChange = null;

    public PeerData peerId(String peerId) {
        this.peerId = peerId;
        return this;
    }

    @Schema(required=true, description="the peer id for this participant")
    @NotNull
    public String getPeerId() {
        return this.peerId;
    }

    public void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    public PeerData status(String status) {
        this.status = status;
        return this;
    }

    @Schema(required=true, description="the status of this peer")
    @NotNull
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public PeerData agreement(Float agreement) {
        this.agreement = agreement;
        return this;
    }

    @Schema(description="the percentage of vote agreement.")
    public Float getAgreement() {
        return this.agreement;
    }

    public void setAgreement(Float agreement) {
        this.agreement = agreement;
    }

    public PeerData numAgree(Long numAgree) {
        this.numAgree = numAgree;
        return this;
    }

    @Schema(description="The number of urls for which there was agreement.")
    public Long getNumAgree() {
        return this.numAgree;
    }

    public void setNumAgree(Long numAgree) {
        this.numAgree = numAgree;
    }

    public PeerData agreeLink(LinkDesc agreeLink) {
        this.agreeLink = agreeLink;
        return this;
    }

    @Schema(description="")
    @Valid
    public LinkDesc getAgreeLink() {
        return this.agreeLink;
    }

    public void setAgreeLink(LinkDesc agreeLink) {
        this.agreeLink = agreeLink;
    }

    public PeerData numDisagree(Long numDisagree) {
        this.numDisagree = numDisagree;
        return this;
    }

    @Schema(description="The number of urls for which there was disagreement.")
    public Long getNumDisagree() {
        return this.numDisagree;
    }

    public void setNumDisagree(Long numDisagree) {
        this.numDisagree = numDisagree;
    }

    public PeerData disagreeLink(LinkDesc disagreeLink) {
        this.disagreeLink = disagreeLink;
        return this;
    }

    @Schema(description="")
    @Valid
    public LinkDesc getDisagreeLink() {
        return this.disagreeLink;
    }

    public void setDisagreeLink(LinkDesc disagreeLink) {
        this.disagreeLink = disagreeLink;
    }

    public PeerData numPollerOnly(Long numPollerOnly) {
        this.numPollerOnly = numPollerOnly;
        return this;
    }

    @Schema(description="The number of urls which were poller only.")
    public Long getNumPollerOnly() {
        return this.numPollerOnly;
    }

    public void setNumPollerOnly(Long numPollerOnly) {
        this.numPollerOnly = numPollerOnly;
    }

    public PeerData pollerOnlyLink(LinkDesc pollerOnlyLink) {
        this.pollerOnlyLink = pollerOnlyLink;
        return this;
    }

    @Schema(description="")
    @Valid
    public LinkDesc getPollerOnlyLink() {
        return this.pollerOnlyLink;
    }

    public void setPollerOnlyLink(LinkDesc pollerOnlyLink) {
        this.pollerOnlyLink = pollerOnlyLink;
    }

    public PeerData numVoterOnly(Long numVoterOnly) {
        this.numVoterOnly = numVoterOnly;
        return this;
    }

    @Schema(description="The number of urls for which were voter only.")
    public Long getNumVoterOnly() {
        return this.numVoterOnly;
    }

    public void setNumVoterOnly(Long numVoterOnly) {
        this.numVoterOnly = numVoterOnly;
    }

    public PeerData voterOnlyLink(LinkDesc voterOnlyLink) {
        this.voterOnlyLink = voterOnlyLink;
        return this;
    }

    @Schema(description="")
    @Valid
    public LinkDesc getVoterOnlyLink() {
        return this.voterOnlyLink;
    }

    public void setVoterOnlyLink(LinkDesc voterOnlyLink) {
        this.voterOnlyLink = voterOnlyLink;
    }

    public PeerData bytesHashed(Long bytesHashed) {
        this.bytesHashed = bytesHashed;
        return this;
    }

    @Schema(description="the number of bytes hashed.")
    public Long getBytesHashed() {
        return this.bytesHashed;
    }

    public void setBytesHashed(Long bytesHashed) {
        this.bytesHashed = bytesHashed;
    }

    public PeerData bytesRead(Long bytesRead) {
        this.bytesRead = bytesRead;
        return this;
    }

    @Schema(description="the number of bytes read.")
    public Long getBytesRead() {
        return this.bytesRead;
    }

    public void setBytesRead(Long bytesRead) {
        this.bytesRead = bytesRead;
    }

    public PeerData wtAgreement(Float wtAgreement) {
        this.wtAgreement = wtAgreement;
        return this;
    }

    @Schema(description="the weight of vote percentage agreement.")
    public Float getWtAgreement() {
        return this.wtAgreement;
    }

    public void setWtAgreement(Float wtAgreement) {
        this.wtAgreement = wtAgreement;
    }

    public PeerData wtNumAgree(Float wtNumAgree) {
        this.wtNumAgree = wtNumAgree;
        return this;
    }

    @Schema(description="the weight of number agree votes.")
    public Float getWtNumAgree() {
        return this.wtNumAgree;
    }

    public void setWtNumAgree(Float wtNumAgree) {
        this.wtNumAgree = wtNumAgree;
    }

    public PeerData wtNumDisagree(Float wtNumDisagree) {
        this.wtNumDisagree = wtNumDisagree;
        return this;
    }

    @Schema(description="the weight of number of disagree votes.")
    public Float getWtNumDisagree() {
        return this.wtNumDisagree;
    }

    public void setWtNumDisagree(Float wtNumDisagree) {
        this.wtNumDisagree = wtNumDisagree;
    }

    public PeerData wtNumPollerOnly(Float wtNumPollerOnly) {
        this.wtNumPollerOnly = wtNumPollerOnly;
        return this;
    }

    @Schema(description="the weight of number of poller only votes.")
    public Float getWtNumPollerOnly() {
        return this.wtNumPollerOnly;
    }

    public void setWtNumPollerOnly(Float wtNumPollerOnly) {
        this.wtNumPollerOnly = wtNumPollerOnly;
    }

    public PeerData wtNumVoterOnly(Float wtNumVoterOnly) {
        this.wtNumVoterOnly = wtNumVoterOnly;
        return this;
    }

    @Schema(description="the weight of number of voter only votes.")
    public Float getWtNumVoterOnly() {
        return this.wtNumVoterOnly;
    }

    public void setWtNumVoterOnly(Float wtNumVoterOnly) {
        this.wtNumVoterOnly = wtNumVoterOnly;
    }

    public PeerData state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="the state machine state.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public PeerData lastStateChange(Long lastStateChange) {
        this.lastStateChange = lastStateChange;
        return this;
    }

    @Schema(description="the time of last state change.")
    public Long getLastStateChange() {
        return this.lastStateChange;
    }

    public void setLastStateChange(Long lastStateChange) {
        this.lastStateChange = lastStateChange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeerData peerData = (PeerData)o;
        return Objects.equals(this.peerId, peerData.peerId) && Objects.equals(this.status, peerData.status) && Objects.equals(this.agreement, peerData.agreement) && Objects.equals(this.numAgree, peerData.numAgree) && Objects.equals(this.agreeLink, peerData.agreeLink) && Objects.equals(this.numDisagree, peerData.numDisagree) && Objects.equals(this.disagreeLink, peerData.disagreeLink) && Objects.equals(this.numPollerOnly, peerData.numPollerOnly) && Objects.equals(this.pollerOnlyLink, peerData.pollerOnlyLink) && Objects.equals(this.numVoterOnly, peerData.numVoterOnly) && Objects.equals(this.voterOnlyLink, peerData.voterOnlyLink) && Objects.equals(this.bytesHashed, peerData.bytesHashed) && Objects.equals(this.bytesRead, peerData.bytesRead) && Objects.equals(this.wtAgreement, peerData.wtAgreement) && Objects.equals(this.wtNumAgree, peerData.wtNumAgree) && Objects.equals(this.wtNumDisagree, peerData.wtNumDisagree) && Objects.equals(this.wtNumPollerOnly, peerData.wtNumPollerOnly) && Objects.equals(this.wtNumVoterOnly, peerData.wtNumVoterOnly) && Objects.equals(this.state, peerData.state) && Objects.equals(this.lastStateChange, peerData.lastStateChange);
    }

    public int hashCode() {
        return Objects.hash(this.peerId, this.status, this.agreement, this.numAgree, this.agreeLink, this.numDisagree, this.disagreeLink, this.numPollerOnly, this.pollerOnlyLink, this.numVoterOnly, this.voterOnlyLink, this.bytesHashed, this.bytesRead, this.wtAgreement, this.wtNumAgree, this.wtNumDisagree, this.wtNumPollerOnly, this.wtNumVoterOnly, this.state, this.lastStateChange);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PeerData {\n");
        sb.append("    peerId: ").append(this.toIndentedString(this.peerId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    agreement: ").append(this.toIndentedString(this.agreement)).append("\n");
        sb.append("    numAgree: ").append(this.toIndentedString(this.numAgree)).append("\n");
        sb.append("    agreeLink: ").append(this.toIndentedString(this.agreeLink)).append("\n");
        sb.append("    numDisagree: ").append(this.toIndentedString(this.numDisagree)).append("\n");
        sb.append("    disagreeLink: ").append(this.toIndentedString(this.disagreeLink)).append("\n");
        sb.append("    numPollerOnly: ").append(this.toIndentedString(this.numPollerOnly)).append("\n");
        sb.append("    pollerOnlyLink: ").append(this.toIndentedString(this.pollerOnlyLink)).append("\n");
        sb.append("    numVoterOnly: ").append(this.toIndentedString(this.numVoterOnly)).append("\n");
        sb.append("    voterOnlyLink: ").append(this.toIndentedString(this.voterOnlyLink)).append("\n");
        sb.append("    bytesHashed: ").append(this.toIndentedString(this.bytesHashed)).append("\n");
        sb.append("    bytesRead: ").append(this.toIndentedString(this.bytesRead)).append("\n");
        sb.append("    wtAgreement: ").append(this.toIndentedString(this.wtAgreement)).append("\n");
        sb.append("    wtNumAgree: ").append(this.toIndentedString(this.wtNumAgree)).append("\n");
        sb.append("    wtNumDisagree: ").append(this.toIndentedString(this.wtNumDisagree)).append("\n");
        sb.append("    wtNumPollerOnly: ").append(this.toIndentedString(this.wtNumPollerOnly)).append("\n");
        sb.append("    wtNumVoterOnly: ").append(this.toIndentedString(this.wtNumVoterOnly)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    lastStateChange: ").append(this.toIndentedString(this.lastStateChange)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

