/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.lockss.laaws.poller.model.PageDesc;
import org.springframework.validation.annotation.Validated;

@Schema(description="A Pager for a list of urls found in poll details.")
@Validated
public class UrlPager {
    @JsonProperty(value="pageDesc")
    private PageDesc pageDesc = null;
    @JsonProperty(value="urls")
    @Valid
    private List<String> urls = null;

    public UrlPager pageDesc(PageDesc pageDesc) {
        this.pageDesc = pageDesc;
        return this;
    }

    @Schema(required=true, description="")
    @NotNull
    @Valid
    public PageDesc getPageDesc() {
        return this.pageDesc;
    }

    public void setPageDesc(PageDesc pageDesc) {
        this.pageDesc = pageDesc;
    }

    public UrlPager urls(List<String> urls) {
        this.urls = urls;
        return this;
    }

    public UrlPager addUrlsItem(String urlsItem) {
        if (this.urls == null) {
            this.urls = new ArrayList<String>();
        }
        this.urls.add(urlsItem);
        return this;
    }

    @Schema(description="The urls on this page.")
    public List<String> getUrls() {
        return this.urls;
    }

    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlPager urlPager = (UrlPager)o;
        return Objects.equals(this.pageDesc, urlPager.pageDesc) && Objects.equals(this.urls, urlPager.urls);
    }

    public int hashCode() {
        return Objects.hash(this.pageDesc, this.urls);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UrlPager {\n");
        sb.append("    pageDesc: ").append(this.toIndentedString(this.pageDesc)).append("\n");
        sb.append("    urls: ").append(this.toIndentedString(this.urls)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

