package org.lockss.laaws.poller.api;

import org.lockss.laaws.poller.model.ErrorResult;
import org.lockss.util.rest.poller.PollDesc;
import org.lockss.laaws.poller.model.PollerDetail;
import org.lockss.laaws.poller.model.PollerPager;
import org.lockss.laaws.poller.model.PollerSummary;
import org.lockss.laaws.poller.model.RepairPager;
import org.lockss.laaws.poller.model.UrlPager;
import org.lockss.laaws.poller.model.VoterDetail;
import org.lockss.laaws.poller.model.VoterPager;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.multipart.MultipartFile;
import java.io.IOException;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * A delegate to be called by the {@link PollsApiController}}.
 * Implement this interface with a {@link org.springframework.stereotype.Service} annotated class.
 */

public interface PollsApiDelegate {

    Logger log = LoggerFactory.getLogger(PollsApi.class);

    default Optional<ObjectMapper> getObjectMapper(){
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest(){
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    /**
     * @see PollsApi#callPoll
     */
    default ResponseEntity<String> callPoll( PollDesc  body) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("\"\"", String.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PollsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see PollsApi#cancelPoll
     */
    default ResponseEntity<Void> cancelPoll( String  psId) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PollsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see PollsApi#getPollPeerVoteUrls
     */
    default ResponseEntity<UrlPager> getPollPeerVoteUrls( String  pollKey,
         String  peerId,
         String  urls,
         Integer  page,
         Integer  size) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"pageDesc\" : {\n    \"total\" : 150,\n    \"size\" : 5,\n    \"nextPage\" : \"nextPage\",\n    \"prevPage\" : \"prevPage\",\n    \"page\" : 10\n  },\n  \"urls\" : [ \"urls\", \"urls\" ]\n}", UrlPager.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PollsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see PollsApi#getPollStatus
     */
    default ResponseEntity<PollerSummary> getPollStatus( String  psId) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"numCompletedRepairs\" : 5,\n  \"auId\" : \"auId\",\n  \"numHashErrors\" : 1,\n  \"numTalliedUrls\" : 6,\n  \"start\" : 2,\n  \"pollKey\" : \"pollKey\",\n  \"variant\" : \"variant\",\n  \"numAgreeUrls\" : 5,\n  \"pollEnd\" : 9,\n  \"deadline\" : 7,\n  \"detailLink\" : {\n    \"link\" : \"http:www.example.com/v1/element\",\n    \"desc\" : \"pollerOnly\"\n  },\n  \"status\" : \"status\",\n  \"participants\" : 0\n}", PollerSummary.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PollsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see PollsApi#getPollerPollDetails
     */
    default ResponseEntity<PollerDetail> getPollerPollDetails( String  pollKey) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"noAuPeers\" : [ \"noAuPeers\", \"noAuPeers\" ],\n  \"pollerId\" : \"pollerId\",\n  \"pollDesc\" : {\n    \"auId\" : \"auId\",\n    \"cuSetSpec\" : {\n      \"upperBound\" : \"upperBound\",\n      \"urlPrefix\" : \"urlPrefix\",\n      \"lowerBound\" : \"lowerBound\"\n    },\n    \"protocol\" : 6,\n    \"pollType\" : 3,\n    \"variant\" : \"PoR\",\n    \"pluginPollVersion\" : \"pluginPollVersion\",\n    \"modulus\" : 1\n  },\n  \"quorum\" : 7,\n  \"pollKey\" : \"pollKey\",\n  \"votedPeers\" : [ {\n    \"peerId\" : \"peerId\",\n    \"lastStateChange\" : 9,\n    \"agreement\" : 1.2315135,\n    \"bytesRead\" : 4,\n    \"bytesHashed\" : 1,\n    \"wtNumDisagree\" : 9.36931,\n    \"wtNumVoterOnly\" : 8.762042,\n    \"numVoterOnly\" : 7,\n    \"numAgree\" : 1,\n    \"state\" : \"state\",\n    \"agreeLink\" : {\n      \"link\" : \"http:www.example.com/v1/element\",\n      \"desc\" : \"pollerOnly\"\n    },\n    \"numPollerOnly\" : 6,\n    \"wtAgreement\" : 5.025005,\n    \"wtNumAgree\" : 9.965781,\n    \"wtNumPollerOnly\" : 6.6835623,\n    \"status\" : \"status\",\n    \"numDisagree\" : 1\n  }, {\n    \"peerId\" : \"peerId\",\n    \"lastStateChange\" : 9,\n    \"agreement\" : 1.2315135,\n    \"bytesRead\" : 4,\n    \"bytesHashed\" : 1,\n    \"wtNumDisagree\" : 9.36931,\n    \"wtNumVoterOnly\" : 8.762042,\n    \"numVoterOnly\" : 7,\n    \"numAgree\" : 1,\n    \"state\" : \"state\",\n    \"agreeLink\" : {\n      \"link\" : \"http:www.example.com/v1/element\",\n      \"desc\" : \"pollerOnly\"\n    },\n    \"numPollerOnly\" : 6,\n    \"wtAgreement\" : 5.025005,\n    \"wtNumAgree\" : 9.965781,\n    \"wtNumPollerOnly\" : 6.6835623,\n    \"status\" : \"status\",\n    \"numDisagree\" : 1\n  } ],\n  \"voteMargin\" : 9,\n  \"voteDuration\" : 2,\n  \"duration\" : 5,\n  \"voteDeadline\" : 3,\n  \"repairQueue\" : {\n    \"numActive\" : 3,\n    \"numCompleted\" : 7,\n    \"numPending\" : 3\n  },\n  \"createTime\" : 5,\n  \"outerCircleTarget\" : 7,\n  \"pollEnd\" : 4,\n  \"deadline\" : 2,\n  \"tally\" : {\n    \"numNoQuorum\" : 1,\n    \"wtTooClose\" : 5.9448957,\n    \"wtNoQuorum\" : 6.704019,\n    \"numTooClose\" : 6,\n    \"numAgree\" : 6,\n    \"wtDisagreed\" : 6.878052,\n    \"numError\" : 2,\n    \"numDisagree\" : 3,\n    \"wtAgreed\" : 6.778325\n  },\n  \"hashAlgorithm\" : \"hashAlgorithm\",\n  \"status\" : \"status\",\n  \"errorDetails\" : \"errorDetails\"\n}", PollerDetail.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PollsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see PollsApi#getPollsAsPoller
     */
    default ResponseEntity<PollerPager> getPollsAsPoller( Integer  size,
         Integer  page) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"pageDesc\" : {\n    \"total\" : 150,\n    \"size\" : 5,\n    \"nextPage\" : \"nextPage\",\n    \"prevPage\" : \"prevPage\",\n    \"page\" : 10\n  },\n  \"polls\" : [ {\n    \"numCompletedRepairs\" : 5,\n    \"auId\" : \"auId\",\n    \"numHashErrors\" : 1,\n    \"numTalliedUrls\" : 6,\n    \"start\" : 2,\n    \"pollKey\" : \"pollKey\",\n    \"variant\" : \"variant\",\n    \"numAgreeUrls\" : 5,\n    \"pollEnd\" : 9,\n    \"deadline\" : 7,\n    \"detailLink\" : {\n      \"link\" : \"http:www.example.com/v1/element\",\n      \"desc\" : \"pollerOnly\"\n    },\n    \"status\" : \"status\",\n    \"participants\" : 0\n  }, {\n    \"numCompletedRepairs\" : 5,\n    \"auId\" : \"auId\",\n    \"numHashErrors\" : 1,\n    \"numTalliedUrls\" : 6,\n    \"start\" : 2,\n    \"pollKey\" : \"pollKey\",\n    \"variant\" : \"variant\",\n    \"numAgreeUrls\" : 5,\n    \"pollEnd\" : 9,\n    \"deadline\" : 7,\n    \"detailLink\" : {\n      \"link\" : \"http:www.example.com/v1/element\",\n      \"desc\" : \"pollerOnly\"\n    },\n    \"status\" : \"status\",\n    \"participants\" : 0\n  } ]\n}", PollerPager.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PollsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see PollsApi#getPollsAsVoter
     */
    default ResponseEntity<VoterPager> getPollsAsVoter( Integer  size,
         Integer  page) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"pageDesc\" : {\n    \"total\" : 150,\n    \"size\" : 5,\n    \"nextPage\" : \"nextPage\",\n    \"prevPage\" : \"prevPage\",\n    \"page\" : 10\n  },\n  \"polls\" : [ {\n    \"auId\" : \"auId\",\n    \"caller\" : \"caller\",\n    \"start\" : 0,\n    \"pollKey\" : \"pollKey\",\n    \"deadline\" : 6,\n    \"detailLink\" : {\n      \"link\" : \"http:www.example.com/v1/element\",\n      \"desc\" : \"pollerOnly\"\n    },\n    \"status\" : \"status\"\n  }, {\n    \"auId\" : \"auId\",\n    \"caller\" : \"caller\",\n    \"start\" : 0,\n    \"pollKey\" : \"pollKey\",\n    \"deadline\" : 6,\n    \"detailLink\" : {\n      \"link\" : \"http:www.example.com/v1/element\",\n      \"desc\" : \"pollerOnly\"\n    },\n    \"status\" : \"status\"\n  } ]\n}", VoterPager.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PollsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see PollsApi#getRepairQueueData
     */
    default ResponseEntity<RepairPager> getRepairQueueData( String  pollKey,
         String  repair,
         Integer  page,
         Integer  size) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"repairs\" : [ {\n    \"result\" : \"NoQuorum\",\n    \"repairUrl\" : \"repairUrl\",\n    \"repairFrom\" : \"repairFrom\"\n  }, {\n    \"result\" : \"NoQuorum\",\n    \"repairUrl\" : \"repairUrl\",\n    \"repairFrom\" : \"repairFrom\"\n  } ],\n  \"pageDesc\" : {\n    \"total\" : 150,\n    \"size\" : 5,\n    \"nextPage\" : \"nextPage\",\n    \"prevPage\" : \"prevPage\",\n    \"page\" : 10\n  }\n}", RepairPager.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PollsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see PollsApi#getTallyUrls
     */
    default ResponseEntity<UrlPager> getTallyUrls( String  pollKey,
         String  tally,
         Integer  page,
         Integer  size) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"pageDesc\" : {\n    \"total\" : 150,\n    \"size\" : 5,\n    \"nextPage\" : \"nextPage\",\n    \"prevPage\" : \"prevPage\",\n    \"page\" : 10\n  },\n  \"urls\" : [ \"urls\", \"urls\" ]\n}", UrlPager.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PollsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see PollsApi#getVoterPollDetails
     */
    default ResponseEntity<VoterDetail> getVoterPollDetails( String  pollKey) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"pollerNonce\" : \"pollerNonce\",\n  \"pollerId\" : \"pollerId\",\n  \"agreement\" : 5.962133916683182,\n  \"pollDesc\" : {\n    \"auId\" : \"auId\",\n    \"cuSetSpec\" : {\n      \"upperBound\" : \"upperBound\",\n      \"urlPrefix\" : \"urlPrefix\",\n      \"lowerBound\" : \"lowerBound\"\n    },\n    \"protocol\" : 6,\n    \"pollType\" : 3,\n    \"variant\" : \"PoR\",\n    \"pluginPollVersion\" : \"pluginPollVersion\",\n    \"modulus\" : 1\n  },\n  \"wtSymmetricAgreement\" : 7.061401241503109,\n  \"pollKey\" : \"pollKey\",\n  \"voterNonce\" : \"voterNonce\",\n  \"duration\" : 6,\n  \"voteDeadline\" : 9,\n  \"createTime\" : 0,\n  \"voter2Nonce\" : \"voter2Nonce\",\n  \"numVoterOnly\" : 7,\n  \"symmetricAgreement\" : 2.3021358869347655,\n  \"numAgree\" : 3,\n  \"callerId\" : \"callerId\",\n  \"deadline\" : 1,\n  \"wtAgreement\" : 5.637376656633329,\n  \"numPollerOnly\" : 4,\n  \"hashAlgorithm\" : \"hashAlgorithm\",\n  \"status\" : \"status\",\n  \"numDisagree\" : 2,\n  \"errorDetails\" : \"errorDetails\"\n}", VoterDetail.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PollsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

}
