package org.lockss.laaws.poller.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.v3.oas.annotations.media.Schema;
import org.lockss.laaws.poller.model.LinkDesc;
import org.springframework.validation.annotation.Validated;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;

/**
 * Detail for a single voter in a poll.
 */
@Schema(description = "Detail for a single voter in a poll.")
@Validated



public class PeerData   {
  @JsonProperty("peerId")
  private String peerId = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("agreement")
  private Float agreement = null;

  @JsonProperty("numAgree")
  private Long numAgree = null;

  @JsonProperty("agreeLink")
  private LinkDesc agreeLink = null;

  @JsonProperty("numDisagree")
  private Long numDisagree = null;

  @JsonProperty("disagreeLink")
  private LinkDesc disagreeLink = null;

  @JsonProperty("numPollerOnly")
  private Long numPollerOnly = null;

  @JsonProperty("pollerOnlyLink")
  private LinkDesc pollerOnlyLink = null;

  @JsonProperty("numVoterOnly")
  private Long numVoterOnly = null;

  @JsonProperty("voterOnlyLink")
  private LinkDesc voterOnlyLink = null;

  @JsonProperty("bytesHashed")
  private Long bytesHashed = null;

  @JsonProperty("bytesRead")
  private Long bytesRead = null;

  @JsonProperty("wtAgreement")
  private Float wtAgreement = null;

  @JsonProperty("wtNumAgree")
  private Float wtNumAgree = null;

  @JsonProperty("wtNumDisagree")
  private Float wtNumDisagree = null;

  @JsonProperty("wtNumPollerOnly")
  private Float wtNumPollerOnly = null;

  @JsonProperty("wtNumVoterOnly")
  private Float wtNumVoterOnly = null;

  @JsonProperty("state")
  private String state = null;

  @JsonProperty("lastStateChange")
  private Long lastStateChange = null;

  public PeerData peerId(String peerId) {
    this.peerId = peerId;
    return this;
  }

  /**
   * the peer id for this participant
   * @return peerId
   **/
  @Schema(required = true, description = "the peer id for this participant")
      @NotNull

    public String getPeerId() {
    return peerId;
  }

  public void setPeerId(String peerId) {
    this.peerId = peerId;
  }

  public PeerData status(String status) {
    this.status = status;
    return this;
  }

  /**
   * the status of this peer
   * @return status
   **/
  @Schema(required = true, description = "the status of this peer")
      @NotNull

    public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public PeerData agreement(Float agreement) {
    this.agreement = agreement;
    return this;
  }

  /**
   * the percentage of vote agreement.
   * @return agreement
   **/
  @Schema(description = "the percentage of vote agreement.")
  
    public Float getAgreement() {
    return agreement;
  }

  public void setAgreement(Float agreement) {
    this.agreement = agreement;
  }

  public PeerData numAgree(Long numAgree) {
    this.numAgree = numAgree;
    return this;
  }

  /**
   * The number of urls for which there was agreement.
   * @return numAgree
   **/
  @Schema(description = "The number of urls for which there was agreement.")
  
    public Long getNumAgree() {
    return numAgree;
  }

  public void setNumAgree(Long numAgree) {
    this.numAgree = numAgree;
  }

  public PeerData agreeLink(LinkDesc agreeLink) {
    this.agreeLink = agreeLink;
    return this;
  }

  /**
   * Get agreeLink
   * @return agreeLink
   **/
  @Schema(description = "")
  
    @Valid
    public LinkDesc getAgreeLink() {
    return agreeLink;
  }

  public void setAgreeLink(LinkDesc agreeLink) {
    this.agreeLink = agreeLink;
  }

  public PeerData numDisagree(Long numDisagree) {
    this.numDisagree = numDisagree;
    return this;
  }

  /**
   * The number of urls for which there was disagreement.
   * @return numDisagree
   **/
  @Schema(description = "The number of urls for which there was disagreement.")
  
    public Long getNumDisagree() {
    return numDisagree;
  }

  public void setNumDisagree(Long numDisagree) {
    this.numDisagree = numDisagree;
  }

  public PeerData disagreeLink(LinkDesc disagreeLink) {
    this.disagreeLink = disagreeLink;
    return this;
  }

  /**
   * Get disagreeLink
   * @return disagreeLink
   **/
  @Schema(description = "")
  
    @Valid
    public LinkDesc getDisagreeLink() {
    return disagreeLink;
  }

  public void setDisagreeLink(LinkDesc disagreeLink) {
    this.disagreeLink = disagreeLink;
  }

  public PeerData numPollerOnly(Long numPollerOnly) {
    this.numPollerOnly = numPollerOnly;
    return this;
  }

  /**
   * The number of urls which were poller only.
   * @return numPollerOnly
   **/
  @Schema(description = "The number of urls which were poller only.")
  
    public Long getNumPollerOnly() {
    return numPollerOnly;
  }

  public void setNumPollerOnly(Long numPollerOnly) {
    this.numPollerOnly = numPollerOnly;
  }

  public PeerData pollerOnlyLink(LinkDesc pollerOnlyLink) {
    this.pollerOnlyLink = pollerOnlyLink;
    return this;
  }

  /**
   * Get pollerOnlyLink
   * @return pollerOnlyLink
   **/
  @Schema(description = "")
  
    @Valid
    public LinkDesc getPollerOnlyLink() {
    return pollerOnlyLink;
  }

  public void setPollerOnlyLink(LinkDesc pollerOnlyLink) {
    this.pollerOnlyLink = pollerOnlyLink;
  }

  public PeerData numVoterOnly(Long numVoterOnly) {
    this.numVoterOnly = numVoterOnly;
    return this;
  }

  /**
   * The number of urls for which were voter only.
   * @return numVoterOnly
   **/
  @Schema(description = "The number of urls for which were voter only.")
  
    public Long getNumVoterOnly() {
    return numVoterOnly;
  }

  public void setNumVoterOnly(Long numVoterOnly) {
    this.numVoterOnly = numVoterOnly;
  }

  public PeerData voterOnlyLink(LinkDesc voterOnlyLink) {
    this.voterOnlyLink = voterOnlyLink;
    return this;
  }

  /**
   * Get voterOnlyLink
   * @return voterOnlyLink
   **/
  @Schema(description = "")
  
    @Valid
    public LinkDesc getVoterOnlyLink() {
    return voterOnlyLink;
  }

  public void setVoterOnlyLink(LinkDesc voterOnlyLink) {
    this.voterOnlyLink = voterOnlyLink;
  }

  public PeerData bytesHashed(Long bytesHashed) {
    this.bytesHashed = bytesHashed;
    return this;
  }

  /**
   * the number of bytes hashed.
   * @return bytesHashed
   **/
  @Schema(description = "the number of bytes hashed.")
  
    public Long getBytesHashed() {
    return bytesHashed;
  }

  public void setBytesHashed(Long bytesHashed) {
    this.bytesHashed = bytesHashed;
  }

  public PeerData bytesRead(Long bytesRead) {
    this.bytesRead = bytesRead;
    return this;
  }

  /**
   * the number of bytes read.
   * @return bytesRead
   **/
  @Schema(description = "the number of bytes read.")
  
    public Long getBytesRead() {
    return bytesRead;
  }

  public void setBytesRead(Long bytesRead) {
    this.bytesRead = bytesRead;
  }

  public PeerData wtAgreement(Float wtAgreement) {
    this.wtAgreement = wtAgreement;
    return this;
  }

  /**
   * the weight of vote percentage agreement.
   * @return wtAgreement
   **/
  @Schema(description = "the weight of vote percentage agreement.")
  
    public Float getWtAgreement() {
    return wtAgreement;
  }

  public void setWtAgreement(Float wtAgreement) {
    this.wtAgreement = wtAgreement;
  }

  public PeerData wtNumAgree(Float wtNumAgree) {
    this.wtNumAgree = wtNumAgree;
    return this;
  }

  /**
   * the weight of number agree votes.
   * @return wtNumAgree
   **/
  @Schema(description = "the weight of number agree votes.")
  
    public Float getWtNumAgree() {
    return wtNumAgree;
  }

  public void setWtNumAgree(Float wtNumAgree) {
    this.wtNumAgree = wtNumAgree;
  }

  public PeerData wtNumDisagree(Float wtNumDisagree) {
    this.wtNumDisagree = wtNumDisagree;
    return this;
  }

  /**
   * the weight of number of disagree votes.
   * @return wtNumDisagree
   **/
  @Schema(description = "the weight of number of disagree votes.")
  
    public Float getWtNumDisagree() {
    return wtNumDisagree;
  }

  public void setWtNumDisagree(Float wtNumDisagree) {
    this.wtNumDisagree = wtNumDisagree;
  }

  public PeerData wtNumPollerOnly(Float wtNumPollerOnly) {
    this.wtNumPollerOnly = wtNumPollerOnly;
    return this;
  }

  /**
   * the weight of number of poller only votes.
   * @return wtNumPollerOnly
   **/
  @Schema(description = "the weight of number of poller only votes.")
  
    public Float getWtNumPollerOnly() {
    return wtNumPollerOnly;
  }

  public void setWtNumPollerOnly(Float wtNumPollerOnly) {
    this.wtNumPollerOnly = wtNumPollerOnly;
  }

  public PeerData wtNumVoterOnly(Float wtNumVoterOnly) {
    this.wtNumVoterOnly = wtNumVoterOnly;
    return this;
  }

  /**
   * the weight of number of voter only votes.
   * @return wtNumVoterOnly
   **/
  @Schema(description = "the weight of number of voter only votes.")
  
    public Float getWtNumVoterOnly() {
    return wtNumVoterOnly;
  }

  public void setWtNumVoterOnly(Float wtNumVoterOnly) {
    this.wtNumVoterOnly = wtNumVoterOnly;
  }

  public PeerData state(String state) {
    this.state = state;
    return this;
  }

  /**
   * the state machine state.
   * @return state
   **/
  @Schema(description = "the state machine state.")
  
    public String getState() {
    return state;
  }

  public void setState(String state) {
    this.state = state;
  }

  public PeerData lastStateChange(Long lastStateChange) {
    this.lastStateChange = lastStateChange;
    return this;
  }

  /**
   * the time of last state change.
   * @return lastStateChange
   **/
  @Schema(description = "the time of last state change.")
  
    public Long getLastStateChange() {
    return lastStateChange;
  }

  public void setLastStateChange(Long lastStateChange) {
    this.lastStateChange = lastStateChange;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PeerData peerData = (PeerData) o;
    return Objects.equals(this.peerId, peerData.peerId) &&
        Objects.equals(this.status, peerData.status) &&
        Objects.equals(this.agreement, peerData.agreement) &&
        Objects.equals(this.numAgree, peerData.numAgree) &&
        Objects.equals(this.agreeLink, peerData.agreeLink) &&
        Objects.equals(this.numDisagree, peerData.numDisagree) &&
        Objects.equals(this.disagreeLink, peerData.disagreeLink) &&
        Objects.equals(this.numPollerOnly, peerData.numPollerOnly) &&
        Objects.equals(this.pollerOnlyLink, peerData.pollerOnlyLink) &&
        Objects.equals(this.numVoterOnly, peerData.numVoterOnly) &&
        Objects.equals(this.voterOnlyLink, peerData.voterOnlyLink) &&
        Objects.equals(this.bytesHashed, peerData.bytesHashed) &&
        Objects.equals(this.bytesRead, peerData.bytesRead) &&
        Objects.equals(this.wtAgreement, peerData.wtAgreement) &&
        Objects.equals(this.wtNumAgree, peerData.wtNumAgree) &&
        Objects.equals(this.wtNumDisagree, peerData.wtNumDisagree) &&
        Objects.equals(this.wtNumPollerOnly, peerData.wtNumPollerOnly) &&
        Objects.equals(this.wtNumVoterOnly, peerData.wtNumVoterOnly) &&
        Objects.equals(this.state, peerData.state) &&
        Objects.equals(this.lastStateChange, peerData.lastStateChange);
  }

  @Override
  public int hashCode() {
    return Objects.hash(peerId, status, agreement, numAgree, agreeLink, numDisagree, disagreeLink, numPollerOnly, pollerOnlyLink, numVoterOnly, voterOnlyLink, bytesHashed, bytesRead, wtAgreement, wtNumAgree, wtNumDisagree, wtNumPollerOnly, wtNumVoterOnly, state, lastStateChange);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PeerData {\n");
    
    sb.append("    peerId: ").append(toIndentedString(peerId)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    agreement: ").append(toIndentedString(agreement)).append("\n");
    sb.append("    numAgree: ").append(toIndentedString(numAgree)).append("\n");
    sb.append("    agreeLink: ").append(toIndentedString(agreeLink)).append("\n");
    sb.append("    numDisagree: ").append(toIndentedString(numDisagree)).append("\n");
    sb.append("    disagreeLink: ").append(toIndentedString(disagreeLink)).append("\n");
    sb.append("    numPollerOnly: ").append(toIndentedString(numPollerOnly)).append("\n");
    sb.append("    pollerOnlyLink: ").append(toIndentedString(pollerOnlyLink)).append("\n");
    sb.append("    numVoterOnly: ").append(toIndentedString(numVoterOnly)).append("\n");
    sb.append("    voterOnlyLink: ").append(toIndentedString(voterOnlyLink)).append("\n");
    sb.append("    bytesHashed: ").append(toIndentedString(bytesHashed)).append("\n");
    sb.append("    bytesRead: ").append(toIndentedString(bytesRead)).append("\n");
    sb.append("    wtAgreement: ").append(toIndentedString(wtAgreement)).append("\n");
    sb.append("    wtNumAgree: ").append(toIndentedString(wtNumAgree)).append("\n");
    sb.append("    wtNumDisagree: ").append(toIndentedString(wtNumDisagree)).append("\n");
    sb.append("    wtNumPollerOnly: ").append(toIndentedString(wtNumPollerOnly)).append("\n");
    sb.append("    wtNumVoterOnly: ").append(toIndentedString(wtNumVoterOnly)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    lastStateChange: ").append(toIndentedString(lastStateChange)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
