/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.lockss.laaws.poller.api.WsApiDelegate;
import org.lockss.laaws.poller.model.ErrorResult;
import org.lockss.ws.entities.HasherWsParams;
import org.lockss.ws.entities.PeerWsResult;
import org.lockss.ws.entities.PollWsResult;
import org.lockss.ws.entities.RepositorySpaceWsResult;
import org.lockss.ws.entities.RepositoryWsResult;
import org.lockss.ws.entities.VoteWsResult;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@Validated
public interface WsApi {
    public WsApiDelegate getDelegate();

    @Operation(summary="Remove an asynchronous hashing operation", description="Remove from the system an asynchronous hashing operation, terminating it if it's still running", security={@SecurityRequirement(name="basicAuth")}, tags={"hash"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Asynchronous hashing operation successfully removed", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/ws/hashes/requests/{requestId}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    default public ResponseEntity<String> deleteHash(@Parameter(in=ParameterIn.PATH, description="Identifier of the asynchronous hashing operation", required=true, schema=@Schema) @PathVariable(value="requestId") String requestId) {
        return this.getDelegate().deleteHash(requestId);
    }

    @Operation(summary="Get the results of all the asynchronous hashing operations", description="Get the results of all the asynchronous hashing operations", security={@SecurityRequirement(name="basicAuth")}, tags={"hash"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Information about all the asynchronous hashing operations", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=Resource.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/ws/hashes"}, produces={"multipart/form-data", "application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<Resource> getAllHashes() {
        return this.getDelegate().getAllHashes();
    }

    @Operation(summary="Get the result of an asynchronous hashing operation", description="Get the result of an asynchronous hashing operation", security={@SecurityRequirement(name="basicAuth")}, tags={"hash"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Information about the asynchronous hashing operation", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=Resource.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/ws/hashes/requests/{requestId}"}, produces={"multipart/form-data", "application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<Resource> getHash(@Parameter(in=ParameterIn.PATH, description="Identifier of the asynchronous hashing operation", required=true, schema=@Schema) @PathVariable(value="requestId") String requestId) {
        return this.getDelegate().getHash(requestId);
    }

    @Operation(summary="Query for peer properties", description="Query for peers that meet a set of specified conditions", security={@SecurityRequirement(name="basicAuth")}, tags={"service"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Information about the requested peers", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=PeerWsResult.class)))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/ws/peers"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<List<PeerWsResult>> getPeers(@NotNull @Parameter(in=ParameterIn.QUERY, description="The query that specifies the peers to be returned", required=true, schema=@Schema) @Valid @RequestParam(value="peerQuery", required=true) String peerQuery) {
        return this.getDelegate().getPeers(peerQuery);
    }

    @Operation(summary="Query for poll properties", description="Query for polls that meet a set of specified conditions", security={@SecurityRequirement(name="basicAuth")}, tags={"service"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Information about the requested polls", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=PollWsResult.class)))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/ws/polls"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<List<PollWsResult>> getPolls(@NotNull @Parameter(in=ParameterIn.QUERY, description="The query that specifies the polls to be returned", required=true, schema=@Schema) @Valid @RequestParam(value="pollQuery", required=true) String pollQuery) {
        return this.getDelegate().getPolls(pollQuery);
    }

    @Operation(summary="Query the properties of repositories", description="Query the system for selected repository properties", security={@SecurityRequirement(name="basicAuth")}, tags={"repo"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Information about the requested TDB AUs", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=RepositoryWsResult.class)))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/ws/aurepositories"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<List<RepositoryWsResult>> getRepositories(@NotNull @Parameter(in=ParameterIn.QUERY, description="The query that specifies the repository properties to be returned", required=true, schema=@Schema) @Valid @RequestParam(value="repositoryQuery", required=true) String repositoryQuery) {
        return this.getDelegate().getRepositories(repositoryQuery);
    }

    @Operation(summary="Query the properties of repository spaces", description="Query the system for selected repository space properties", security={@SecurityRequirement(name="basicAuth")}, tags={"repo"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Information about the requested TDB AUs", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=RepositorySpaceWsResult.class)))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/ws/repositoryspaces"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<List<RepositorySpaceWsResult>> getRepositorySpaces(@NotNull @Parameter(in=ParameterIn.QUERY, description="The query that specifies the repository space properties to be returned", required=true, schema=@Schema) @Valid @RequestParam(value="repositorySpaceQuery", required=true) String repositorySpaceQuery) {
        return this.getDelegate().getRepositorySpaces(repositorySpaceQuery);
    }

    @Operation(summary="Query for vote properties", description="Query for votes that meet a set of specified conditions", security={@SecurityRequirement(name="basicAuth")}, tags={"service"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Information about the requested votes", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=VoteWsResult.class)))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/ws/votes"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<List<VoteWsResult>> getVotes(@NotNull @Parameter(in=ParameterIn.QUERY, description="The query that specifies the votes to be returned", required=true, schema=@Schema) @Valid @RequestParam(value="voteQuery", required=true) String voteQuery) {
        return this.getDelegate().getVotes(voteQuery);
    }

    @Operation(summary="Perform a hashing operation", description="Perform the hashing of an AU or a URL", security={@SecurityRequirement(name="basicAuth")}, tags={"hash"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Information about the performed hashing operation", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=Resource.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/ws/hashes"}, produces={"multipart/form-data", "application/json"}, consumes={"*/*"}, method={RequestMethod.PUT})
    default public ResponseEntity<Resource> putHash(@Parameter(in=ParameterIn.DEFAULT, description="The parameters needed to define a hash.", required=true, schema=@Schema) @Valid @RequestBody HasherWsParams body, @Parameter(in=ParameterIn.QUERY, description="Indication of whether the operation should be done \u0007synchronously", schema=@Schema(defaultValue="true")) @Valid @RequestParam(value="isAsynchronous", required=false, defaultValue="true") Boolean isAsynchronous) {
        return this.getDelegate().putHash(body, isAsynchronous);
    }

    @Operation(summary="Import a file into an Archival Unit", description="Import a file as an artifact in an Archival Unit", security={@SecurityRequirement(name="basicAuth")}, tags={"import"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/ws/aus/import"}, produces={"application/json"}, consumes={"multipart/form-data"}, method={RequestMethod.PUT})
    default public ResponseEntity<Void> putImportFile(@Parameter(in=ParameterIn.DEFAULT, description="", required=true, schema=@Schema) @RequestPart(value="targetBaseUrlPath", required=true) String targetBaseUrlPath, @Parameter(in=ParameterIn.DEFAULT, description="", required=true, schema=@Schema) @RequestPart(value="targetUrl", required=true) String targetUrl, @Parameter(description="") @Valid @RequestPart(value="file", required=true) MultipartFile file, @Parameter(in=ParameterIn.DEFAULT, description="", required=true, schema=@Schema) @RequestPart(value="userProperties", required=true) List<String> userProperties) {
        return this.getDelegate().putImportFile(targetBaseUrlPath, targetUrl, file, userProperties);
    }
}

