/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lockss.app.LockssDaemon;
import org.lockss.laaws.poller.impl.PollWsSource;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.poller.PollManager;
import org.lockss.poller.v3.V3Poller;
import org.lockss.util.Logger;
import org.lockss.ws.entities.PollWsResult;

public class PollHelper {
    static String SOURCE_FQCN = PollWsSource.class.getCanonicalName();
    static String RESULT_FQCN = PollWsResult.class.getCanonicalName();
    static String AU_ID = "auId";
    static String AU_NAME = "auName";
    static String PARTICIPANT_COUNT = "participantCount";
    static String POLL_STATUS = "pollStatus";
    static String TALLIED_URL_COUNT = "talliedUrlCount";
    static String TALLIED_URLS = "talliedUrls";
    static String HASH_ERROR_COUNT = "hashErrorCount";
    static String ERROR_URLS = "errorUrls";
    static String COMPLETED_REPAIR_COUNT = "completedRepairCount";
    static String COMPLETED_REPAIRS = "completedRepairs";
    static String PERCENTAGE_AGREEMENT = "percentAgreement";
    static String START_TIME = "startTime";
    static String DEADLINE = "deadline";
    static String POLL_KEY = "pollKey";
    static String POLL_VARIANT = "pollVariant";
    static String ERROR_DETAIL = "errorDetail";
    static String ADDITIONAL_INFO = "additionalInfo";
    static String VOTE_DEADLINE = "voteDeadline";
    static String DURATION = "duration";
    static String REMAINING_TIME = "remainingTime";
    static String END_TIME = "endTime";
    static String AGREED_URL_COUNT = "agreedUrlCount";
    static String AGREED_URLS = "agreedUrls";
    static String DISAGREED_URL_COUNT = "disagreedUrlCount";
    static String DISAGREED_URLS = "disagreedUrls";
    static String NO_QUORUM_URL_COUNT = "noQuorumUrlCount";
    static String NO_QUORUM_URLS = "noQuorumUrls";
    static String TOO_CLOSE_URL_COUNT = "tooCloseUrlCount";
    static String TOO_CLOSE_URLS = "tooCloseUrls";
    static String ACTIVE_REPAIR_COUNT = "activeRepairCount";
    static String ACTIVE_REPAIRS = "activeRepairs";
    static String BYTES_HASHED_COUNT = "bytesHashedCount";
    static String BYTES_READ_COUNT = "bytesReadCount";
    static String QUORUM = "quorum";
    static String PARTICIPANTS = "participants";
    static final Set<String> PROPERTY_NAMES = new HashSet<String>(){
        {
            this.add(AU_ID);
            this.add(AU_NAME);
            this.add(PARTICIPANT_COUNT);
            this.add(POLL_STATUS);
            this.add(TALLIED_URL_COUNT);
            this.add(TALLIED_URLS);
            this.add(HASH_ERROR_COUNT);
            this.add(ERROR_URLS);
            this.add(COMPLETED_REPAIR_COUNT);
            this.add(COMPLETED_REPAIRS);
            this.add(PERCENTAGE_AGREEMENT);
            this.add(START_TIME);
            this.add(DEADLINE);
            this.add(POLL_KEY);
            this.add(POLL_VARIANT);
            this.add(ERROR_DETAIL);
            this.add(ADDITIONAL_INFO);
            this.add(VOTE_DEADLINE);
            this.add(DURATION);
            this.add(REMAINING_TIME);
            this.add(END_TIME);
            this.add(AGREED_URL_COUNT);
            this.add(AGREED_URLS);
            this.add(DISAGREED_URL_COUNT);
            this.add(DISAGREED_URLS);
            this.add(NO_QUORUM_URL_COUNT);
            this.add(NO_QUORUM_URLS);
            this.add(TOO_CLOSE_URL_COUNT);
            this.add(TOO_CLOSE_URLS);
            this.add(ACTIVE_REPAIR_COUNT);
            this.add(ACTIVE_REPAIRS);
            this.add(BYTES_HASHED_COUNT);
            this.add(BYTES_READ_COUNT);
            this.add(QUORUM);
            this.add(PARTICIPANTS);
        }
    };
    private static Logger log = Logger.getLogger();

    List<PollWsSource> createUniverse() {
        String DEBUG_HEADER = "createUniverse(): ";
        PollManager pollManager = (PollManager)LockssDaemon.getManagerByKeyStatic((String)LockssDaemon.POLL_MANAGER);
        Collection allPolls = pollManager.getV3Pollers();
        if (log.isDebug3()) {
            log.debug3("createUniverse(): allPolls.size() = " + allPolls.size());
        }
        ArrayList<PollWsSource> universe = new ArrayList<PollWsSource>(allPolls.size());
        for (V3Poller poll : allPolls) {
            universe.add(new PollWsSource(poll));
        }
        for (ArchivalUnit au : pollManager.getPendingQueueAus()) {
            universe.add(new PollWsSource(au));
        }
        if (log.isDebug2()) {
            log.debug2("createUniverse(): universe.size() = " + universe.size());
        }
        return universe;
    }

    String nonDefaultToString(Collection<PollWsResult> results) {
        StringBuilder builder = new StringBuilder("[");
        boolean isFirst = true;
        for (PollWsResult result : results) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append(this.nonDefaultToString(result));
        }
        return builder.append("]").toString();
    }

    private String nonDefaultToString(PollWsResult result) {
        StringBuilder builder = new StringBuilder("PollWsResult [");
        boolean isFirst = true;
        if (result.getAuId() != null) {
            builder.append("auId=").append(result.getAuId());
            isFirst = false;
        }
        if (result.getAuName() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("auName=").append(result.getAuName());
        }
        if (result.getParticipantCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("participantCount=").append(result.getParticipantCount());
        }
        if (result.getPollStatus() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("pollStatus=").append(result.getPollStatus());
        }
        if (result.getTalliedUrlCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("talliedUrlCount=").append(result.getTalliedUrlCount());
        }
        if (result.getTalliedUrls() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("talliedUrls=").append(result.getTalliedUrls());
        }
        if (result.getHashErrorCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("hashErrorCount=").append(result.getHashErrorCount());
        }
        if (result.getErrorUrls() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("errorUrls=").append(result.getErrorUrls());
        }
        if (result.getCompletedRepairCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("completedRepairCount=").append(result.getCompletedRepairCount());
        }
        if (result.getCompletedRepairs() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("completedRepairs=").append(result.getCompletedRepairs());
        }
        if (result.getPercentAgreement() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("percentAgreement=").append(result.getPercentAgreement());
        }
        if (result.getStartTime() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("startTime=").append(result.getStartTime());
        }
        if (result.getDeadline() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("deadline=").append(result.getDeadline());
        }
        if (result.getPollKey() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("pollKey=").append(result.getPollKey());
        }
        if (result.getPollVariant() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("pollVariant=").append(result.getPollVariant());
        }
        if (result.getErrorDetail() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("errorDetail=").append(result.getErrorDetail());
        }
        if (result.getAdditionalInfo() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("additionalInfo=").append(result.getAdditionalInfo());
        }
        if (result.getVoteDeadline() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("voteDeadline=").append(result.getVoteDeadline());
        }
        if (result.getDuration() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("duration=").append(result.getDuration());
        }
        if (result.getRemainingTime() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("remainingTime=").append(result.getRemainingTime());
        }
        if (result.getEndTime() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("endTime=").append(result.getEndTime());
        }
        if (result.getAgreedUrlCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("agreedUrlCount=").append(result.getAgreedUrlCount());
        }
        if (result.getAgreedUrls() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("agreedUrls=").append(result.getAgreedUrls());
        }
        if (result.getDisagreedUrlCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("disagreedUrlCount=").append(result.getDisagreedUrlCount());
        }
        if (result.getDisagreedUrls() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("disagreedUrls=").append(result.getDisagreedUrls());
        }
        if (result.getNoQuorumUrlCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("noQuorumUrlCount=").append(result.getNoQuorumUrlCount());
        }
        if (result.getNoQuorumUrls() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("noQuorumUrls=").append(result.getNoQuorumUrls());
        }
        if (result.getTooCloseUrlCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("tooCloseUrlCount=").append(result.getTooCloseUrlCount());
        }
        if (result.getTooCloseUrls() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("tooCloseUrls=").append(result.getTooCloseUrls());
        }
        if (result.getActiveRepairCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("activeRepairCount=").append(result.getActiveRepairCount());
        }
        if (result.getActiveRepairs() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("activeRepairs=").append(result.getActiveRepairs());
        }
        if (result.getBytesHashedCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("bytesHashedCount=").append(result.getBytesHashedCount());
        }
        if (result.getBytesReadCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("bytesReadCount=").append(result.getBytesReadCount());
        }
        if (result.getQuorum() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("quorum=").append(result.getQuorum());
        }
        if (result.getParticipants() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("participants=").append(result.getParticipants());
        }
        return builder.append("]").toString();
    }
}

