/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.activation.FileDataSource;
import org.apache.logging.log4j.util.Supplier;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryResults;
import org.lockss.hasher.HasherParams;
import org.lockss.hasher.HasherResult;
import org.lockss.hasher.SimpleHasher;
import org.lockss.importer.Importer;
import org.lockss.laaws.poller.api.WsApiDelegate;
import org.lockss.laaws.poller.impl.PeerHelper;
import org.lockss.laaws.poller.impl.PollHelper;
import org.lockss.laaws.poller.impl.RepositoryHelper;
import org.lockss.laaws.poller.impl.RepositorySpaceHelper;
import org.lockss.laaws.poller.impl.VoteHelper;
import org.lockss.log.L4JLogger;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.spring.error.LockssRestServiceException;
import org.lockss.util.StringUtil;
import org.lockss.util.io.FileUtil;
import org.lockss.util.josql.JosqlUtil;
import org.lockss.util.os.PlatformUtil;
import org.lockss.util.rest.repo.util.NamedInputStreamResource;
import org.lockss.util.time.TimeBase;
import org.lockss.ws.entities.HasherWsParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

@Service
public class WsApiServiceImpl
extends BaseSpringApiServiceImpl
implements WsApiDelegate {
    private static L4JLogger log = L4JLogger.getLogger();
    private final HttpServletRequest request;
    private static final Map<String, SimpleHasher.ParamsAndResult> HASH_REQUESTS = new LinkedHashMap<String, SimpleHasher.ParamsAndResult>();
    private static final String DEFAULT_REQUEST_ID = "noRequestId";

    @Autowired
    public WsApiServiceImpl(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public ResponseEntity<Void> putImportFile(String targetBaseUrlPath, String targetUrl, MultipartFile file, List<String> userProperties) {
        String parsedRequest = String.format("targetBaseUrlPath: %s, targetUrl: %s, content.getName(): %s, content.getSize(): %s, userProperties: %s, requestUrl: %s", targetBaseUrlPath, targetUrl, file.getName(), file.getSize(), userProperties, this.getFullRequestUrl(this.request));
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        try {
            new Importer().importFile(file.getInputStream(), targetBaseUrlPath, targetUrl, userProperties);
            return new ResponseEntity(null, null, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IllegalArgumentException | IllegalStateException | NoSuchAlgorithmException e) {
            String errorMessage = "Exception caught trying to import file";
            log.warn(errorMessage, (Throwable)e);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(HttpStatus.BAD_REQUEST, errorMessage, (Throwable)e, parsedRequest);
        }
        catch (Exception e) {
            String errorMessage = "Unexpected exception caught trying to import file";
            log.warn(errorMessage, (Throwable)e);
            log.warn("Parsed request: {}", (Object)parsedRequest);
            throw new LockssRestServiceException(HttpStatus.INTERNAL_SERVER_ERROR, errorMessage, (Throwable)e, parsedRequest);
        }
    }

    private String getFullRequestUrl(HttpServletRequest request) {
        if (request.getQueryString() == null || request.getQueryString().trim().isEmpty()) {
            return "'" + request.getMethod() + " " + String.valueOf(request.getRequestURL()) + "'";
        }
        return "'" + request.getMethod() + " " + String.valueOf(request.getRequestURL()) + "?" + request.getQueryString() + "'";
    }

    public ResponseEntity getRepositories(String repositoryQuery) {
        log.debug2("repositoryQuery = {}", (Object)repositoryQuery);
        RepositoryHelper repositoryHelper = new RepositoryHelper();
        List results = null;
        try {
            String fullQuery = JosqlUtil.createFullQuery((String)repositoryQuery, (String)RepositoryHelper.SOURCE_FQCN, RepositoryHelper.PROPERTY_NAMES, (String)RepositoryHelper.RESULT_FQCN);
            log.trace("fullQuery = {}", (Object)fullQuery);
            Query q = new Query();
            try {
                q.parse(fullQuery);
                QueryResults qr = q.execute(repositoryHelper.createUniverse());
                results = qr.getResults();
                log.trace("results.size() = {}", (Object)results.size());
                log.trace("results = {}", (Object)repositoryHelper.nonDefaultToString(results));
                return new ResponseEntity((Object)results, (HttpStatusCode)HttpStatus.OK);
            }
            catch (QueryExecutionException qee) {
                String message = "Cannot getRepositories() for repositoryQuery = '" + repositoryQuery + "'";
                log.error(message, (Throwable)qee);
                return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        catch (Exception e) {
            String message = "Cannot getRepositories() for repositoryQuery = '" + repositoryQuery + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseEntity<String> deleteHash(String requestId) {
        log.debug2("requestId = {}", (Object)requestId);
        Object message = null;
        try {
            SimpleHasher.ParamsAndResult paramsAndResult;
            if (StringUtil.isNullString((String)requestId)) {
                message = "Must supply request identifier";
                log.warn((String)message);
                return new ResponseEntity(message, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            Map<String, SimpleHasher.ParamsAndResult> map = HASH_REQUESTS;
            synchronized (map) {
                paramsAndResult = HASH_REQUESTS.get(requestId);
            }
            if (paramsAndResult == null || paramsAndResult.result == null) {
                message = "Cannot find asynchronous hash request '" + requestId + "'";
                log.warn((String)message);
                return new ResponseEntity(message, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            HasherResult result = paramsAndResult.result;
            log.trace("result = {}", (Object)result);
            switch (result.getRunnerStatus()) {
                case NotStarted: 
                case Init: 
                case Starting: 
                case Running: {
                    Future future = result.getFuture();
                    if (future == null) break;
                    future.cancel(true);
                    break;
                }
            }
            FileUtil.safeDeleteFile((File)result.getBlockFile());
            FileUtil.safeDeleteFile((File)result.getRecordFile());
            Map<String, SimpleHasher.ParamsAndResult> map2 = HASH_REQUESTS;
            synchronized (map2) {
                HASH_REQUESTS.remove(requestId);
            }
            message = SimpleHasher.HasherStatus.Done.toString();
            log.debug2("message = {}", message);
            return new ResponseEntity(message, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            message = "Cannot deleteHash() for requestId = '" + requestId + "'";
            log.error((String)message, (Throwable)e);
            return new ResponseEntity(message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity getAllHashes() {
        log.debug2("Invoked.");
        try {
            LinkedMultiValueMap parts = new LinkedMultiValueMap();
            Map<String, SimpleHasher.ParamsAndResult> map = HASH_REQUESTS;
            synchronized (map) {
                for (String requestId : HASH_REQUESTS.keySet()) {
                    HasherResult result = WsApiServiceImpl.HASH_REQUESTS.get((Object)requestId).result;
                    log.trace("result = {}", (Object)result);
                    this.populateResultParts(requestId, result, (MultiValueMap<String, HttpEntity<?>>)parts);
                }
            }
            log.trace("parts.size() = {}", (Object)parts.size());
            return this.buildResponse((MultiValueMap<String, HttpEntity<?>>)parts);
        }
        catch (Exception e) {
            String message = "Cannot getAllHashes()";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity getHash(String requestId) {
        log.debug2("requestId = {}", (Object)requestId);
        Object message = null;
        try {
            SimpleHasher.ParamsAndResult paramsAndResult;
            if (StringUtil.isNullString((String)requestId)) {
                message = "Must supply request identifier";
                log.warn((String)message);
                return new ResponseEntity(message, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            Map<String, SimpleHasher.ParamsAndResult> map = HASH_REQUESTS;
            synchronized (map) {
                paramsAndResult = HASH_REQUESTS.get(requestId);
            }
            if (paramsAndResult == null || paramsAndResult.result == null) {
                message = "Cannot find asynchronous hash request '" + requestId + "'";
                log.warn((String)message);
                return new ResponseEntity(message, (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            HasherResult result = paramsAndResult.result;
            log.trace("result = {}", (Object)result);
            LinkedMultiValueMap parts = new LinkedMultiValueMap();
            this.populateResultParts(requestId, result, (MultiValueMap<String, HttpEntity<?>>)parts);
            log.trace("parts.size() = {}", (Object)parts.size());
            return this.buildResponse((MultiValueMap<String, HttpEntity<?>>)parts);
        }
        catch (Exception e) {
            message = "Cannot getHash() for requestId = '" + requestId + "'";
            log.error((String)message, (Throwable)e);
            return new ResponseEntity(message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity putHash(HasherWsParams hasherWsParams, Boolean isAsynchronous) {
        log.debug2("hasherWsParams = {}", (Object)hasherWsParams);
        log.debug2("isAsynchronous = {}", (Object)isAsynchronous);
        try {
            HasherParams params = new HasherParams(PlatformUtil.getLocalHostname(), isAsynchronous.booleanValue());
            params.setAlgorithm(hasherWsParams.getAlgorithm());
            params.setAuId(hasherWsParams.getAuId());
            params.setChallenge(hasherWsParams.getChallenge());
            Boolean excludeSuspectVersions = hasherWsParams.isExcludeSuspectVersions();
            if (excludeSuspectVersions == null) {
                params.setExcludeSuspectVersions(false);
            } else {
                params.setExcludeSuspectVersions(excludeSuspectVersions.booleanValue());
            }
            Boolean includeWeight = hasherWsParams.isIncludeWeight();
            if (includeWeight == null) {
                params.setIncludeWeight(false);
            } else {
                params.setIncludeWeight(includeWeight.booleanValue());
            }
            params.setHashType(hasherWsParams.getHashType());
            params.setLower(hasherWsParams.getLower());
            Boolean recordFilteredStream = hasherWsParams.isRecordFilteredStream();
            if (recordFilteredStream == null) {
                params.setRecordFilteredStream(false);
            } else {
                params.setRecordFilteredStream(recordFilteredStream.booleanValue());
            }
            params.setResultEncoding(hasherWsParams.getResultEncoding());
            params.setUpper(hasherWsParams.getUpper());
            params.setUrl(hasherWsParams.getUrl());
            params.setVerifier(hasherWsParams.getVerifier());
            log.trace("params = {}", (Object)params);
            HasherResult result = new HasherResult();
            String requestId = DEFAULT_REQUEST_ID;
            if (!isAsynchronous.booleanValue()) {
                new SimpleHasher(null).hash(params, result);
            } else {
                try {
                    long requestTime = TimeBase.nowMs();
                    result.setRequestTime(requestTime);
                    Map<String, SimpleHasher.ParamsAndResult> map = HASH_REQUESTS;
                    synchronized (map) {
                        requestId = SimpleHasher.getReqId((HasherParams)params, (HasherResult)result, HASH_REQUESTS);
                        log.trace("requestId = {}", (Object)requestId);
                    }
                    new SimpleHasher(null).startHashingThread(params, result);
                }
                catch (RuntimeException re) {
                    String errorMessage = "Error starting asynchronous hash thread: " + re.toString();
                    log.warn(errorMessage);
                    log.warn((Object)re);
                    return new ResponseEntity((Object)errorMessage, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
            log.trace("result = {}", (Object)result);
            LinkedMultiValueMap parts = new LinkedMultiValueMap();
            this.populateResultParts(requestId, result, (MultiValueMap<String, HttpEntity<?>>)parts);
            log.trace("parts.size() = {}", (Object)parts.size());
            return this.buildResponse((MultiValueMap<String, HttpEntity<?>>)parts);
        }
        catch (Exception e) {
            String message = "Cannot putHash() for hasherWsParams = '" + String.valueOf(hasherWsParams) + "', isAsynchronous = " + isAsynchronous;
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void populateResultParts(String requestId, HasherResult result, MultiValueMap<String, HttpEntity<?>> parts) throws IOException {
        File blockFile;
        log.debug2("requestId = {}", (Object)requestId);
        log.debug2("result = {}", (Object)result);
        log.debug2("parts = {}", parts);
        this.addResultPropertiesPart(requestId, result, parts);
        File recordFile = result.getRecordFile();
        if (recordFile != null && recordFile.exists() && recordFile.length() > 0L) {
            this.addFilePart(requestId + "-Record", recordFile, parts);
        }
        if ((blockFile = result.getBlockFile()) != null && blockFile.exists() && blockFile.length() > 0L) {
            this.addFilePart(requestId + "-Block", blockFile, parts);
        }
        log.debug2("Done");
    }

    private void addResultPropertiesPart(String partName, HasherResult result, MultiValueMap<String, HttpEntity<?>> parts) {
        File blockFile;
        log.debug2("partName = {}", (Object)partName);
        log.debug2("result = {}", (Object)result);
        log.debug2("parts = {}", parts);
        HashMap<String, Object> resultProperties = new HashMap<String, Object>();
        resultProperties.put("requestId", result.getRequestId());
        resultProperties.put("startTime", result.getStartTime());
        File recordFile = result.getRecordFile();
        if (recordFile != null && recordFile.exists() && recordFile.length() > 0L) {
            resultProperties.put("recordFileName", recordFile.getName());
        }
        if ((blockFile = result.getBlockFile()) != null && blockFile.exists() && blockFile.length() > 0L) {
            resultProperties.put("blockFileName", blockFile.getName());
        }
        resultProperties.put("errorMessage", result.getRunnerError());
        resultProperties.put("status", result.getRunnerStatus().toString());
        if (result.getHashResult() != null) {
            resultProperties.put("hashResult", result.getHashResult());
        }
        resultProperties.put("bytesHashed", result.getBytesHashed());
        resultProperties.put("filesHashed", result.getFilesHashed());
        resultProperties.put("elapsedTime", result.getElapsedTime());
        parts.add((Object)partName, (Object)new HttpEntity(resultProperties, (MultiValueMap)new HttpHeaders()));
    }

    void addFilePart(String partName, File sourceFile, MultiValueMap<String, HttpEntity<?>> parts) throws IOException {
        log.debug2("partName = {}", (Object)partName);
        log.debug2("sourceFile = {}", (Object)sourceFile);
        FileDataSource fileDS = new FileDataSource(sourceFile);
        String name = fileDS.getName();
        log.trace("name = {}", (Object)name);
        long size = fileDS.getFile().length();
        log.trace("size = {}", (Object)size);
        HttpHeaders partHeaders = new HttpHeaders();
        partHeaders.setContentLength(size);
        log.trace("partHeaders = {}", new Supplier[]{() -> partHeaders});
        NamedInputStreamResource resource = new NamedInputStreamResource(name, fileDS.getInputStream());
        parts.add((Object)partName, (Object)new HttpEntity((Object)resource, (MultiValueMap)partHeaders));
    }

    private ResponseEntity<MultiValueMap<String, HttpEntity<?>>> buildResponse(MultiValueMap<String, HttpEntity<?>> parts) {
        log.debug2("parts = {}", parts);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.MULTIPART_FORM_DATA);
        log.trace("responseHeaders = {}", new Supplier[]{() -> responseHeaders});
        HttpStatus status = HttpStatus.OK;
        log.trace("status = {}", new Supplier[]{() -> status});
        return new ResponseEntity(parts, (MultiValueMap)responseHeaders, (HttpStatusCode)status);
    }

    public ResponseEntity getPeers(String peerQuery) {
        log.debug2("peerQuery = {}", (Object)peerQuery);
        PeerHelper peerHelper = new PeerHelper();
        List results = null;
        try {
            String fullQuery = JosqlUtil.createFullQuery((String)peerQuery, (String)PeerHelper.SOURCE_FQCN, PeerHelper.PROPERTY_NAMES, (String)PeerHelper.RESULT_FQCN);
            log.trace("fullQuery = {}", (Object)fullQuery);
            Query q = new Query();
            try {
                q.parse(fullQuery);
                QueryResults qr = q.execute(peerHelper.createUniverse());
                results = qr.getResults();
                log.trace("results.size() = {}" + results.size());
                log.trace("results = {}", (Object)peerHelper.nonDefaultToString(results));
                return new ResponseEntity((Object)results, (HttpStatusCode)HttpStatus.OK);
            }
            catch (QueryExecutionException qee) {
                String message = "Cannot getPeers() for peerQuery = '" + peerQuery + "'";
                log.error(message, (Throwable)qee);
                return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        catch (Exception e) {
            String message = "Cannot getPeers() for peerQuery = '" + peerQuery + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity getPolls(String pollQuery) {
        log.debug("pollQuery = {}", (Object)pollQuery);
        PollHelper pollHelper = new PollHelper();
        List results = null;
        try {
            String fullQuery = JosqlUtil.createFullQuery((String)pollQuery, (String)PollHelper.SOURCE_FQCN, PollHelper.PROPERTY_NAMES, (String)PollHelper.RESULT_FQCN);
            log.trace("fullQuery = {}", (Object)fullQuery);
            Query q = new Query();
            try {
                q.parse(fullQuery);
                QueryResults qr = q.execute(pollHelper.createUniverse());
                results = qr.getResults();
                log.trace("results.size() = {}" + results.size());
                log.trace("results = {}", (Object)pollHelper.nonDefaultToString(results));
                return new ResponseEntity((Object)results, (HttpStatusCode)HttpStatus.OK);
            }
            catch (QueryExecutionException qee) {
                String message = "Cannot getPolls() for pollQuery = '" + pollQuery + "'";
                log.error(message, (Throwable)qee);
                return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        catch (Exception e) {
            String message = "Cannot getPolls() for pollQuery = '" + pollQuery + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity getRepositorySpaces(String repositorySpaceQuery) {
        log.debug2("repositorySpaceQuery = {}", (Object)repositorySpaceQuery);
        RepositorySpaceHelper repositorySpaceHelper = new RepositorySpaceHelper();
        List results = null;
        try {
            String fullQuery = JosqlUtil.createFullQuery((String)repositorySpaceQuery, (String)RepositorySpaceHelper.SOURCE_FQCN, RepositorySpaceHelper.PROPERTY_NAMES, (String)RepositorySpaceHelper.RESULT_FQCN);
            log.trace("fullQuery = {}", (Object)fullQuery);
            Query q = new Query();
            try {
                q.parse(fullQuery);
                QueryResults qr = q.execute(repositorySpaceHelper.createUniverse());
                results = qr.getResults();
                log.trace("results.size() = {}", (Object)results.size());
                log.trace("results = {}", (Object)repositorySpaceHelper.nonDefaultToString(results));
                return new ResponseEntity((Object)results, (HttpStatusCode)HttpStatus.OK);
            }
            catch (QueryExecutionException qee) {
                String message = "Cannot getRepositorySpaces() for repositorySpaceQuery = '" + repositorySpaceQuery + "'";
                log.error(message, (Throwable)qee);
                return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        catch (Exception e) {
            String message = "Cannot getRepositorySpaces() for repositorySpaceQuery = '" + repositorySpaceQuery + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity getVotes(String voteQuery) {
        log.debug2("voteQuery = {}", (Object)voteQuery);
        VoteHelper voteHelper = new VoteHelper();
        List results = null;
        try {
            String fullQuery = JosqlUtil.createFullQuery((String)voteQuery, (String)VoteHelper.SOURCE_FQCN, VoteHelper.PROPERTY_NAMES, (String)VoteHelper.RESULT_FQCN);
            log.trace("fullQuery = {}", (Object)fullQuery);
            Query q = new Query();
            try {
                q.parse(fullQuery);
                QueryResults qr = q.execute(voteHelper.createUniverse());
                results = qr.getResults();
                log.trace("results.size() = {}" + results.size());
                log.trace("results = {}", (Object)voteHelper.nonDefaultToString(results));
                return new ResponseEntity((Object)results, (HttpStatusCode)HttpStatus.OK);
            }
            catch (QueryExecutionException qee) {
                String message = "Cannot getVotes() for voteQuery = '" + voteQuery + "'";
                log.error(message, (Throwable)qee);
                return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        catch (Exception e) {
            String message = "Cannot getVotes() for voteQuery = '" + voteQuery + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

