/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.core.io.Resource;
import org.springframework.validation.annotation.Validated;

@Validated
public class AusImportBody {
    @JsonProperty(value="targetBaseUrlPath")
    private String targetBaseUrlPath = null;
    @JsonProperty(value="targetUrl")
    private String targetUrl = null;
    @JsonProperty(value="file")
    private Resource file = null;
    @JsonProperty(value="userProperties")
    @Valid
    private List<String> userProperties = null;

    public AusImportBody targetBaseUrlPath(String targetBaseUrlPath) {
        this.targetBaseUrlPath = targetBaseUrlPath;
        return this;
    }

    @Schema(required=true, description="The base URL path of the target AU")
    @NotNull
    public String getTargetBaseUrlPath() {
        return this.targetBaseUrlPath;
    }

    public void setTargetBaseUrlPath(String targetBaseUrlPath) {
        this.targetBaseUrlPath = targetBaseUrlPath;
    }

    public AusImportBody targetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
        return this;
    }

    @Schema(required=true, description="The target AU URL")
    @NotNull
    public String getTargetUrl() {
        return this.targetUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public AusImportBody file(Resource file) {
        this.file = file;
        return this;
    }

    @Schema(required=true, description="The content of the file to be imported")
    @NotNull
    @Valid
    public Resource getFile() {
        return this.file;
    }

    public void setFile(Resource file) {
        this.file = file;
    }

    public AusImportBody userProperties(List<String> userProperties) {
        this.userProperties = userProperties;
        return this;
    }

    public AusImportBody addUserPropertiesItem(String userPropertiesItem) {
        if (this.userProperties == null) {
            this.userProperties = new ArrayList<String>();
        }
        this.userProperties.add(userPropertiesItem);
        return this;
    }

    @Schema(description="The user-specified properties")
    public List<String> getUserProperties() {
        return this.userProperties;
    }

    public void setUserProperties(List<String> userProperties) {
        this.userProperties = userProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AusImportBody ausImportBody = (AusImportBody)o;
        return Objects.equals(this.targetBaseUrlPath, ausImportBody.targetBaseUrlPath) && Objects.equals(this.targetUrl, ausImportBody.targetUrl) && Objects.equals(this.file, ausImportBody.file) && Objects.equals(this.userProperties, ausImportBody.userProperties);
    }

    public int hashCode() {
        return Objects.hash(this.targetBaseUrlPath, this.targetUrl, this.file, this.userProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AusImportBody {\n");
        sb.append("    targetBaseUrlPath: ").append(this.toIndentedString(this.targetBaseUrlPath)).append("\n");
        sb.append("    targetUrl: ").append(this.toIndentedString(this.targetUrl)).append("\n");
        sb.append("    file: ").append(this.toIndentedString(this.file)).append("\n");
        sb.append("    userProperties: ").append(this.toIndentedString(this.userProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

