/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Schema(description="The information needed to page in a long list of data")
@Validated
public class PageDesc {
    @JsonProperty(value="page")
    private Integer page = null;
    @JsonProperty(value="size")
    private Integer size = null;
    @JsonProperty(value="total")
    private Integer total = null;
    @JsonProperty(value="prevPage")
    private String prevPage = null;
    @JsonProperty(value="nextPage")
    private String nextPage = null;

    public PageDesc page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(example="10", required=true, description="The page number")
    @NotNull
    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public PageDesc size(Integer size) {
        this.size = size;
        return this;
    }

    @Schema(example="5", required=true, description="The size or number of elements on a page")
    @NotNull
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public PageDesc total(Integer total) {
        this.total = total;
        return this;
    }

    @Schema(example="150", required=true, description="The mTotal number of elements.")
    @NotNull
    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public PageDesc prevPage(String prevPage) {
        this.prevPage = prevPage;
        return this;
    }

    @Schema(description="The url of the prev page of results or null")
    public String getPrevPage() {
        return this.prevPage;
    }

    public void setPrevPage(String prevPage) {
        this.prevPage = prevPage;
    }

    public PageDesc nextPage(String nextPage) {
        this.nextPage = nextPage;
        return this;
    }

    @Schema(description="The url to the next page of results or null.")
    public String getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(String nextPage) {
        this.nextPage = nextPage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageDesc pageDesc = (PageDesc)o;
        return Objects.equals(this.page, pageDesc.page) && Objects.equals(this.size, pageDesc.size) && Objects.equals(this.total, pageDesc.total) && Objects.equals(this.prevPage, pageDesc.prevPage) && Objects.equals(this.nextPage, pageDesc.nextPage);
    }

    public int hashCode() {
        return Objects.hash(this.page, this.size, this.total, this.prevPage, this.nextPage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PageDesc {\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    prevPage: ").append(this.toIndentedString(this.prevPage)).append("\n");
        sb.append("    nextPage: ").append(this.toIndentedString(this.nextPage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

