/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.lockss.laaws.poller.model.LinkDesc;
import org.springframework.validation.annotation.Validated;

@Schema(description="A summary of a poll in which we are the poller.")
@Validated
public class PollerSummary {
    @JsonProperty(value="auId")
    private String auId = null;
    @JsonProperty(value="variant")
    private String variant = null;
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="participants")
    private Integer participants = null;
    @JsonProperty(value="numTalliedUrls")
    private Integer numTalliedUrls = null;
    @JsonProperty(value="numHashErrors")
    private Integer numHashErrors = null;
    @JsonProperty(value="numCompletedRepairs")
    private Integer numCompletedRepairs = null;
    @JsonProperty(value="numAgreeUrls")
    private Integer numAgreeUrls = null;
    @JsonProperty(value="start")
    private Long start = null;
    @JsonProperty(value="deadline")
    private Long deadline = null;
    @JsonProperty(value="pollEnd")
    private Long pollEnd = null;
    @JsonProperty(value="pollKey")
    private String pollKey = null;
    @JsonProperty(value="detailLink")
    private LinkDesc detailLink = null;

    public PollerSummary auId(String auId) {
        this.auId = auId;
        return this;
    }

    @Schema(required=true, description="The id for the au being polled.")
    @NotNull
    public String getAuId() {
        return this.auId;
    }

    public void setAuId(String auId) {
        this.auId = auId;
    }

    public PollerSummary variant(String variant) {
        this.variant = variant;
        return this;
    }

    @Schema(required=true, description="The V3 Poll variant.")
    @NotNull
    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public PollerSummary status(String status) {
        this.status = status;
        return this;
    }

    @Schema(required=true, description="The current status of the poll.")
    @NotNull
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public PollerSummary participants(Integer participants) {
        this.participants = participants;
        return this;
    }

    @Schema(description="The number of participants voting.")
    public Integer getParticipants() {
        return this.participants;
    }

    public void setParticipants(Integer participants) {
        this.participants = participants;
    }

    public PollerSummary numTalliedUrls(Integer numTalliedUrls) {
        this.numTalliedUrls = numTalliedUrls;
        return this;
    }

    @Schema(description="The number of tallied urls.")
    public Integer getNumTalliedUrls() {
        return this.numTalliedUrls;
    }

    public void setNumTalliedUrls(Integer numTalliedUrls) {
        this.numTalliedUrls = numTalliedUrls;
    }

    public PollerSummary numHashErrors(Integer numHashErrors) {
        this.numHashErrors = numHashErrors;
        return this;
    }

    @Schema(description="The number of hash errors.")
    public Integer getNumHashErrors() {
        return this.numHashErrors;
    }

    public void setNumHashErrors(Integer numHashErrors) {
        this.numHashErrors = numHashErrors;
    }

    public PollerSummary numCompletedRepairs(Integer numCompletedRepairs) {
        this.numCompletedRepairs = numCompletedRepairs;
        return this;
    }

    @Schema(description="The number of completed repairs.")
    public Integer getNumCompletedRepairs() {
        return this.numCompletedRepairs;
    }

    public void setNumCompletedRepairs(Integer numCompletedRepairs) {
        this.numCompletedRepairs = numCompletedRepairs;
    }

    public PollerSummary numAgreeUrls(Integer numAgreeUrls) {
        this.numAgreeUrls = numAgreeUrls;
        return this;
    }

    @Schema(description="The number of urls with agreement.")
    public Integer getNumAgreeUrls() {
        return this.numAgreeUrls;
    }

    public void setNumAgreeUrls(Integer numAgreeUrls) {
        this.numAgreeUrls = numAgreeUrls;
    }

    public PollerSummary start(Long start) {
        this.start = start;
        return this;
    }

    @Schema(required=true, description="The timestamp for when the poll started.")
    @NotNull
    public Long getStart() {
        return this.start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public PollerSummary deadline(Long deadline) {
        this.deadline = deadline;
        return this;
    }

    @Schema(required=true, description="The deadline for voting in this poll.")
    @NotNull
    public Long getDeadline() {
        return this.deadline;
    }

    public void setDeadline(Long deadline) {
        this.deadline = deadline;
    }

    public PollerSummary pollEnd(Long pollEnd) {
        this.pollEnd = pollEnd;
        return this;
    }

    @Schema(description="The time at which the poll ended.")
    public Long getPollEnd() {
        return this.pollEnd;
    }

    public void setPollEnd(Long pollEnd) {
        this.pollEnd = pollEnd;
    }

    public PollerSummary pollKey(String pollKey) {
        this.pollKey = pollKey;
        return this;
    }

    @Schema(required=true, description="Key generated by poll manager when poll was created.")
    @NotNull
    public String getPollKey() {
        return this.pollKey;
    }

    public void setPollKey(String pollKey) {
        this.pollKey = pollKey;
    }

    public PollerSummary detailLink(LinkDesc detailLink) {
        this.detailLink = detailLink;
        return this;
    }

    @Schema(description="")
    @Valid
    public LinkDesc getDetailLink() {
        return this.detailLink;
    }

    public void setDetailLink(LinkDesc detailLink) {
        this.detailLink = detailLink;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PollerSummary pollerSummary = (PollerSummary)o;
        return Objects.equals(this.auId, pollerSummary.auId) && Objects.equals(this.variant, pollerSummary.variant) && Objects.equals(this.status, pollerSummary.status) && Objects.equals(this.participants, pollerSummary.participants) && Objects.equals(this.numTalliedUrls, pollerSummary.numTalliedUrls) && Objects.equals(this.numHashErrors, pollerSummary.numHashErrors) && Objects.equals(this.numCompletedRepairs, pollerSummary.numCompletedRepairs) && Objects.equals(this.numAgreeUrls, pollerSummary.numAgreeUrls) && Objects.equals(this.start, pollerSummary.start) && Objects.equals(this.deadline, pollerSummary.deadline) && Objects.equals(this.pollEnd, pollerSummary.pollEnd) && Objects.equals(this.pollKey, pollerSummary.pollKey) && Objects.equals(this.detailLink, pollerSummary.detailLink);
    }

    public int hashCode() {
        return Objects.hash(this.auId, this.variant, this.status, this.participants, this.numTalliedUrls, this.numHashErrors, this.numCompletedRepairs, this.numAgreeUrls, this.start, this.deadline, this.pollEnd, this.pollKey, this.detailLink);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PollerSummary {\n");
        sb.append("    auId: ").append(this.toIndentedString(this.auId)).append("\n");
        sb.append("    variant: ").append(this.toIndentedString(this.variant)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    participants: ").append(this.toIndentedString(this.participants)).append("\n");
        sb.append("    numTalliedUrls: ").append(this.toIndentedString(this.numTalliedUrls)).append("\n");
        sb.append("    numHashErrors: ").append(this.toIndentedString(this.numHashErrors)).append("\n");
        sb.append("    numCompletedRepairs: ").append(this.toIndentedString(this.numCompletedRepairs)).append("\n");
        sb.append("    numAgreeUrls: ").append(this.toIndentedString(this.numAgreeUrls)).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    pollEnd: ").append(this.toIndentedString(this.pollEnd)).append("\n");
        sb.append("    pollKey: ").append(this.toIndentedString(this.pollKey)).append("\n");
        sb.append("    detailLink: ").append(this.toIndentedString(this.detailLink)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

