/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.client;

import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.lockss.laaws.rs.client.LockssRepositoryClient;
import org.lockss.laaws.rs.io.index.ArtifactIndex;
import org.lockss.laaws.rs.io.index.VolatileArtifactIndex;
import org.lockss.laaws.rs.io.storage.ArtifactStore;
import org.lockss.laaws.rs.io.storage.mock.VolatileWARCArtifactStore;
import org.lockss.laaws.rs.model.Artifact;
import org.lockss.laaws.rs.model.ArtifactIndexData;
import org.springframework.web.util.UriComponentsBuilder;

public class LocalLockssRepositoryClient
implements LockssRepositoryClient {
    private static final Log log = LogFactory.getLog(LocalLockssRepositoryClient.class);
    private ArtifactStore store = null;
    private ArtifactIndex index = null;

    public LocalLockssRepositoryClient() {
        this((ArtifactIndex)new VolatileArtifactIndex(), (ArtifactStore)new VolatileWARCArtifactStore());
    }

    public LocalLockssRepositoryClient(ArtifactIndex index, ArtifactStore store) {
        this.index = index;
        this.store = store;
    }

    @Override
    public String addArtifact(Artifact artifact) throws IOException {
        this.store.addArtifact(artifact);
        ArtifactIndexData indexData = this.index.indexArtifact(artifact);
        return indexData.getId();
    }

    @Override
    public Artifact getArtifact(String collection, String artifactId) throws IOException {
        return this.store.getArtifact(this.index.getArtifactIndexData(artifactId));
    }

    @Override
    public ArtifactIndexData commitArtifact(String collection, String artifactId) throws IOException {
        ArtifactIndexData indexData = this.index.getArtifactIndexData(artifactId);
        Artifact artifact = this.store.getArtifact(indexData);
        this.store.updateArtifact(indexData, artifact);
        return this.index.commitArtifact(artifactId);
    }

    @Override
    public void deleteArtifact(String collection, String artifactId) throws IOException {
        this.store.deleteArtifact(this.index.getArtifactIndexData(artifactId));
        this.index.deleteArtifact(artifactId);
    }

    @Override
    public Iterator<String> getCollections() {
        return this.index.getCollectionIds();
    }

    @Override
    public Iterator<ArtifactIndexData> queryArtifacts(UriComponentsBuilder builder) {
        return null;
    }

    @Override
    public Iterator<ArtifactIndexData> getArtifactsInAU(String collection, String auid) {
        return null;
    }

    @Override
    public Iterator<ArtifactIndexData> getArtifactsWithUriPrefix(String collection, String uri) {
        return null;
    }

    @Override
    public Iterator<ArtifactIndexData> getArtifactsWithUriPrefix(String collection, String auid, String prefix) {
        return null;
    }
}

