/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.lockss.laaws.rs.client.LockssRepositoryClient;
import org.lockss.laaws.rs.model.Artifact;
import org.lockss.laaws.rs.model.ArtifactIdentifier;
import org.lockss.laaws.rs.model.ArtifactIndexData;
import org.lockss.laaws.rs.util.ArtifactFactory;
import org.lockss.laaws.rs.util.ArtifactUtil;
import org.lockss.laaws.rs.util.NamedInputStreamResource;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class RestLockssRepositoryClient
implements LockssRepositoryClient {
    private static final Log log = LogFactory.getLog(RestLockssRepositoryClient.class);
    private final String SEPERATOR = "/";
    private final String COLLECTION_BASE = "/repos";
    private final String ARTIFACT_BASE = "/artifacts";
    private RestTemplate restTemplate;
    private URL repositoryUrl;

    public RestLockssRepositoryClient(URL repositoryUrl) {
        this(repositoryUrl, new RestTemplate());
    }

    public RestLockssRepositoryClient(URL repositoryUrl, RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        this.repositoryUrl = repositoryUrl;
    }

    private String buildEndpoint(String collection) {
        StringBuilder endpoint = new StringBuilder();
        endpoint.append(this.repositoryUrl);
        endpoint.append("/repos").append("/").append(collection).append("/artifacts");
        return endpoint.toString();
    }

    private String buildEndpoint(String collection, String artifactId) {
        StringBuilder endpoint = new StringBuilder();
        endpoint.append(this.buildEndpoint(collection));
        endpoint.append("/").append(artifactId);
        return endpoint.toString();
    }

    @Override
    public Iterator<String> getCollections() {
        ResponseEntity response = this.restTemplate.exchange(this.repositoryUrl.toString() + "/repos", HttpMethod.GET, null, List.class, new Object[0]);
        return ((List)response.getBody()).iterator();
    }

    @Override
    public String addArtifact(Artifact artifact) throws IOException {
        ArtifactIdentifier identifier = artifact.getIdentifier();
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        parts.add((Object)"auid", (Object)identifier.getAuid());
        parts.add((Object)"uri", (Object)identifier.getUri());
        parts.add((Object)"version", (Object)1);
        HttpHeaders artifactPartHeaders = new HttpHeaders();
        artifactPartHeaders.setContentLength(0L);
        artifactPartHeaders.setContentType(MediaType.valueOf((String)"application/http;msgtype=response"));
        try {
            NamedInputStreamResource artifactPartResource = new NamedInputStreamResource("artifact", ArtifactUtil.getHttpResponseStreamFromArtifact((Artifact)artifact));
            parts.add((Object)"artifact", (Object)new HttpEntity((Object)artifactPartResource, (MultiValueMap)artifactPartHeaders));
        }
        catch (HttpException e) {
            throw new IOException(e);
        }
        HttpEntity multipartEntity = new HttpEntity((Object)parts, null);
        return (String)this.restTemplate.exchange(this.buildEndpoint(identifier.getCollection()), HttpMethod.POST, multipartEntity, String.class, new Object[0]).getBody();
    }

    @Override
    public Artifact getArtifact(String collection, String artifactId) throws IOException {
        ResponseEntity response = this.restTemplate.exchange(this.buildEndpoint(collection, artifactId), HttpMethod.GET, null, Resource.class, new Object[0]);
        return ArtifactFactory.fromHttpResponseStream((InputStream)((Resource)response.getBody()).getInputStream());
    }

    @Override
    public ArtifactIndexData commitArtifact(String collection, String artifactId) {
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        parts.add((Object)"committed", (Object)true);
        return this.updateArtifact(collection, artifactId, (MultiValueMap)parts);
    }

    private ArtifactIndexData updateArtifact(String collection, String artifactId, MultiValueMap parts) {
        HttpEntity requestEntity = new HttpEntity((Object)parts, null);
        return (ArtifactIndexData)this.restTemplate.exchange(this.buildEndpoint(collection, artifactId), HttpMethod.PUT, requestEntity, ArtifactIndexData.class, new Object[0]).getBody();
    }

    @Override
    public void deleteArtifact(String collection, String artifactId) {
        ResponseEntity response = this.restTemplate.exchange(this.buildEndpoint(collection, artifactId), HttpMethod.DELETE, null, Integer.class, new Object[0]);
    }

    @Override
    public Iterator<ArtifactIndexData> queryArtifacts(UriComponentsBuilder builder) {
        ResponseEntity response = this.restTemplate.exchange(builder.build().encode().toUri(), HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<ArtifactIndexData>>(){});
        List responseBody = (List)response.getBody();
        return responseBody.iterator();
    }

    @Override
    public Iterator<ArtifactIndexData> getArtifactsInAU(String collection, String auid) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.buildEndpoint(collection)).queryParam("auid", new Object[]{auid});
        return this.queryArtifacts(builder);
    }

    @Override
    public Iterator<ArtifactIndexData> getArtifactsWithUriPrefix(String collection, String uri) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.buildEndpoint(collection)).queryParam("uri", new Object[]{uri});
        return this.queryArtifacts(builder);
    }

    @Override
    public Iterator<ArtifactIndexData> getArtifactsWithUriPrefix(String collection, String auid, String prefix) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.buildEndpoint(collection)).queryParam("uri", new Object[]{prefix}).queryParam("auid", new Object[]{auid});
        return this.queryArtifacts(builder);
    }
}

