/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.client;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.archive.io.ArchiveRecord;
import org.archive.io.ArchiveRecordHeader;
import org.archive.io.warc.WARCReaderFactory;
import org.lockss.laaws.rs.core.RestLockssRepository;
import org.lockss.laaws.rs.model.Artifact;
import org.lockss.laaws.rs.model.ArtifactData;
import org.lockss.laaws.rs.model.ArtifactIdentifier;
import org.lockss.laaws.rs.util.ArtifactDataFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class WARCImporter {
    private static final Log log = LogFactory.getLog(WARCImporter.class);
    private static RestLockssRepository repo;

    public static void importWARC(File warc, String collection, String auid) throws IOException, HttpException {
        LinkedList<String> artifactIds = new LinkedList<String>();
        for (ArchiveRecord record : WARCReaderFactory.get((File)warc)) {
            ArchiveRecordHeader headers = record.getHeader();
            String recordType = (String)headers.getHeaderValue("WARC-Type");
            log.info((Object)String.format("Importing WARC record (ID: %s, type: %s), headers: %s", record.getHeader().getHeaderValue("WARC-Record-ID"), recordType, record.getHeader()));
            ArtifactData artifactData = ArtifactDataFactory.fromArchiveRecord((ArchiveRecord)record);
            if (artifactData == null) continue;
            Integer version = -1;
            String versionHeader = headers.getVersion();
            if (versionHeader != null && !versionHeader.isEmpty()) {
                version = Integer.valueOf(versionHeader);
            }
            ArtifactIdentifier identifier = new ArtifactIdentifier(collection, auid, headers.getUrl(), version);
            artifactData.setIdentifier(identifier);
            Artifact artifact = repo.addArtifact(artifactData);
            String artifactId = artifact.getId();
            repo.commitArtifact(collection, artifactId);
            artifactIds.add(artifactId);
        }
        for (String string : artifactIds) {
        }
    }

    public static void main(String[] args) throws ParseException, MalformedURLException {
        Options options = new Options();
        options.addOption("r", "repository", true, "Target repository URL");
        options.addOption("c", "collection", true, "Target collection ID");
        options.addOption("a", "auid", true, "Archival Unit ID (AUID)");
        CommandLine cmd = new PosixParser().parse(options, args);
        if (cmd.hasOption("auid")) {
            log.info((Object)("Forcing AUID of WARC records to: " + cmd.getOptionValue("auid")));
        }
        repo = new RestLockssRepository(new URL(cmd.getOptionValue("repository")));
        List warcs = cmd.getArgList();
        for (String warc : warcs) {
            try {
                WARCImporter.importWARC((File)new File(warc), (String)cmd.getOptionValue("collection"), (String)cmd.getOptionValue("auid"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (HttpException e) {
                e.printStackTrace();
            }
        }
    }
}

