/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.client;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.util.Supplier;
import org.archive.io.ArchiveRecord;
import org.archive.io.ArchiveRecordHeader;
import org.archive.io.warc.WARCReaderFactory;
import org.lockss.laaws.rs.core.LocalLockssRepository;
import org.lockss.laaws.rs.core.LockssRepository;
import org.lockss.laaws.rs.core.RestLockssRepository;
import org.lockss.laaws.rs.model.Artifact;
import org.lockss.laaws.rs.model.ArtifactData;
import org.lockss.laaws.rs.model.ArtifactIdentifier;
import org.lockss.laaws.rs.util.ArtifactDataFactory;
import org.lockss.log.L4JLogger;

public class WARCImporter {
    private static final L4JLogger log = L4JLogger.getLogger();
    private LockssRepository repository;
    private String collection;
    private String auid;

    public WARCImporter(LockssRepository repository, String collection, String auid) {
        this.repository = repository;
        this.collection = collection;
        this.auid = auid;
    }

    public WARCImporter(File repoDir, String persistedIndexName, String collection, String auid) throws IOException {
        this((LockssRepository)new LocalLockssRepository(repoDir, persistedIndexName), collection, auid);
    }

    public WARCImporter(URL url, String collection, String auid) {
        this((LockssRepository)new RestLockssRepository(url), collection, auid);
    }

    public static void main(String[] args) throws ParseException, MalformedURLException, IOException {
        log.debug2("args: {}", new Supplier[]{() -> Arrays.asList(args)});
        Options options = new Options();
        options.addOption("l", "localRepository", true, "Target local repository URL");
        options.addOption("r", "restRepository", true, "Target repository URL");
        options.addOption("c", "collection", true, "Target collection ID");
        options.addOption("a", "auid", true, "Archival Unit ID (AUID)");
        CommandLine cmd = new DefaultParser().parse(options, args);
        String auid = null;
        if (cmd.hasOption("auid")) {
            auid = cmd.getOptionValue("auid");
            log.trace("Forcing AUID of WARC records to: {}", (Object)auid);
        }
        String collection = cmd.getOptionValue("collection");
        log.trace("collection: {}", (Object)collection);
        WARCImporter warcImporter = null;
        if (cmd.hasOption("restRepository")) {
            String restServiceUrlSpec = cmd.getOptionValue("restRepository");
            log.trace("Using the REST Service at: {}", (Object)restServiceUrlSpec);
            warcImporter = new WARCImporter(new URL(restServiceUrlSpec), collection, auid);
        } else if (cmd.hasOption("localRepository")) {
            String localRepoDir = cmd.getOptionValue("localRepository");
            log.trace("Using the local directory: {}", (Object)localRepoDir);
            warcImporter = new WARCImporter(new File(localRepoDir), "artifact-index.ser", collection, auid);
        } else {
            log.error("No repository data found: Either a -l or a -r option must be specified");
            System.exit(1);
        }
        List warcs = cmd.getArgList();
        log.trace("warcs: {}", new Supplier[]{() -> warcs});
        for (String warc : warcs) {
            log.trace("warc: {}", (Object)warc);
            try {
                warcImporter.importWARC(new File(warc));
            }
            catch (IOException ioe) {
                log.error("importWARC failed", (Throwable)ioe);
            }
        }
    }

    public LockssRepository importWARC(File warc) throws IOException {
        log.debug2("warc: {}", new Supplier[]{() -> warc});
        log.debug2("collection: {}", (Object)this.collection);
        log.debug2("auid: {}", (Object)this.auid);
        int processedCount = 0;
        int importedCount = 0;
        int ignoredCount = 0;
        for (ArchiveRecord record : WARCReaderFactory.get((File)warc)) {
            ArchiveRecordHeader headers = record.getHeader();
            String recordType = (String)headers.getHeaderValue("WARC-Type");
            log.trace(String.format("Importing WARC record (ID: %s, type: %s), headers: %s", record.getHeader().getHeaderValue("WARC-Record-ID"), recordType, record.getHeader()));
            ArtifactData artifactData = ArtifactDataFactory.fromArchiveRecord((ArchiveRecord)record);
            log.trace("artifactData: {}", new Supplier[]{() -> artifactData});
            if (artifactData != null) {
                Integer version = -1;
                String versionHeader = headers.getVersion();
                log.trace("versionHeader: {}", (Object)versionHeader);
                if (versionHeader != null && !versionHeader.isEmpty()) {
                    version = Integer.valueOf(versionHeader);
                }
                log.trace("version: {}", (Object)version);
                ArtifactIdentifier identifier = new ArtifactIdentifier(this.collection, this.auid, headers.getUrl(), version);
                log.trace("identifier: {}", new Supplier[]{() -> identifier});
                artifactData.setIdentifier(identifier);
                Artifact artifact = this.repository.addArtifact(artifactData);
                log.debug("Uploaded artifact: {}", new Supplier[]{() -> artifact});
                String artifactId = artifact.getId();
                this.repository.commitArtifact(this.collection, artifactId);
                log.info("Committed artifactId: {}", (Object)artifactId);
                ++importedCount;
            } else {
                log.debug("WARC record {} ignored", new Supplier[]{() -> headers});
                ++ignoredCount;
            }
            ++processedCount;
        }
        log.info(String.format("WARC File %s processing completed: %d processed, %d imported, %d ignored.", warc, processedCount, importedCount, ignoredCount));
        return this.repository;
    }

    public LockssRepository getRepository() {
        return this.repository;
    }
}

