/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.model;

import java.io.InputStream;
import org.apache.http.StatusLine;
import org.lockss.laaws.rs.model.ArtifactIdentifier;
import org.springframework.http.HttpHeaders;

public class Artifact
implements Comparable<Artifact> {
    private ArtifactIdentifier identifier;
    private HttpHeaders artifactMetadata;
    private InputStream artifactStream;
    private StatusLine httpStatus;

    public Artifact(HttpHeaders artifactMetadata, InputStream inputStream, StatusLine httpStatus) {
        this(null, artifactMetadata, inputStream, httpStatus);
    }

    public Artifact(ArtifactIdentifier identifier, HttpHeaders artifactMetadata, InputStream inputStream, StatusLine httpStatus) {
        this.identifier = identifier;
        this.artifactMetadata = artifactMetadata;
        this.artifactStream = inputStream;
        this.httpStatus = httpStatus;
    }

    public HttpHeaders getMetadata() {
        return this.artifactMetadata;
    }

    public InputStream getInputStream() {
        return this.artifactStream;
    }

    public StatusLine getHttpStatus() {
        return this.httpStatus;
    }

    public ArtifactIdentifier getIdentifier() {
        return this.identifier;
    }

    public Artifact setIdentifier(ArtifactIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    @Override
    public int compareTo(Artifact other) {
        return this.getIdentifier().compareTo(other.getIdentifier());
    }
}

