/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.util;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.entity.LaxContentLengthStrategy;
import org.apache.http.impl.io.DefaultHttpResponseParser;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.impl.io.IdentityInputStream;
import org.apache.http.impl.io.SessionInputBufferImpl;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.message.BasicStatusLine;
import org.archive.format.warc.WARCConstants;
import org.archive.io.ArchiveRecord;
import org.archive.io.ArchiveRecordHeader;
import org.lockss.laaws.rs.model.Artifact;
import org.lockss.laaws.rs.model.ArtifactIdentifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;

public class ArtifactFactory {
    private static final Log log = LogFactory.getLog(ArtifactFactory.class);
    private static final String RESPONSE_TYPE = WARCConstants.WARCRecordType.response.toString();
    private static final String RESOURCE_TYPE = WARCConstants.WARCRecordType.resource.toString();

    public static Artifact fromHttpResponseStream(InputStream responseStream) throws IOException {
        return ArtifactFactory.fromHttpResponseStream(null, responseStream);
    }

    public static Artifact fromHttpResponseStream(HttpHeaders additionalMetadata, InputStream responseStream) throws IOException {
        SessionInputBufferImpl buffer = new SessionInputBufferImpl(new HttpTransportMetricsImpl(), 4096);
        buffer.bind(responseStream);
        try {
            BasicHttpEntity responseEntity = new BasicHttpEntity();
            HttpResponse response = (HttpResponse)new DefaultHttpResponseParser((SessionInputBuffer)buffer).parse();
            long len = new LaxContentLengthStrategy().determineLength((HttpMessage)response);
            responseEntity.setContentLength(len);
            responseEntity.setContent((InputStream)new IdentityInputStream((SessionInputBuffer)buffer));
            response.setEntity((HttpEntity)responseEntity);
            if (additionalMetadata != null) {
                additionalMetadata.forEach((headerName, headerValues) -> headerValues.forEach(headerValue -> response.setHeader(headerName, headerValue)));
            }
            return ArtifactFactory.fromHttpResponse(response);
        }
        catch (HttpException e) {
            log.error((Object)String.format("An error occurred while attempting to parse a stream as a HTTP response: %s", new Object[]{e}));
            throw new IOException(e);
        }
    }

    public static Artifact fromHttpResponse(HttpResponse response) throws IOException {
        HttpHeaders headers = ArtifactFactory.transformHeaderArrayToHttpHeaders(response.getAllHeaders());
        return new Artifact(ArtifactFactory.buildArtifactIdentifier(headers), headers, response.getEntity().getContent(), response.getStatusLine());
    }

    private static ArtifactIdentifier buildArtifactIdentifier(HttpHeaders headers) {
        return new ArtifactIdentifier(ArtifactFactory.getHeaderValue(headers, "X-Lockss-Collection"), ArtifactFactory.getHeaderValue(headers, "X-Lockss-AuId"), ArtifactFactory.getHeaderValue(headers, "X-Lockss-Uri"), ArtifactFactory.getHeaderValue(headers, "X-Lockss-Version"));
    }

    private static String getHeaderValue(HttpHeaders headers, String key) {
        List values = headers.get((Object)key);
        if (values != null && !values.isEmpty()) {
            if (values.stream().allMatch(((String)values.get(0))::equals)) {
                return (String)values.get(0);
            }
        }
        return null;
    }

    private static HttpHeaders transformHeaderArrayToHttpHeaders(Header[] headerArray) {
        HttpHeaders headers = new HttpHeaders();
        for (Header header : headerArray) {
            headers.add(header.getName(), header.getValue());
        }
        return headers;
    }

    public static Artifact fromResource(InputStream resourceStream) {
        return ArtifactFactory.fromResourceStream(null, resourceStream);
    }

    public static Artifact fromResourceStream(HttpHeaders metadata, InputStream resourceStream) {
        BasicStatusLine responseStatus = new BasicStatusLine(new ProtocolVersion("HTTP", 1, 1), 200, "OK");
        return ArtifactFactory.fromResourceStream(metadata, resourceStream, (StatusLine)responseStatus);
    }

    public static Artifact fromResourceStream(HttpHeaders metadata, InputStream resourceStream, StatusLine responseStatus) {
        return new Artifact(metadata, resourceStream, responseStatus);
    }

    public static Artifact fromArchiveRecord(ArchiveRecord record) throws IOException {
        ArchiveRecordHeader headers = record.getHeader();
        String recordType = (String)headers.getHeaderValue("WARC-Type");
        HttpHeaders metadata = new HttpHeaders();
        if (recordType.equals(RESPONSE_TYPE)) {
            if (!headers.getMimetype().startsWith("application/http")) {
                log.warn((Object)String.format("Unexpected content MIME type (%s) from a WARC response record", headers.getMimetype()));
                return null;
            }
            return ArtifactFactory.fromHttpResponseStream(metadata, (InputStream)record);
        }
        if (recordType.equals(RESOURCE_TYPE)) {
            metadata.setContentLength((long)((int)headers.getContentLength()));
            metadata.setContentType(MediaType.valueOf((String)headers.getMimetype()));
            TemporalAccessor t = DateTimeFormatter.ISO_INSTANT.parse(headers.getDate());
            metadata.setDate(ZonedDateTime.ofInstant(Instant.from(t), ZoneOffset.UTC).toEpochSecond());
            metadata.add("X-Lockss-Origin", "warc");
            return ArtifactFactory.fromResourceStream(metadata, (InputStream)record);
        }
        log.warn((Object)String.format("Skipped WARC record %s because it was of type %s", record.getHeader().getHeaderValue("WARC-Record-ID"), recordType));
        return null;
    }
}

