/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.HashSet;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.io.DefaultHttpResponseWriter;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.impl.io.SessionOutputBufferImpl;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.lockss.laaws.rs.model.Artifact;
import org.lockss.laaws.rs.model.ArtifactIdentifier;

public class ArtifactUtil {
    private static final Log log = LogFactory.getLog(ArtifactUtil.class);

    public static InputStream getHttpResponseStreamFromArtifact(Artifact artifact) throws IOException, HttpException {
        return ArtifactUtil.getHttpResponseStreamFromHttpResponse(ArtifactUtil.getHttpResponseFromArtifact(artifact));
    }

    public static HttpResponse getHttpResponseFromArtifact(Artifact artifact) throws HttpException, IOException {
        BasicHttpResponse response = new BasicHttpResponse(artifact.getHttpStatus());
        response.setEntity((HttpEntity)new InputStreamEntity(artifact.getInputStream()));
        if (artifact.getMetadata() != null) {
            artifact.getMetadata().forEach((headerName, headerValues) -> headerValues.forEach(headerValue -> response.setHeader(headerName, headerValue)));
        }
        if (artifact.getIdentifier() != null) {
            response.setHeaders(ArtifactUtil.getArtifactIdentifierHeaders(artifact));
        }
        return response;
    }

    private static Header[] getArtifactIdentifierHeaders(Artifact artifact) {
        ArtifactIdentifier id = artifact.getIdentifier();
        HashSet<BasicHeader> headers = new HashSet<BasicHeader>();
        headers.add(new BasicHeader("X-Lockss-Collection", id.getCollection()));
        headers.add(new BasicHeader("X-Lockss-AuId", id.getAuid()));
        headers.add(new BasicHeader("X-Lockss-Uri", id.getUri()));
        headers.add(new BasicHeader("X-Lockss-Version", id.getVersion()));
        return headers.toArray(new Header[headers.size()]);
    }

    public static InputStream getHttpResponseStreamFromHttpResponse(HttpResponse response) throws IOException {
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(16384, "artifact-dfos", null, new File("/tmp"));
        SessionOutputBufferImpl outputBuffer = new SessionOutputBufferImpl(new HttpTransportMetricsImpl(), 4096);
        outputBuffer.bind((OutputStream)dfos);
        ArtifactUtil.writeHttpResponseHeader(response, outputBuffer);
        outputBuffer.flush();
        InputStream headerStream = dfos.isInMemory() ? new ByteArrayInputStream(dfos.getData()) : new FileInputStream(dfos.getFile());
        return new SequenceInputStream(headerStream, response.getEntity().getContent());
    }

    public static void writeHttpResponseStream(Artifact artifact, OutputStream output) throws IOException, HttpException {
        ArtifactUtil.writeHttpResponse(ArtifactUtil.getHttpResponseFromArtifact(artifact), output);
    }

    public static void writeHttpResponseHeader(HttpResponse response, SessionOutputBufferImpl outputBuffer) throws IOException {
        try {
            DefaultHttpResponseWriter responseWriter = new DefaultHttpResponseWriter((SessionOutputBuffer)outputBuffer);
            responseWriter.write((HttpMessage)response);
        }
        catch (HttpException e) {
            log.error((Object)"Caught HttpException while attempting to write the headers of an HttpResponse using DefaultHttpResponseWriter");
            throw new IOException(e);
        }
    }

    public static void writeHttpResponse(HttpResponse response, OutputStream output) throws IOException {
        SessionOutputBufferImpl outputBuffer = new SessionOutputBufferImpl(new HttpTransportMetricsImpl(), 4096);
        outputBuffer.bind(output);
        ArtifactUtil.writeHttpResponseHeader(response, outputBuffer);
        outputBuffer.flush();
        response.getEntity().writeTo(output);
        output.flush();
    }
}

