/*
 * Copyright (c) 2017, Board of Trustees of Leland Stanford Jr. University,
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation and/or
 * other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its contributors
 * may be used to endorse or promote products derived from this software without
 * specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.lockss.laaws.rs.io.index;

import org.lockss.laaws.rs.model.Artifact;
import org.lockss.laaws.rs.model.ArtifactIndexData;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public interface ArtifactIndex {
    ArtifactIndexData indexArtifact(Artifact artifact);
    ArtifactIndexData getArtifactIndexData(String indexDataId);
    ArtifactIndexData getArtifactIndexData(UUID indexDataId);
    ArtifactIndexData commitArtifact(String indexDataId);
    ArtifactIndexData commitArtifact(UUID indexDataId);
    void deleteArtifact(String indexDataId);
    void deleteArtifact(UUID indexDataId);

    boolean artifactExists(String artifactId);
    Iterator<String> getCollectionIds();
    Map<String, List<ArtifactIndexData>> getAus(String collection);
    Iterator<ArtifactIndexData> getArtifactsInAU(String collection, String auid);
    Iterator<ArtifactIndexData> getArtifactsinAUWithURL(String collection, String auid, String prefix);

    Iterator<ArtifactIndexData> query(ArtifactPredicateBuilder query);
}
