/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.List;
import org.lockss.laaws.rs.io.index.solr.SolrArtifactIndexData;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@Api(value="repos", description="the repos API")
public interface ReposApi {
    @ApiOperation(value="Get the list of repos", notes="", response=String.class, responseContainer="List", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Status 200", response=String.class, responseContainer="List")})
    @RequestMapping(value={"/repos"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<String>> reposGet();

    @ApiOperation(value="Delete artifact", notes="", response=Void.class, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully removed artifact", response=Void.class), @ApiResponse(code=401, message="Unauthorized client", response=Void.class), @ApiResponse(code=403, message="Client not authorized to delete artifact", response=Void.class), @ApiResponse(code=404, message="Artifact not found", response=Void.class), @ApiResponse(code=409, message="Cannot delete committed artifact", response=Void.class)})
    @RequestMapping(value={"/repos/{repository}/artifacts/{artifactid}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> reposArtifactsArtifactidDelete(@ApiParam(value="Repository to add artifact into", required=true) @PathVariable(value="repository") String var1, @ApiParam(value="Artifact ID", required=true) @PathVariable(value="artifactid") String var2);

    @ApiOperation(value="Get artifact content and metadata", notes="", response=Void.class, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Void.class), @ApiResponse(code=401, message="Unauthorized client", response=Void.class), @ApiResponse(code=403, message="Client not authorized to retrieve artifact", response=Void.class), @ApiResponse(code=404, message="Artifact not found", response=Void.class), @ApiResponse(code=502, message="Could not read from external resource", response=Void.class)})
    @RequestMapping(value={"/repos/{repository}/artifacts/{artifactid}"}, produces={"multipart/form-data"}, method={RequestMethod.GET})
    public ResponseEntity<StreamingResponseBody> reposArtifactsArtifactidGet(@ApiParam(value="Repository to add artifact into", required=true) @PathVariable(value="repository") String var1, @ApiParam(value="ArtifactInfo ID", required=true) @PathVariable(value="artifactid") String var2) throws IOException;

    @ApiOperation(value="Update artifact metadata", notes="", response=SolrArtifactIndexData.class, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Artifact updated", response=SolrArtifactIndexData.class), @ApiResponse(code=400, message="Invalid input", response=Void.class), @ApiResponse(code=401, message="Unauthorized client", response=Void.class), @ApiResponse(code=403, message="Client not authorized to update artifact", response=Void.class), @ApiResponse(code=404, message="Artifact not found", response=Void.class)})
    @RequestMapping(value={"/repos/{repository}/artifacts/{artifactid}"}, produces={"application/json"}, consumes={"multipart/form-data"}, method={RequestMethod.PUT})
    public ResponseEntity<String> reposArtifactsArtifactidPut(@ApiParam(value="Repository to add artifact into", required=true) @PathVariable(value="repository") String var1, @ApiParam(value="Artifact ID", required=true) @PathVariable(value="artifactid") String var2, @ApiParam(value="New commit status of artifact") @RequestPart(value="committed", required=false) Boolean var3);

    @ApiOperation(value="Query repository for artifacts", notes="", response=Object.class, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Object.class), @ApiResponse(code=400, message="Invalid input", response=Object.class), @ApiResponse(code=401, message="Unauthorized client", response=Object.class), @ApiResponse(code=403, message="Client not allowed to query repository", response=Object.class), @ApiResponse(code=404, message="Repository not found", response=Object.class), @ApiResponse(code=502, message="Error experienced with internal database", response=Object.class)})
    @RequestMapping(value={"/repos/{repository}/artifacts"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<String>> reposArtifactsGet(@ApiParam(value="", required=true) @PathVariable(value="repository") String var1, @ApiParam(value="Artifact ID") @RequestParam(value="artifact", required=false) String var2, @ApiParam(value="Artifact AUID") @RequestParam(value="auid", required=false) String var3, @ApiParam(value="Artifact URI") @RequestParam(value="uri", required=false) String var4, @ApiParam(value="Artifact URI aspect") @RequestParam(value="aspect", required=false) String var5, @ApiParam(value="Date and time associated with artifact's content") @RequestParam(value="timestamp", required=false) Integer var6, @ApiParam(value="Date and time of artifact acquistion into repository") @RequestParam(value="acquired", required=false) Integer var7, @ApiParam(value="Artifact content hash") @RequestParam(value="hash", required=false) String var8, @ApiParam(value="Artifact committed status", defaultValue="true") @RequestParam(value="committed", required=false, defaultValue="true") Boolean var9, @ApiParam(value="Query results will include all aspects if set to true (default: false)", defaultValue="false") @RequestParam(value="includeAllAspects", required=false, defaultValue="false") Boolean var10, @ApiParam(value="Includes all versions if set (default: false)", defaultValue="false") @RequestParam(value="includeAllVersions", required=false, defaultValue="false") Boolean var11, @ApiParam(value="Maximum number of results to return (used for pagination)", defaultValue="100") @RequestParam(value="limit", required=false, defaultValue="100") Integer var12, @ApiParam(value="Begin listing with given artifact (used for pagination)") @RequestParam(value="nextArtifact", required=false) String var13);

    @ApiOperation(value="Create an artifact", notes="", response=SolrArtifactIndexData.class, tags={})
    @ApiResponses(value={@ApiResponse(code=201, message="Artifact created", response=SolrArtifactIndexData.class), @ApiResponse(code=302, message="Duplicate content; artifact not created", response=Void.class), @ApiResponse(code=400, message="Invalid input", response=Void.class), @ApiResponse(code=401, message="Unauthorized client", response=Void.class), @ApiResponse(code=403, message="Client not authorized to create artifacts", response=Void.class), @ApiResponse(code=502, message="Internal error creating artifact", response=Void.class)})
    @RequestMapping(value={"/repos/{repository}/artifacts"}, produces={"application/json"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public ResponseEntity<String> reposArtifactsPost(@ApiParam(value="", required=true) @PathVariable(value="repository") String var1, @ApiParam(value="Archival Unit ID (AUID) of new artifact", required=true) @RequestPart(value="auid", required=true) String var2, @ApiParam(value="URI represented by this artifact", required=true) @RequestPart(value="uri", required=true) String var3, @ApiParam(value="Artifact version", required=true) @RequestPart(value="version", required=true) Integer var4, @ApiParam(value="Artifact") @RequestPart(value="artifact", required=true) MultipartFile var5, MultipartFile ... var6);
}

