/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.controller;

import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.lockss.laaws.rs.api.ReposApi;
import org.lockss.laaws.rs.io.index.ArtifactIndex;
import org.lockss.laaws.rs.io.index.ArtifactPredicateBuilder;
import org.lockss.laaws.rs.io.storage.ArtifactStore;
import org.lockss.laaws.rs.model.Artifact;
import org.lockss.laaws.rs.model.ArtifactIndexData;
import org.lockss.laaws.rs.util.ArtifactFactory;
import org.lockss.laaws.rs.util.ArtifactUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@Controller
public class ReposApiController
implements ReposApi {
    private static final Log log = LogFactory.getLog(ReposApiController.class);
    @Autowired
    ArtifactStore artifactStore;
    @Autowired
    ArtifactIndex artifactIndex;
    public static final String APPLICATION_HTTP_RESPONSE_VALUE = "application/http;msgtype=response";
    public static final MediaType APPLICATION_HTTP_RESPONSE = MediaType.parseMediaType((String)"application/http;msgtype=response");

    @Override
    public ResponseEntity<List<String>> reposGet() {
        ArrayList collectionIds = new ArrayList();
        this.artifactIndex.getCollectionIds().forEachRemaining(x -> collectionIds.add(x));
        return new ResponseEntity(collectionIds, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<Void> reposArtifactsArtifactidDelete(@ApiParam(value="Repository to add artifact into", required=true) @PathVariable(value="repository") String repository, @ApiParam(value="Artifact ID", required=true) @PathVariable(value="artifactid") String artifactid) {
        if (!this.artifactIndex.artifactExists(artifactid)) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        this.artifactStore.deleteArtifact(this.artifactIndex.getArtifactIndexData(artifactid));
        this.artifactIndex.deleteArtifact(artifactid);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Override
    public ResponseEntity<StreamingResponseBody> reposArtifactsArtifactidGet(@ApiParam(value="Repository to add artifact into", required=true) @PathVariable(value="repository") String repository, @ApiParam(value="Artifact ID", required=true) @PathVariable(value="artifactid") String artifactId) throws IOException {
        if (!this.artifactIndex.artifactExists(artifactId)) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        Object artifact = this.artifactStore.getArtifact(this.artifactIndex.getArtifactIndexData(artifactId));
        log.info((Object)String.format("Retrieving artifact: %s from collection %s", artifactId, repository));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/http; msgtype=response"));
        return new ResponseEntity(outputStream -> {
            try {
                ArtifactUtil.writeHttpResponse((HttpResponse)ArtifactUtil.getHttpResponseFromArtifact((Artifact)artifact), (OutputStream)outputStream);
            }
            catch (HttpException e) {
                e.printStackTrace();
            }
        }, (MultiValueMap)headers, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<String> reposArtifactsArtifactidPut(@ApiParam(value="Repository to add artifact into", required=true) @PathVariable(value="repository") String repository, @ApiParam(value="Artifact ID", required=true) @PathVariable(value="artifactid") String artifactid, @ApiParam(value="New commit status of artifact") @RequestPart(value="committed", required=false) Boolean committed) {
        if (!this.artifactIndex.artifactExists(artifactid)) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        if (committed == null) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        ArtifactIndexData indexData = this.artifactIndex.getArtifactIndexData(artifactid);
        log.info((Object)String.format("Updating commit status for %s (%s -> %s)", artifactid, indexData.getCommitted(), committed));
        this.artifactIndex.commitArtifact(artifactid);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Override
    public ResponseEntity<List<String>> reposArtifactsGet(@ApiParam(value="Collection ID", required=true) @PathVariable(value="repository") String repository, @ApiParam(value="Artifact ID") @RequestParam(value="artifact", required=false) String artifact, @ApiParam(value="Artifact AUID") @RequestParam(value="auid", required=false) String auid, @ApiParam(value="Artifact URI") @RequestParam(value="uri", required=false) String uri, @ApiParam(value="Artifact aspect") @RequestParam(value="aspect", required=false) String aspect, @ApiParam(value="Date and time associated with artifact's content") @RequestParam(value="timestamp", required=false) Integer timestamp, @ApiParam(value="Date and time of artifact acquisition into repository") @RequestParam(value="acquired", required=false) Integer acquired, @ApiParam(value="Artifact content digest") @RequestParam(value="hash", required=false) String hash, @ApiParam(value="Artifact committed status", defaultValue="true") @RequestParam(value="committed", required=false, defaultValue="true") Boolean committed, @ApiParam(value="Include artifact aspects in results (default: false)", defaultValue="false") @RequestParam(value="includeAllAspects", required=false, defaultValue="false") Boolean includeAllAspects, @ApiParam(value="Includes all versions if set (default: false)", defaultValue="false") @RequestParam(value="includeAllVersions", required=false, defaultValue="false") Boolean includeAllVersions, @ApiParam(value="Maximum number of results to return (used for pagination)", defaultValue="1000") @RequestParam(value="limit", required=false, defaultValue="1000") Integer limit, @ApiParam(value="Begin listing with given artifact (used for pagination)") @RequestParam(value="next_artifact", required=false) String nextArtifact) {
        ArtifactPredicateBuilder query = new ArtifactPredicateBuilder().filterByCommitStatus(committed).filterByCollection(repository).filterByAuid(auid).filterByURIPrefix(uri);
        Iterator<ArtifactIndexData> result = this.artifactIndex.query(query);
        ArrayList artifacts = new ArrayList();
        result.forEachRemaining(x -> artifacts.add(x.getId()));
        return new ResponseEntity(artifacts, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<String> reposArtifactsPost(@ApiParam(value="", required=true) @PathVariable(value="repository") String repository, @ApiParam(value="Archival Unit ID (AUID) of new artifact", required=true) @RequestPart(value="auid", required=true) String auid, @ApiParam(value="URI represented by this artifact", required=true) @RequestPart(value="uri", required=true) String uri, @ApiParam(value="Artifact version", required=true) @RequestPart(value="version", required=true) Integer version, @ApiParam(value="Artifact") @RequestPart(value="artifact", required=true) MultipartFile artifactPart, MultipartFile ... aspectParts) {
        log.info((Object)String.format("%s, %s, %s", repository, auid, uri));
        String artifactId = null;
        try {
            log.info((Object)String.format("MultipartFile: Type: Artifact, Content-type: %s", artifactPart.getContentType()));
            if (!ReposApiController.isHttpResponseType(MediaType.parseMediaType((String)artifactPart.getContentType())).booleanValue()) {
                log.error((Object)String.format("Failed to add artifact; expected %s but got %s", APPLICATION_HTTP_RESPONSE, MediaType.parseMediaType((String)artifactPart.getContentType())));
                return new ResponseEntity(HttpStatus.BAD_REQUEST);
            }
            Artifact artifact = ArtifactFactory.fromHttpResponseStream((InputStream)artifactPart.getInputStream());
            this.artifactStore.addArtifact(artifact);
            ArtifactIndexData id = this.artifactIndex.indexArtifact(artifact);
            artifactId = id.getId();
            for (MultipartFile aspectPart : aspectParts) {
                log.warn((Object)String.format("Ignoring MultipartFile: Type: Aspect, Content-type: %s", aspectPart.getContentType()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ResponseEntity(artifactId, HttpStatus.OK);
    }

    private static Boolean isHttpResponseType(MediaType type) {
        return APPLICATION_HTTP_RESPONSE.isCompatibleWith(type) && type.getParameters().equals(APPLICATION_HTTP_RESPONSE.getParameters());
    }
}

