/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.io.index;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.lockss.laaws.rs.model.ArtifactIndexData;

public class ArtifactPredicateBuilder {
    private Set<Predicate<ArtifactIndexData>> predicates = new HashSet<Predicate<ArtifactIndexData>>();

    public ArtifactPredicateBuilder filterByAuid(String auid) {
        if (auid != null) {
            this.predicates.add(x -> x.getAuid().equals(auid));
        }
        return this;
    }

    public ArtifactPredicateBuilder filterByCommitStatus(Boolean committedStatus) {
        if (committedStatus != null) {
            this.predicates.add(artifact -> artifact.getCommitted() == committedStatus);
        }
        return this;
    }

    public ArtifactPredicateBuilder filterByCollection(String collection) {
        if (collection != null) {
            this.predicates.add(artifact -> artifact.getCollection().equals(collection));
        }
        return this;
    }

    public ArtifactPredicateBuilder filterByURIPrefix(String prefix) {
        if (prefix != null) {
            this.predicates.add(artifact -> artifact.getUri().startsWith(prefix));
        }
        return this;
    }

    public Predicate<ArtifactIndexData> build() {
        return this.predicates.stream().reduce(Predicate::and).orElse(include -> false);
    }
}

